/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PropertyRangeRedundancyTest
extends AbstractOWLTest
implements RDFPropertyTest,
RepairableOWLTest {
    public PropertyRangeRedundancyTest() {
        super("Sanity Tests", "Range of a property should not contain redundant classes");
    }

    public static Collection fails(OWLObjectProperty oWLObjectProperty) {
        HashSet<Cls> hashSet = new HashSet<Cls>();
        Collection collection = oWLObjectProperty.getUnionRangeClasses();
        if (collection.size() >= 2) {
            for (Cls cls : collection) {
                for (Cls cls2 : collection) {
                    if (cls2.equals(cls) || !cls.hasSuperclass(cls2)) continue;
                    hashSet.add(cls);
                }
            }
        }
        return hashSet;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        RDFResource rDFResource = oWLTestResult.getHost();
        if (rDFResource instanceof OWLObjectProperty) {
            OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)rDFResource;
            Collection collection = PropertyRangeRedundancyTest.fails(oWLObjectProperty);
            ArrayList arrayList = new ArrayList(oWLObjectProperty.getUnionRangeClasses());
            arrayList.removeAll(collection);
            oWLObjectProperty.setUnionRangeClasses(arrayList);
            return PropertyRangeRedundancyTest.fails(oWLObjectProperty).isEmpty();
        }
        return false;
    }

    public List test(RDFProperty rDFProperty) {
        Collection collection;
        if (rDFProperty instanceof OWLObjectProperty && !(collection = PropertyRangeRedundancyTest.fails((OWLObjectProperty)rDFProperty)).isEmpty()) {
            String string = collection.size() > 1 ? "es " : " ";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Cls cls = (Cls)iterator.next();
                string = string + cls.getBrowserText();
                if (!iterator.hasNext()) continue;
                string = string + ", ";
            }
            return Collections.singletonList(new DefaultOWLTestResult("The range of " + rDFProperty.getBrowserText() + " contains the redundant class" + string + ".", rDFProperty, 2, this));
        }
        return Collections.EMPTY_LIST;
    }
}

