/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.owldl;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLDLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TransitivePropertiesCannotBeFunctionalOWLDLTest
extends AbstractOWLTest
implements OWLDLTest,
RDFPropertyTest,
RepairableOWLTest {
    public TransitivePropertiesCannotBeFunctionalOWLDLTest() {
        super("OWL-DL Tests", null);
    }

    public static boolean fails(RDFProperty rDFProperty) {
        if (rDFProperty instanceof OWLObjectProperty && ((OWLObjectProperty)rDFProperty).isTransitive()) {
            return TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(rDFProperty, new HashSet());
        }
        return false;
    }

    private static boolean isFunctional(Slot slot, Set set) {
        if (!set.contains(slot)) {
            set.add(slot);
            if (slot instanceof OWLObjectProperty) {
                OWLObjectProperty oWLObjectProperty = (OWLObjectProperty)slot;
                if (oWLObjectProperty.isFunctional() || oWLObjectProperty.isInverseFunctional()) {
                    return true;
                }
                for (Slot slot2 : slot.getDirectSuperslots()) {
                    if (!TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(slot2, set)) continue;
                    return true;
                }
                Slot slot3 = slot.getInverseSlot();
                if (slot3 != null && TransitivePropertiesCannotBeFunctionalOWLDLTest.isFunctional(slot3, set)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean repair(OWLTestResult oWLTestResult) {
        OWLProperty oWLProperty = (OWLProperty)oWLTestResult.getHost();
        oWLProperty.setFunctional(false);
        oWLProperty.setInverseFunctional(false);
        return !TransitivePropertiesCannotBeFunctionalOWLDLTest.fails(oWLProperty);
    }

    public List test(RDFProperty rDFProperty) {
        if (TransitivePropertiesCannotBeFunctionalOWLDLTest.fails(rDFProperty)) {
            return Collections.singletonList(new DefaultOWLTestResult("Transitive properties (or inverse or super properties of them) cannot be functional (or inverse functional) in OWL DL.", rDFProperty, 3, this));
        }
        return Collections.EMPTY_LIST;
    }
}

