/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.util;

import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLOWLUtil {
    public static JenaOWLModel createJenaOWLModel(String string) throws SWRLOWLUtilException {
        JenaOWLModel jenaOWLModel = null;
        try {
            jenaOWLModel = ProtegeOWL.createJenaOWLModelFromURI(new File(string).toURI().toString());
        }
        catch (Exception exception) {
            SWRLOWLUtil.throwException("Error opening OWL file '" + string + "': " + exception.getMessage());
        }
        return jenaOWLModel;
    }

    public static JenaOWLModel createJenaOWLModel() throws SWRLOWLUtilException {
        JenaOWLModel jenaOWLModel = null;
        try {
            jenaOWLModel = ProtegeOWL.createJenaOWLModel();
        }
        catch (Exception exception) {
            throw new SWRLOWLUtilException("error creating Jena OWL model: " + exception.getMessage());
        }
        return jenaOWLModel;
    }

    public static void importOWLFile(JenaOWLModel jenaOWLModel, String string) throws SWRLOWLUtilException {
        try {
            ImportHelper importHelper = new ImportHelper(jenaOWLModel);
            URI uRI = URIUtilities.createURI((String)new File(string).toURI().toString());
            importHelper.addImport(uRI);
            importHelper.importOntologies(false);
        }
        catch (Exception exception) {
            SWRLOWLUtil.throwException("error importing OWL file '" + string + "': " + exception.getMessage());
        }
    }

    public static void writeJenaOWLModel2File(JenaOWLModel jenaOWLModel, String string) throws SWRLOWLUtilException {
        ArrayList arrayList = new ArrayList();
        URI uRI = URIUtilities.createURI((String)new File(string).toURI().toString());
        jenaOWLModel.save(uRI, "RDF/XML-ABBREV", arrayList);
        if (arrayList.size() != 0) {
            SWRLOWLUtil.throwException("error creating output OWL file '" + string + "': " + arrayList);
        }
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, string, null);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, oWLNamedClass, string2);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, OWLNamedClass oWLNamedClass) throws SWRLOWLUtilException {
        return SWRLOWLUtil.createIndividualOfClass(oWLModel, oWLNamedClass, null);
    }

    public static OWLIndividual createIndividualOfClass(OWLModel oWLModel, OWLNamedClass oWLNamedClass, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = oWLNamedClass.createOWLIndividual(string);
        if (oWLIndividual == null) {
            SWRLOWLUtil.throwException("could not create individual '" + string + "' of class '" + oWLNamedClass.getName() + "'");
        }
        return oWLIndividual;
    }

    public static OWLNamedClass getClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getClass(oWLModel, string, true);
    }

    public static boolean isIndividualOfClass(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string2);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string);
        return oWLIndividual.hasRDFType(oWLNamedClass, true);
    }

    public static OWLIndividual getIndividual(OWLModel oWLModel, OWLNamedClass oWLNamedClass, boolean bl, int n) throws SWRLOWLUtilException {
        Object var4_4 = null;
        if (bl && oWLNamedClass.getInstanceCount(true) == 0) {
            SWRLOWLUtil.throwException("no individuals of class '" + oWLNamedClass.getName() + "' in ontology");
        } else if (oWLNamedClass.getInstanceCount(true) != n) {
            SWRLOWLUtil.throwException("expecting exactly " + n + " individuals of class '" + oWLNamedClass.getName() + "' in ontology - got " + oWLNamedClass.getInstanceCount(true) + "");
        }
        Collection collection = oWLNamedClass.getInstances();
        if (!collection.isEmpty()) {
            Object e = oWLNamedClass.getInstances(true).iterator().next();
            if (e instanceof OWLIndividual) {
                return (OWLIndividual)e;
            }
            throw new SWRLOWLUtilException("instance of class '" + oWLNamedClass.getName() + "' is not an OWL individual");
        }
        return null;
    }

    public static Set<OWLIndividual> getAllIndividuals(OWLModel oWLModel) throws SWRLOWLUtilException {
        return new HashSet<OWLIndividual>(oWLModel.getOWLIndividuals());
    }

    public static Set<OWLIndividual> getIndividuals(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return new HashSet<OWLIndividual>(SWRLOWLUtil.getIndividuals(oWLNamedClass));
    }

    public static Set<OWLIndividual> getIndividuals(OWLNamedClass oWLNamedClass) throws SWRLOWLUtilException {
        return new HashSet<OWLIndividual>(oWLNamedClass.getInstances(true));
    }

    public static OWLProperty getProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getProperty(oWLModel, string, true);
    }

    public static OWLDatatypeProperty getDatatypeProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLDatatypeProperty oWLDatatypeProperty = oWLModel.getOWLDatatypeProperty(string);
        if (bl && oWLDatatypeProperty == null) {
            SWRLOWLUtil.throwException("no '" + string + "' datatype property in ontology");
        }
        return oWLDatatypeProperty;
    }

    public static OWLObjectProperty getObjectProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLObjectProperty oWLObjectProperty = oWLModel.getOWLObjectProperty(string);
        if (bl && oWLObjectProperty == null) {
            SWRLOWLUtil.throwException("no '" + string + "' object property in ontology");
        }
        return oWLObjectProperty;
    }

    public static boolean isEquivalentProperty(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.getEquivalentProperties().contains(oWLProperty2);
    }

    public static boolean isEquivalentClass(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.hasEquivalentClass(oWLNamedClass2);
    }

    public static boolean isDisjointClass(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.getDisjointClasses().contains(oWLNamedClass2);
    }

    public static boolean isSubPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.isSubpropertyOf(oWLProperty2, true);
    }

    public static boolean isSuperPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty2.isSubpropertyOf(oWLProperty, true);
    }

    public static boolean isDirectSuperPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty2.isSubpropertyOf(oWLProperty, false);
    }

    public static boolean isDirectSubPropertyOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLProperty oWLProperty2 = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        return oWLProperty != null && oWLProperty2 != null && oWLProperty.isSubpropertyOf(oWLProperty2, false);
    }

    public static boolean isDirectSubClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass.isSubclassOf(oWLNamedClass2);
    }

    public static boolean isSubClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.getSubclasses().contains(oWLNamedClass);
    }

    public static boolean isDirectSuperClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.isSubclassOf(oWLNamedClass);
    }

    public static boolean isSuperClassOf(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isSuperClassOf(oWLModel, string, string2, true);
    }

    public static boolean isSuperClassOf(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLNamedClass != null && oWLNamedClass2 != null && oWLNamedClass2.getSuperclasses(true).contains(oWLNamedClass);
    }

    public static int getNumberOfIndividualsOfClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getNumberOfIndividualsOfClass(oWLModel, string, true);
    }

    public static int getNumberOfIndividualsOfClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        int n = 0;
        if (oWLNamedClass != null) {
            n = oWLNamedClass.getInstances(true).size();
        }
        return n;
    }

    public static int getNumberOfDirectInstancesOfClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        int n = 0;
        if (oWLNamedClass != null) {
            n = oWLNamedClass.getInstances(false).size();
        }
        return n;
    }

    public static boolean isConsistentClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string, bl);
        return oWLNamedClass != null && oWLNamedClass.isConsistent();
    }

    public static Set<OWLNamedClass> getDomainClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDomainClasses(oWLModel, string, true, true);
    }

    public static Set<OWLNamedClass> getDomainClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDomainClasses(oWLModel, string, bl, true);
    }

    public static Set<OWLNamedClass> getDirectDomainClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDomainClasses(oWLModel, string, true, false);
    }

    public static Set<OWLNamedClass> getDirectDomainClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDomainClasses(oWLModel, string, bl, false);
    }

    private static Set<OWLNamedClass> getDomainClasses(OWLModel oWLModel, String string, boolean bl, boolean bl2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLProperty.getUnionDomain(bl2);
        if (collection == null) {
            return hashSet;
        }
        for (Object e : collection) {
            if (!(e instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)e);
        }
        return hashSet;
    }

    public static Set<OWLNamedClass> getRangeClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getRangeClasses(oWLModel, string, bl, true);
    }

    public static Set<OWLNamedClass> getRangeClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getRangeClasses(oWLModel, string, true, true);
    }

    public static Set<OWLNamedClass> getDirectRangeClasses(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getRangeClasses(oWLModel, string, bl, false);
    }

    public static Set<OWLNamedClass> getDirectRangeClasses(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getRangeClasses(oWLModel, string, true, false);
    }

    private static Set<OWLNamedClass> getRangeClasses(OWLModel oWLModel, String string, boolean bl, boolean bl2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLProperty.getUnionRangeClasses();
        if (collection == null) {
            return hashSet;
        }
        for (RDFResource rDFResource : collection) {
            if (!(rDFResource instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)rDFResource);
        }
        return hashSet;
    }

    public static boolean isInPropertyDomain(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getDomains(true).contains(oWLNamedClass);
    }

    public static boolean isInDirectPropertyDomain(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getDomains(false).contains(oWLNamedClass);
    }

    public static boolean isInPropertyRange(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getRanges(true).contains(oWLNamedClass);
    }

    public static boolean isInDirectPropertyRange(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string2, bl);
        return oWLProperty != null && oWLNamedClass != null && oWLProperty.getRanges(false).contains(oWLNamedClass);
    }

    public static boolean isObjectProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isObjectProperty();
    }

    public static boolean isOWLIndividual(OWLModel oWLModel, String string) {
        return oWLModel.getOWLIndividual(string) != null;
    }

    public static boolean isObjectProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isObjectProperty(oWLModel, string, true);
    }

    public static boolean isDatatypeProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && !oWLProperty.isObjectProperty();
    }

    public static boolean isDatatypeProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isDatatypeProperty(oWLModel, string, true);
    }

    public static boolean isTransitiveProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty instanceof OWLObjectProperty && ((OWLObjectProperty)oWLProperty).isTransitive();
    }

    public static boolean isTransitiveProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isTransitiveProperty(oWLModel, string, true);
    }

    public static boolean isSymmetricProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty instanceof OWLObjectProperty && ((OWLObjectProperty)oWLProperty).isSymmetric();
    }

    public static boolean isFunctionalProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isFunctional();
    }

    public static boolean isAnnotationProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isAnnotationProperty();
    }

    public static boolean isInverseFunctionalProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        return oWLProperty != null && oWLProperty.isInverseFunctional();
    }

    public static OWLIndividual getIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLIndividual))) {
            SWRLOWLUtil.throwException("no individual named '" + string + "' in ontology");
        }
        if (rDFResource != null) {
            if (rDFResource instanceof OWLIndividual) {
                return (OWLIndividual)rDFResource;
            }
            return null;
        }
        return null;
    }

    public static OWLNamedClass getClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLNamedClass))) {
            SWRLOWLUtil.throwException("no class named '" + string + "' in ontology");
        }
        if (rDFResource != null) {
            if (rDFResource instanceof OWLNamedClass) {
                return (OWLNamedClass)rDFResource;
            }
            return null;
        }
        return null;
    }

    public static Set<OWLNamedClass> getClassesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getClassesOfIndividual(oWLModel, string, true);
    }

    public static Set<OWLNamedClass> getClassesOfIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        return oWLIndividual == null ? new HashSet() : SWRLOWLUtil.getClassesOfIndividual(oWLModel, oWLIndividual);
    }

    public static Set<OWLNamedClass> getClassesOfIndividual(OWLModel oWLModel, OWLIndividual oWLIndividual) throws SWRLOWLUtilException {
        HashSet<OWLNamedClass> hashSet = new HashSet<OWLNamedClass>();
        Collection collection = oWLIndividual.getRDFTypes();
        for (RDFResource rDFResource : collection) {
            if (!(rDFResource instanceof OWLNamedClass)) continue;
            hashSet.add((OWLNamedClass)rDFResource);
        }
        return hashSet;
    }

    public static OWLProperty getProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (bl && (rDFResource == null || !(rDFResource instanceof OWLProperty))) {
            SWRLOWLUtil.throwException("no property named '" + string + "' in ontology");
        }
        return rDFResource instanceof OWLProperty ? (OWLProperty)rDFResource : null;
    }

    public static OWLIndividual getIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getIndividual(oWLModel, string, true);
    }

    public static boolean isClass(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isClass(oWLModel, string, true);
    }

    public static boolean isClass(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getClass(oWLModel, string, bl) != null;
    }

    public static boolean isProperty(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.isProperty(oWLModel, string, true);
    }

    public static boolean isProperty(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getProperty(oWLModel, string, bl) != null;
    }

    public static Collection<OWLNamedClass> getUserDefinedOWLNamedClasses(OWLModel oWLModel) {
        return new ArrayList<OWLNamedClass>(oWLModel.getUserDefinedOWLNamedClasses());
    }

    public static Collection<OWLProperty> getUserDefinedOWLProperties(OWLModel oWLModel) {
        return new ArrayList<OWLProperty>(oWLModel.getUserDefinedOWLProperties());
    }

    public static Collection<OWLProperty> getUserDefinedOWLObjectProperties(OWLModel oWLModel) {
        return new ArrayList<OWLProperty>(oWLModel.getUserDefinedOWLObjectProperties());
    }

    public static Collection<OWLProperty> getUserDefinedOWLDatatypeProperties(OWLModel oWLModel) {
        return new ArrayList<OWLProperty>(oWLModel.getUserDefinedOWLDatatypeProperties());
    }

    public static boolean isIndividual(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getIndividual(oWLModel, string, bl) != null;
    }

    public static boolean isSWRLVariable(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getIndividual(oWLModel, string, bl) != null && SWRLOWLUtil.getIndividual(oWLModel, string, bl) instanceof SWRLVariable;
    }

    public static boolean isIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getIndividual(oWLModel, string, true) != null;
    }

    public static int getNumberOfPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        return oWLIndividual.getPropertyValues(oWLProperty).size();
    }

    public static Set<OWLProperty> getPropertiesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, true);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLIndividual.getRDFProperties();
        for (RDFProperty rDFProperty : collection) {
            if (!(rDFProperty instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)rDFProperty);
        }
        return hashSet;
    }

    public static Set<OWLProperty> getPossiblePropertiesOfIndividual(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, true);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLIndividual.getPossibleRDFProperties();
        for (RDFProperty rDFProperty : collection) {
            if (!(rDFProperty instanceof OWLProperty)) continue;
            hashSet.add((OWLProperty)rDFProperty);
        }
        return hashSet;
    }

    public static String getURI(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        if (rDFResource == null) {
            SWRLOWLUtil.throwException("invalid resource '" + string + "'");
        }
        return rDFResource.getURI();
    }

    public static int getNumberOfPropertyValues(OWLModel oWLModel, String string, String string2, Object object, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        int n = 0;
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property '" + string2 + "' for OWL individual '" + string + "'");
        }
        for (Object e : oWLIndividual.getPropertyValues(oWLProperty)) {
            if (e instanceof RDFResource) {
                RDFResource rDFResource = (RDFResource)e;
                String string3 = rDFResource.getName();
                if (!string3.equals(object)) continue;
                ++n;
                continue;
            }
            if (!e.equals(object)) continue;
            ++n;
        }
        return n;
    }

    public static void addPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, Object object) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = oWLModel.getOWLProperty(string);
        if (oWLIndividual == null) {
            SWRLOWLUtil.throwException("null value for individual");
        }
        if (oWLProperty == null) {
            SWRLOWLUtil.throwException("no '" + string + "' property in ontology");
        }
        if (object == null) {
            SWRLOWLUtil.throwException("null value for property '" + string + "' for OWL individual '" + oWLIndividual.getName() + "'");
        }
        oWLIndividual.addPropertyValue(oWLProperty, object);
    }

    public static Object getObjectPropertyValue(OWLIndividual oWLIndividual, OWLProperty oWLProperty) throws SWRLOWLUtilException {
        return oWLIndividual.getPropertyValue(oWLProperty);
    }

    public static Set<Object> getObjectPropertyValues(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, string, string2, false);
    }

    public static Set<Object> getObjectPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, oWLIndividual.getName(), string, false);
    }

    public static Set<Object> getObjectPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValues(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static Set<Object> getObjectPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        HashSet<Object> hashSet = new HashSet<Object>();
        if (oWLIndividual != null && oWLProperty != null) {
            Iterator iterator = oWLIndividual.getPropertyValues(oWLProperty).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }

    public static Object getObjectPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual, string, true);
    }

    public static Object getObjectPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getObjectPropertyValue(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static Object getObjectPropertyValue(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        Object object;
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string2, true);
        Object object2 = object = oWLProperty == null && oWLIndividual == null ? null : oWLIndividual.getPropertyValue(oWLProperty);
        if (bl && oWLProperty == null) {
            SWRLOWLUtil.throwException("no property '" + string2 + "' associated with individual '" + oWLIndividual.getName() + "'");
        }
        return object;
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        Object object;
        OWLIndividual oWLIndividual = SWRLOWLUtil.getIndividual(oWLModel, string, bl);
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string2, bl);
        Object object2 = object = oWLIndividual == null || oWLProperty == null ? null : oWLIndividual.getPropertyValue(oWLProperty);
        if (bl && object == null) {
            SWRLOWLUtil.throwException("no property '" + string2 + "' associated with individual '" + string + "'");
        }
        return object;
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual.getName(), string, bl);
    }

    public static Object getDatavaluedPropertyValue(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual.getName(), oWLProperty.getName(), bl);
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, true);
        Collection collection = oWLProperty == null ? null : oWLIndividual.getPropertyValues(oWLProperty);
        HashSet hashSet = new HashSet();
        if (oWLProperty.isObjectProperty()) {
            SWRLOWLUtil.throwException("expecting datatype property '" + string + "' for '" + oWLIndividual.getName() + "'");
        }
        if (bl && collection == null) {
            SWRLOWLUtil.throwException("no property '" + string + "' associated with individual '" + oWLIndividual.getName() + "'");
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return new HashSet<Object>(collection);
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValues(oWLModel, string, string2, bl);
    }

    public static Set<Object> getDatavaluedPropertyValues(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValues(oWLModel, string, string2, true);
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, bl);
        int n = -1;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SWRLOWLUtil.throwException("cannot convert property value '" + string2 + "' of property '" + string + "' associated with individual '" + oWLIndividual.getName() + "' to integer");
        }
        return n;
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsInteger(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsInteger(oWLModel, oWLIndividual, string, true);
    }

    public static int getDatavaluedPropertyValueAsInteger(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsInteger(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        String string2 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, bl);
        long l = -1L;
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SWRLOWLUtilException("Cannot convert property value '" + string2 + "' of property '" + string + "' associated with individual '" + oWLIndividual.getName() + "' to long");
        }
        return l;
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsLong(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsLong(oWLModel, oWLIndividual, string, true);
    }

    public static long getDatavaluedPropertyValueAsLong(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsLong(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, string, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        if (oWLProperty == null) {
            return null;
        }
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, oWLProperty, bl);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2, boolean bl, String string3) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl, string3);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl, String string2) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string, bl);
        if (oWLProperty == null) {
            return string2;
        }
        String string3 = SWRLOWLUtil.getDatavaluedPropertyValueAsString(oWLModel, oWLIndividual, oWLProperty, bl);
        return string3 == null ? string2 : string3;
    }

    public static String getDatavaluedPropertyValueAsString(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        String string = null;
        if (object instanceof Boolean) {
            Boolean bl2 = (Boolean)object;
            string = bl2 != false ? "true" : "false";
        }
        string = object == null ? null : object.toString();
        return string;
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, String string, String string2, boolean bl) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsBoolean(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, bl);
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsBoolean(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, string, bl);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Boolean)) {
            SWRLOWLUtil.throwException("property value for '" + string + "' associated with individual '" + oWLIndividual.getName() + "' is not a Boolean");
        }
        return (Boolean)object;
    }

    public static Boolean getDatavaluedPropertyValueAsBoolean(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Boolean)) {
            SWRLOWLUtil.throwException("property value for " + oWLProperty.getName() + " in individual " + oWLIndividual.getName() + " is not a Boolean");
        }
        return (Boolean)object;
    }

    public static Collection getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, String string) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsCollection(oWLModel, oWLIndividual, string, false);
    }

    public static Collection getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, String string, String string2) throws SWRLOWLUtilException {
        return SWRLOWLUtil.getDatavaluedPropertyValueAsCollection(oWLModel, SWRLOWLUtil.getIndividual(oWLModel, string), string2, true);
    }

    public static Collection getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, String string, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, string, bl);
        Collection<Object> collection = new ArrayList<Object>();
        if (object == null) {
            return collection;
        }
        if (object instanceof RDFSLiteral) {
            collection.add(object);
        } else if (object instanceof Collection) {
            collection = (Collection)object;
        } else {
            SWRLOWLUtil.throwException("property value for '" + string + "' associated with individual '" + oWLIndividual.getName() + "' is not a Collection");
        }
        return collection;
    }

    public static Collection getDatavaluedPropertyValueAsCollection(OWLModel oWLModel, OWLIndividual oWLIndividual, OWLProperty oWLProperty, boolean bl) throws SWRLOWLUtilException {
        Object object = SWRLOWLUtil.getDatavaluedPropertyValue(oWLModel, oWLIndividual, oWLProperty, bl);
        Collection<Object> collection = new ArrayList<Object>();
        if (object == null) {
            return collection;
        }
        if (object instanceof RDFSLiteral) {
            collection.add(object);
        } else if (object instanceof Collection) {
            collection = (Collection)object;
        } else {
            SWRLOWLUtil.throwException("property value for '" + oWLProperty.getName() + "' associated with individual '" + oWLIndividual.getName() + "' is not a Collection");
        }
        return collection;
    }

    public static List<OWLNamedClass> getDirectSubClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return new ArrayList<OWLNamedClass>(oWLNamedClass.getNamedSubclasses(false));
    }

    public static List<OWLNamedClass> getSubClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return new ArrayList<OWLNamedClass>(oWLNamedClass.getNamedSubclasses(true));
    }

    public static List<OWLNamedClass> getDirectSuperClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return new ArrayList<OWLNamedClass>(oWLNamedClass.getNamedSuperclasses(false));
    }

    public static List<OWLNamedClass> getSuperClassesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        return new ArrayList<OWLNamedClass>(oWLNamedClass.getNamedSuperclasses(true));
    }

    public static List<OWLProperty> getDirectSubPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string);
        return new ArrayList<OWLProperty>(oWLProperty.getSubproperties(false));
    }

    public static List<OWLProperty> getSubPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string);
        return new ArrayList<OWLProperty>(oWLProperty.getSubproperties(true));
    }

    public static List<OWLProperty> getDirectSuperPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string);
        return new ArrayList<OWLProperty>(oWLProperty.getSuperproperties(false));
    }

    public static List<OWLProperty> getSuperPropertiesOf(OWLModel oWLModel, String string) throws SWRLOWLUtilException {
        OWLProperty oWLProperty = SWRLOWLUtil.getProperty(oWLModel, string);
        return new ArrayList<OWLProperty>(oWLProperty.getSuperproperties(true));
    }

    public static Set<OWLProperty> getDomainProperties(OWLModel oWLModel, String string, boolean bl) throws SWRLOWLUtilException {
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getClass(oWLModel, string);
        HashSet<OWLProperty> hashSet = new HashSet<OWLProperty>();
        Collection collection = oWLNamedClass.getUnionDomainProperties(bl);
        if (collection != null) {
            for (Object e : oWLNamedClass.getUnionDomainProperties()) {
                if (!(e instanceof OWLProperty)) continue;
                hashSet.add((OWLProperty)e);
            }
        }
        return hashSet;
    }

    public static Set<String> rdfResources2OWLNamedClassNames(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : collection) {
            if (!(e instanceof OWLNamedClass)) continue;
            hashSet.add(((OWLNamedClass)e).getName());
        }
        return hashSet;
    }

    public static Set<String> rdfResources2Names(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Object e : collection) {
            if (!(e instanceof RDFResource)) continue;
            hashSet.add(((RDFResource)e).getName());
        }
        return hashSet;
    }

    public static Set<String> rdfResources2NamesList(Collection<RDFResource> collection) throws SWRLOWLUtilException {
        HashSet<String> hashSet = new HashSet<String>();
        if (collection == null) {
            return hashSet;
        }
        for (RDFResource rDFResource : collection) {
            if (!(rDFResource instanceof RDFResource)) {
                SWRLOWLUtil.throwException("rdfResources2NamesList passed non-resource object '" + rDFResource + "'");
            }
            RDFResource rDFResource2 = rDFResource;
            hashSet.add(rDFResource2.getName());
        }
        return hashSet;
    }

    public static boolean hasInconsistentClasses(OWLModel oWLModel) {
        return !oWLModel.getInconsistentClasses().isEmpty();
    }

    public static String createNewResourceName(OWLModel oWLModel, String string) {
        return oWLModel.createNewResourceName(string);
    }

    public static OWLNamedClass getOWLThingClass(OWLModel oWLModel) {
        return oWLModel.getOWLThingClass();
    }

    public static RDFProperty getOWLSameAsProperty(OWLModel oWLModel) {
        return oWLModel.getOWLSameAsProperty();
    }

    public static Collection getOWLAllDifferents(OWLModel oWLModel) {
        return oWLModel.getOWLAllDifferents();
    }

    public static RDFProperty getOWLDifferentFromProperty(OWLModel oWLModel) {
        return oWLModel.getOWLDifferentFromProperty();
    }

    public static OWLProperty getOWLProperty(OWLModel oWLModel, String string) {
        return oWLModel.getOWLProperty(string);
    }

    public static OWLIndividual getOWLIndividual(OWLModel oWLModel, String string) {
        return oWLModel.getOWLIndividual(string);
    }

    public static RDFSNamedClass getRDFSNamedClass(OWLModel oWLModel, String string) {
        return oWLModel.getRDFSNamedClass(string);
    }

    public static OWLNamedClass getOWLNamedClass(OWLModel oWLModel, String string) {
        return oWLModel.getOWLNamedClass(string);
    }

    public static boolean isSWRLBuiltIn(OWLModel oWLModel, String string) {
        RDFResource rDFResource = oWLModel.getRDFResource(string);
        return rDFResource != null && rDFResource.getProtegeType().getName().equals("swrl:Builtin");
    }

    private static void throwException(String string) throws SWRLOWLUtilException {
        throw new SWRLOWLUtilException(string);
    }
}

