/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui.code;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.InstanceDisplay;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLSymbolPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.code.SWRLTextArea;
import edu.stanford.smi.protegex.owl.swrl.ui.widget.SWRLRuleSlotWidget;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SWRLTextAreaPanel
extends JPanel
implements ModalDialogFactory.CloseCallback {
    private static final String SWRL_RULE_PANEL_TITLE = "SWRL Rule";
    private OWLModel owlModel;
    private SWRLSymbolPanel symbolPanel;
    private SWRLTextArea textArea;

    public SWRLTextAreaPanel(OWLModel oWLModel) {
        this(oWLModel, null);
    }

    public SWRLTextAreaPanel(OWLModel oWLModel, SWRLImp sWRLImp) {
        this.owlModel = oWLModel;
        this.symbolPanel = new SWRLSymbolPanel(oWLModel, false, false);
        this.textArea = new SWRLTextArea(oWLModel, this.symbolPanel){

            protected void checkExpression(String string) throws Throwable {
                SWRLTextAreaPanel.this.owlModel.getOWLClassDisplay().getParser().checkClass(SWRLTextAreaPanel.this.owlModel, string);
            }
        };
        if (sWRLImp != null && sWRLImp.getHead() != null) {
            String string = sWRLImp.getBrowserText();
            this.textArea.setText(string);
            this.textArea.reformatText();
        }
        this.symbolPanel.setSymbolEditor(this.textArea);
    }

    public boolean canClose(int n) {
        if (n == 1) {
            String string = this.textArea.getText();
            if (string.length() == 0) {
                return false;
            }
            try {
                SWRLParser sWRLParser = new SWRLParser(this.owlModel);
                sWRLParser.parse(string);
                return true;
            }
            catch (Exception exception) {
                this.symbolPanel.displayError(exception);
                return false;
            }
        }
        return true;
    }

    public SWRLImp getResultAsImp() {
        try {
            String string = this.textArea.getText();
            SWRLParser sWRLParser = new SWRLParser(this.owlModel);
            sWRLParser.setParseOnly(false);
            return sWRLParser.parse(string);
        }
        catch (Exception exception) {
            Log.getLogger().warning("Error at parsing SWRL rule " + (this.textArea == null ? "" : this.textArea.getText()));
            return null;
        }
    }

    public String getResultAsString() {
        return this.textArea.getText();
    }

    public static boolean showEditDialog(Component component, OWLModel oWLModel, SWRLImp sWRLImp) {
        if (sWRLImp == null) {
            return false;
        }
        InstanceDisplay instanceDisplay = new InstanceDisplay(oWLModel.getProject(), false, false);
        instanceDisplay.setInstance((Instance)sWRLImp);
        SWRLTextAreaPanel.showFrame(instanceDisplay);
        return true;
    }

    private static JFrame showFrame(final InstanceDisplay instanceDisplay) {
        JFrame jFrame = ComponentFactory.createFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                int n;
                if (this.hasChangedRule(instanceDisplay) && (n = ModalDialog.showMessageDialog((Component)instanceDisplay, (String)"Rule has not been saved, probably because rule is invalid.\nIf you continue changes will be lost.\n\nDo you want to continue?", (String)"Rule not saved", (int)13)) == 3) {
                    return;
                }
                JFrame jFrame = (JFrame)windowEvent.getWindow();
                jFrame.setVisible(false);
                ComponentUtilities.dispose((Component)jFrame);
                Application.repaint();
            }

            private boolean hasChangedRule(InstanceDisplay instanceDisplay2) {
                try {
                    ClsWidget clsWidget = instanceDisplay2.getFirstClsWidget();
                    Slot slot = instanceDisplay2.getCurrentInstance().getKnowledgeBase().getSlot("swrl:body");
                    SWRLRuleSlotWidget sWRLRuleSlotWidget = (SWRLRuleSlotWidget)clsWidget.getSlotWidget(slot);
                    if (sWRLRuleSlotWidget.commitChanges()) {
                        return false;
                    }
                    String string = sWRLRuleSlotWidget.getSwrlTextAreaText();
                    SWRLImp sWRLImp = (SWRLImp)sWRLRuleSlotWidget.getInstance();
                    String string2 = SWRLTextArea.reformatText(sWRLImp.getBrowserText());
                    return !string2.equals(string);
                }
                catch (Exception exception) {
                    return false;
                }
            }
        });
        instanceDisplay.setResizeVertically(true);
        jFrame.getContentPane().add((Component)instanceDisplay, "Center");
        jFrame.setPreferredSize(new Dimension(500, 500));
        jFrame.setTitle(SWRL_RULE_PANEL_TITLE);
        ComponentUtilities.pack((Component)jFrame);
        ComponentUtilities.center((Component)jFrame);
        jFrame.setVisible(true);
        return jFrame;
    }
}

