/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ui;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.plugin.ProjectPluginAdapter;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.FormWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.ui.tab.SWRLTab;
import edu.stanford.smi.protegex.owl.swrl.ui.widget.SWRLRuleSlotWidget;
import edu.stanford.smi.protegex.owl.ui.metadata.NameDocumentationWidget;

public class SWRLProjectPlugin
extends ProjectPluginAdapter {
    public void afterLoad(Project project) {
        SWRLProjectPlugin.adjustGUI(project);
    }

    public static void adjustGUI(Project project) {
        if (!SWRLProjectPlugin.isSWRLPresent(project)) {
            return;
        }
        SWRLProjectPlugin.setSWRLClassesAndPropertiesVisible(project, false);
        SWRLProjectPlugin.adjustWidgets(project);
        SWRLProjectPlugin.addSWRLTab(project);
    }

    public static void setSWRLClassesAndPropertiesVisible(Project project, boolean bl) {
        OWLModel oWLModel = (OWLModel)project.getKnowledgeBase();
        SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
        for (RDFSNamedClass rDFResource : sWRLFactory.getSWRLClasses()) {
            rDFResource.setVisible(false);
        }
        for (RDFProperty rDFProperty : sWRLFactory.getSWRLProperties()) {
            rDFProperty.setVisible(false);
        }
        for (RDFProperty rDFProperty : sWRLFactory.getSWRLBProperties()) {
            rDFProperty.setVisible(false);
        }
        oWLModel.getRDFListClass().setVisible(false);
    }

    public static void adjustWidgets(Project project) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        Cls cls = knowledgeBase.getCls("swrl:Imp");
        if (cls == null) {
            return;
        }
        try {
            ClsWidget clsWidget = project.getDesignTimeClsWidget(cls);
            Slot slot = knowledgeBase.getSlot(":NAME");
            clsWidget.replaceWidget(slot, null);
            Slot slot2 = knowledgeBase.getSlot(ProtegeNames.Slot.INFERRED_TYPE);
            clsWidget.replaceWidget(slot2, null);
            Slot slot3 = knowledgeBase.getSlot("swrl:head");
            clsWidget.replaceWidget(slot3, null);
            Slot slot4 = knowledgeBase.getSlot("swrl:body");
            clsWidget.replaceWidget(slot4, null);
            clsWidget.replaceWidget(slot, NameDocumentationWidget.class.getName());
            clsWidget.replaceWidget(slot4, SWRLRuleSlotWidget.class.getName());
            ((FormWidget)clsWidget).setVerticalStretcher("swrl:body");
            ((FormWidget)clsWidget).setHorizontalStretcher("<<all>>");
            ((FormWidget)clsWidget).setModified(true);
        }
        catch (Exception exception) {
            Log.getLogger().warning("Error at configuring SWRL forms: " + exception.getMessage());
        }
    }

    private static void addSWRLTab(Project project) {
        WidgetDescriptor widgetDescriptor = project.getTabWidgetDescriptor(SWRLTab.class.getName());
        widgetDescriptor.setVisible(true);
    }

    private static boolean isSWRLPresent(Project project) {
        KnowledgeBase knowledgeBase = project.getKnowledgeBase();
        if (!(knowledgeBase instanceof OWLModel)) {
            return false;
        }
        Cls cls = knowledgeBase.getCls("swrl:Imp");
        return cls != null;
    }

    public static boolean isSWRLImported(OWLModel oWLModel) {
        return oWLModel.getOWLJavaFactory() instanceof SWRLJavaFactory;
    }
}

