/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.test;

import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.BridgeFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypePropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLRuleEngineException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;

public class SQWRLTest {
    private static JenaOWLModel owlModel;

    public static void main(String[] stringArray) {
        String string = "";
        if (stringArray.length == 1) {
            string = stringArray[0];
        } else {
            SQWRLTest.Usage();
        }
        try {
            JenaOWLModel jenaOWLModel = SWRLOWLUtil.createJenaOWLModel(string);
            SWRLRuleEngineBridge sWRLRuleEngineBridge = BridgeFactory.createBridge(jenaOWLModel);
            sWRLRuleEngineBridge.infer();
            for (OWLPropertyAssertionAxiom object : sWRLRuleEngineBridge.getInferredPropertyAssertionAxioms()) {
                if (!(object instanceof OWLDatatypePropertyAssertionAxiom)) continue;
                OWLDatatypePropertyAssertionAxiom oWLDatatypePropertyAssertionAxiom = (OWLDatatypePropertyAssertionAxiom)object;
            }
            SQWRLResult sQWRLResult = sWRLRuleEngineBridge.getSQWRLResult("Rule-6");
            while (sQWRLResult.hasNext()) {
                DatatypeValue datatypeValue = sQWRLResult.getDatatypeValue("?y");
                System.err.println("value: " + datatypeValue);
                System.err.println("value isString: " + datatypeValue.isString());
                System.err.println("value isBoolean: " + datatypeValue.isBoolean());
                sQWRLResult.next();
            }
        }
        catch (SQWRLException sQWRLException) {
            System.err.println("Exception: " + sQWRLException.getMessage());
            sQWRLException.printStackTrace();
        }
        catch (SWRLRuleEngineException sWRLRuleEngineException) {
            System.err.println("Exception: " + sWRLRuleEngineException.getMessage());
            sWRLRuleEngineException.printStackTrace();
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            System.err.println("Exception: " + sWRLOWLUtilException.getMessage());
            sWRLOWLUtilException.printStackTrace();
        }
    }

    private static void Usage() {
        System.err.println("Usage: SQWRLTest <owlFileName>");
        System.exit(1);
    }
}

