/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.ui;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.BridgeFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BridgePluginManager;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.ui.SWRLPluginGUIAdapter;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ui.SQWRLQueryControlPanel;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ui.icons.QueryIcons;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SQWRLQueryTab
extends JTabbedPane
implements SWRLPluginGUIAdapter {
    private SWRLRuleEngineBridge bridge;

    public Container getPluginGUI() {
        return this;
    }

    public Container createPluginGUI(OWLModel oWLModel) {
        try {
            this.bridge = BridgeFactory.createBridge(oWLModel);
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            System.err.println(sWRLRuleEngineBridgeException.toString());
            return this.makeErrorWindow(sWRLRuleEngineBridgeException.toString());
        }
        this.removeAll();
        SQWRLQueryControlPanel sQWRLQueryControlPanel = new SQWRLQueryControlPanel(this.bridge);
        this.addTab("SQWRLQueryTab", QueryIcons.getQueryIcon(), sQWRLQueryControlPanel, "Control Panel");
        return this;
    }

    private Container makeErrorWindow(String string) {
        this.removeAll();
        JPanel jPanel = new JPanel(false);
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        this.add(jPanel);
        return this;
    }

    static {
        BridgePluginManager.registerPlugin("SQWRLQueryTab", "Activate/deactivate SQWRLQueryTab", QueryIcons.getQueryIcon(), new SQWRLQueryTab());
    }
}

