/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.ui;

import edu.stanford.smi.protegex.owl.swrl.bridge.BridgePluginManager;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLQueryEngine;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ui.SQWRLQueryResultPanel;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class SQWRLQueryControlPanel
extends JPanel {
    private SQWRLQueryEngine queryEngine;
    private HashMap<String, SQWRLQueryResultPanel> resultPanels;
    private JTextArea textArea;
    private static int MaximumOpenResultPanels = 8;

    public SQWRLQueryControlPanel(SQWRLQueryEngine sQWRLQueryEngine) {
        this.queryEngine = sQWRLQueryEngine;
        this.resultPanels = new HashMap();
        this.setLayout(new BorderLayout());
        this.textArea = this.createTextArea();
        JScrollPane jScrollPane = new JScrollPane(this.textArea);
        jScrollPane.setPreferredSize(new Dimension(900, 300));
        this.add("Center", jScrollPane);
        JPanel jPanel = new JPanel(new FlowLayout());
        JButton jButton = this.createButton("Run", "Run all SWRL rules and SQWRL queries", new RunActionListener(this.textArea, this));
        jPanel.add(jButton);
        this.add("South", jPanel);
        this.textArea.append("\nSee http://protege.cim3.net/cgi-bin/wiki.pl?SQWRLQueryTab for documentation.\n\n");
        this.textArea.append("Executing queries in this tab does not modify the ontology.\n\n");
        this.textArea.append("Select a SQWRL query from the list above and press the 'Run' button.\n");
        this.textArea.append("If the selected query generates a result, the result will appear in a new sub tab.\n\n");
    }

    public void appendText(String string) {
        this.textArea.append(string);
    }

    public void removeResultPanel(String string) {
        if (this.resultPanels.containsKey(string)) {
            SQWRLQueryResultPanel sQWRLQueryResultPanel = this.resultPanels.get(string);
            this.resultPanels.remove(string);
            ((JTabbedPane)this.getParent()).remove(sQWRLQueryResultPanel);
            ((JTabbedPane)this.getParent()).setSelectedIndex(0);
        }
    }

    public void removeAllPanels() {
        for (SQWRLQueryResultPanel sQWRLQueryResultPanel : this.resultPanels.values()) {
            ((JTabbedPane)this.getParent()).remove(sQWRLQueryResultPanel);
        }
        this.resultPanels = new HashMap();
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.setToolTipText(string2);
        jButton.setPreferredSize(new Dimension(160, 30));
        jButton.addActionListener(actionListener);
        return jButton;
    }

    private JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setPreferredSize(new Dimension(160, 30));
        return jLabel;
    }

    private JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea(10, 80);
        jTextArea.setLineWrap(true);
        jTextArea.setBackground(Color.WHITE);
        jTextArea.setEditable(false);
        return jTextArea;
    }

    private class RunActionListener
    extends ListenerBase
    implements ActionListener {
        public RunActionListener(JTextArea jTextArea, SQWRLQueryControlPanel sQWRLQueryControlPanel2) {
            super(jTextArea, sQWRLQueryControlPanel2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            SQWRLResult sQWRLResult = null;
            if (SQWRLQueryControlPanel.this.resultPanels.size() == MaximumOpenResultPanels) {
                this.textArea.append("A maximum of " + MaximumOpenResultPanels + " result tabs may be open at once. ");
                this.textArea.append("Please close an existing tab to display results for the selected rule.\n");
            } else {
                try {
                    SQWRLQueryControlPanel.this.queryEngine.runSQWRLQueries();
                    string = BridgePluginManager.getSelectedRuleName();
                    if (string == null || string.equals("")) {
                        this.textArea.append("No SQWRL query selected.\n");
                    } else {
                        sQWRLResult = SQWRLQueryControlPanel.this.queryEngine.getSQWRLResult(string);
                        if (sQWRLResult == null || sQWRLResult.getNumberOfRows() == 0) {
                            this.textArea.append("Query '" + string + "' did not generate any result.\n");
                            if (SQWRLQueryControlPanel.this.resultPanels.containsKey(string)) {
                                SQWRLQueryResultPanel sQWRLQueryResultPanel = (SQWRLQueryResultPanel)SQWRLQueryControlPanel.this.resultPanels.get(string);
                                SQWRLQueryControlPanel.this.resultPanels.remove(sQWRLQueryResultPanel);
                                ((JTabbedPane)SQWRLQueryControlPanel.this.getParent()).remove(sQWRLQueryResultPanel);
                            }
                        } else {
                            SQWRLQueryResultPanel sQWRLQueryResultPanel;
                            this.textArea.append("See the '" + string + "' tab to review results of the SQWRL query.\n");
                            if (SQWRLQueryControlPanel.this.resultPanels.containsKey(string)) {
                                sQWRLQueryResultPanel = (SQWRLQueryResultPanel)SQWRLQueryControlPanel.this.resultPanels.get(string);
                            } else {
                                sQWRLQueryResultPanel = new SQWRLQueryResultPanel(SQWRLQueryControlPanel.this.queryEngine, string, sQWRLResult, this.controlPanel);
                                SQWRLQueryControlPanel.this.resultPanels.put(string, sQWRLQueryResultPanel);
                                ((JTabbedPane)SQWRLQueryControlPanel.this.getParent()).addTab(string, SWRLIcons.getImpsIcon(), sQWRLQueryResultPanel, "Result Panel for query '" + string + "'");
                            }
                            sQWRLQueryResultPanel.validate();
                            this.controlPanel.getParent().validate();
                        }
                    }
                }
                catch (InvalidQueryNameException invalidQueryNameException) {
                    this.textArea.append("Invalid query name '" + string + "'.\n");
                }
                catch (SQWRLException sQWRLException) {
                    if (string.equals("")) {
                        this.textArea.append("Exception running SQWRL queries: " + sQWRLException.getMessage() + "\n");
                    }
                    this.textArea.append("Exception when running SQWRL query '" + string + "': " + sQWRLException.getMessage() + "\n");
                }
            }
        }
    }

    private class ListenerBase {
        protected JTextArea textArea;
        protected SQWRLQueryControlPanel controlPanel;

        public ListenerBase(JTextArea jTextArea, SQWRLQueryControlPanel sQWRLQueryControlPanel2) {
            this.textArea = jTextArea;
            this.controlPanel = sQWRLQueryControlPanel2;
        }
    }
}

