/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.sqwrl.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ClassValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.DatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ObjectValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.PropertyValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ResultGenerator;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.ResultValue;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidAggregateFunctionNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnIndexException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidColumnTypeException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidRowIndexException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.ResultStateException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultImpl
implements ResultGenerator,
SQWRLResult,
Serializable {
    private List<String> allColumnNames;
    private List<String> columnDisplayNames;
    private List<Integer> selectedColumnIndexes;
    private List<Integer> orderByColumnIndexes;
    private HashMap<Integer, String> aggregateColumnIndexes;
    private List<List<ResultValue>> rows;
    private List<ResultValue> rowData;
    private HashMap<String, List<ResultValue>> columnVectorMap;
    private int numberOfColumns;
    private int rowIndex;
    private int rowDataColumnIndex;
    private boolean isConfigured;
    private boolean isPrepared;
    private boolean isRowOpen;
    private boolean isOrdered;
    private boolean isAscending;
    private boolean isDistinct;
    private boolean hasAggregates;

    public ResultImpl() {
        this.initialize();
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured;
    }

    @Override
    public boolean isRowOpen() {
        return this.isRowOpen;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public boolean isOrdered() {
        return this.isOrdered;
    }

    @Override
    public boolean isAscending() {
        return this.isAscending;
    }

    @Override
    public void initialize() {
        this.isConfigured = false;
        this.isPrepared = false;
        this.isRowOpen = false;
        this.allColumnNames = new ArrayList<String>();
        this.aggregateColumnIndexes = new HashMap();
        this.selectedColumnIndexes = new ArrayList<Integer>();
        this.orderByColumnIndexes = new ArrayList<Integer>();
        this.columnDisplayNames = new ArrayList<String>();
        this.numberOfColumns = 0;
        this.isDistinct = false;
        this.isAscending = false;
        this.isOrdered = false;
        this.rowIndex = -1;
        this.rows = new ArrayList<List<ResultValue>>();
    }

    @Override
    public void addColumns(List<String> list) throws SQWRLException {
        for (String string : list) {
            this.addColumn(string);
        }
    }

    @Override
    public void addColumn(String string) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        this.selectedColumnIndexes.add(this.numberOfColumns);
        this.allColumnNames.add(string);
        ++this.numberOfColumns;
    }

    @Override
    public void addAggregateColumn(String string, String string2) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        SQWRLNames.checkAggregateFunctionName(string2);
        this.aggregateColumnIndexes.put(this.numberOfColumns, string2);
        this.allColumnNames.add(string);
        ++this.numberOfColumns;
    }

    @Override
    public void addOrderByColumn(int n, boolean bl) throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (n < 0 || n >= this.allColumnNames.size()) {
            throw new SQWRLException("ordered column index " + n + " out of range");
        }
        if (this.isOrdered && this.isAscending != bl) {
            if (this.isAscending) {
                throw new SQWRLException("attempt to order column '" + this.allColumnNames.get(n) + "' ascending when descending was previously selected");
            }
            throw new SQWRLException("attempt to order column '" + this.allColumnNames.get(n) + "' descending when ascending was previously selected");
        }
        this.isOrdered = true;
        this.isAscending = bl;
        this.orderByColumnIndexes.add(n);
    }

    @Override
    public void addColumnDisplayName(String string) throws SQWRLException {
        if (string.length() == 0 || string.indexOf(44) != -1) {
            throw new SQWRLException("invalid column name '" + string + "' - no commas or empty names allowed");
        }
        this.columnDisplayNames.add(string);
    }

    @Override
    public void configured() throws SQWRLException {
        this.throwExceptionIfAlreadyConfigured();
        if (this.containsOneOf(this.selectedColumnIndexes, this.aggregateColumnIndexes.keySet())) {
            throw new InvalidQueryException("aggregate columns cannot also be selected columns");
        }
        this.hasAggregates = !this.aggregateColumnIndexes.isEmpty();
        this.isConfigured = true;
    }

    @Override
    public void setIsDistinct() {
        this.isDistinct = true;
    }

    @Override
    public int getNumberOfColumns() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        return this.numberOfColumns;
    }

    @Override
    public List<String> getColumnNames() throws SQWRLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.throwExceptionIfNotConfigured();
        if (this.columnDisplayNames.size() < this.getNumberOfColumns()) {
            arrayList.addAll(this.columnDisplayNames);
            arrayList.addAll(this.allColumnNames.subList(this.columnDisplayNames.size(), this.allColumnNames.size()));
        } else {
            arrayList.addAll(this.columnDisplayNames);
        }
        return arrayList;
    }

    @Override
    public String getColumnName(int n) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.checkColumnIndex(n);
        if (n < this.columnDisplayNames.size()) {
            return this.columnDisplayNames.get(n);
        }
        return this.allColumnNames.get(n);
    }

    @Override
    public void addRow(List<ResultValue> list) throws SQWRLException {
        if (list.size() != this.getNumberOfColumns()) {
            throw new SQWRLException("addRow expecting " + this.getNumberOfColumns() + ", got " + list.size() + " values");
        }
        this.openRow();
        for (ResultValue resultValue : list) {
            this.addRowData(resultValue);
        }
        this.closeRow();
    }

    @Override
    public void openRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowOpen();
        this.rowDataColumnIndex = 0;
        this.rowData = new ArrayList<ResultValue>();
        this.isRowOpen = true;
    }

    @Override
    public void addRowData(ResultValue resultValue) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        this.throwExceptionIfRowNotOpen();
        if (this.rowDataColumnIndex == this.getNumberOfColumns()) {
            throw new ResultStateException("attempt to add data beyond the end of a row");
        }
        if (this.aggregateColumnIndexes.containsKey(this.rowDataColumnIndex) && !this.aggregateColumnIndexes.get(this.rowDataColumnIndex).equals("count") && !this.aggregateColumnIndexes.get(this.rowDataColumnIndex).equals("countDistinct") && !this.isNumericValue(resultValue)) {
            throw new SQWRLException("attempt to add non numeric value '" + resultValue + "' to min, max, sum, or avg aggregate column '" + this.allColumnNames.get(this.rowDataColumnIndex) + "'");
        }
        this.rowData.add(resultValue);
        ++this.rowDataColumnIndex;
        if (this.rowDataColumnIndex == this.getNumberOfColumns()) {
            this.closeRow();
        }
    }

    @Override
    public void closeRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.isRowOpen) {
            this.rows.add(this.rowData);
        }
        this.isRowOpen = false;
    }

    @Override
    public void prepared() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfAlreadyPrepared();
        if (this.rowDataColumnIndex != 0) {
            this.throwExceptionIfRowOpen();
        }
        this.isPrepared = true;
        this.isRowOpen = false;
        this.rowDataColumnIndex = 0;
        this.rowIndex = this.getNumberOfRows() > 0 ? 0 : -1;
        if (this.hasAggregates) {
            this.rows = this.aggregate(this.rows, this.allColumnNames, this.aggregateColumnIndexes);
        } else if (this.isDistinct) {
            this.rows = this.distinct(this.rows);
        }
        if (this.isOrdered) {
            this.rows = this.orderBy(this.rows, this.allColumnNames, this.orderByColumnIndexes, this.isAscending);
        }
        this.prepareColumnVectors();
    }

    private void prepareColumnVectors() throws SQWRLException {
        this.columnVectorMap = new HashMap();
        if (this.getNumberOfColumns() > 0) {
            int n;
            ArrayList arrayList = new ArrayList(this.getNumberOfColumns());
            for (n = 0; n < this.getNumberOfColumns(); ++n) {
                arrayList.add(new ArrayList(this.getNumberOfRows()));
            }
            for (n = 0; n < this.getNumberOfRows(); ++n) {
                for (int i = 0; i < this.getNumberOfColumns(); ++i) {
                    ((List)arrayList.get(i)).add(this.rows.get(n).get(i));
                }
            }
            for (n = 0; n < this.getNumberOfColumns(); ++n) {
                this.columnVectorMap.put(this.getColumnName(n), (List<ResultValue>)arrayList.get(n));
            }
        }
    }

    @Override
    public int getNumberOfRows() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        return this.rows.size();
    }

    @Override
    public boolean isEmpty() throws SQWRLException {
        return this.getNumberOfRows() == 0;
    }

    @Override
    public void reset() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        if (this.getNumberOfRows() > 0) {
            this.rowIndex = 0;
        }
    }

    @Override
    public void next() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        if (this.rowIndex != -1 && this.rowIndex < this.getNumberOfRows()) {
            ++this.rowIndex;
        }
    }

    @Override
    public boolean hasNext() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        return this.rowIndex != -1 && this.rowIndex < this.getNumberOfRows();
    }

    @Override
    public List<ResultValue> getRow() throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        return this.rows.get(this.rowIndex);
    }

    @Override
    public ResultValue getValue(String string) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        this.checkColumnName(string);
        int n = this.allColumnNames.indexOf(string);
        List<ResultValue> list = this.rows.get(this.rowIndex);
        return list.get(n);
    }

    @Override
    public ResultValue getValue(int n) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.throwExceptionIfAtEndOfResult();
        this.checkColumnIndex(n);
        List<ResultValue> list = this.rows.get(this.rowIndex);
        return list.get(n);
    }

    @Override
    public ResultValue getValue(int n, int n2) throws SQWRLException {
        Object var3_3 = null;
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnIndex(n);
        this.checkRowIndex(n2);
        return this.rows.get(n2).get(n);
    }

    @Override
    public ObjectValue getObjectValue(String string) throws SQWRLException {
        if (!this.hasObjectValue(string)) {
            throw new InvalidColumnTypeException("expecting ObjectValue type for column '" + string + "'");
        }
        return (ObjectValue)this.getValue(string);
    }

    @Override
    public ObjectValue getObjectValue(int n) throws SQWRLException {
        return this.getObjectValue(this.getColumnName(n));
    }

    @Override
    public DatatypeValue getDatatypeValue(String string) throws SQWRLException {
        if (!this.hasDatatypeValue(string)) {
            throw new InvalidColumnTypeException("expecting DatatypeValue type for column '" + string + "'");
        }
        return (DatatypeValue)this.getValue(string);
    }

    @Override
    public ClassValue getClassValue(String string) throws SQWRLException {
        if (!this.hasClassValue(string)) {
            throw new InvalidColumnTypeException("expecting ClassValue type for column '" + string + "'");
        }
        return (ClassValue)this.getValue(string);
    }

    @Override
    public ClassValue getClassValue(int n) throws SQWRLException {
        return this.getClassValue(this.getColumnName(n));
    }

    @Override
    public PropertyValue getPropertyValue(int n) throws SQWRLException {
        return this.getPropertyValue(this.getColumnName(n));
    }

    @Override
    public PropertyValue getPropertyValue(String string) throws SQWRLException {
        if (!this.hasPropertyValue(string)) {
            throw new InvalidColumnTypeException("expecting PropertyValue type for column '" + string + "'");
        }
        return (PropertyValue)this.getValue(string);
    }

    @Override
    public DatatypeValue getDatatypeValue(int n) throws SQWRLException {
        return this.getDatatypeValue(this.getColumnName(n));
    }

    @Override
    public List<ResultValue> getColumn(String string) throws SQWRLException {
        this.throwExceptionIfNotConfigured();
        this.throwExceptionIfNotPrepared();
        this.checkColumnName(string);
        return this.columnVectorMap.get(string);
    }

    @Override
    public List<ResultValue> getColumn(int n) throws SQWRLException {
        return this.getColumn(this.getColumnName(n));
    }

    @Override
    public boolean hasObjectValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof ObjectValue;
    }

    @Override
    public boolean hasObjectValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof ObjectValue;
    }

    @Override
    public boolean hasDatatypeValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof DatatypeValue;
    }

    @Override
    public boolean hasDatatypeValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof DatatypeValue;
    }

    @Override
    public boolean hasClassValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof ClassValue;
    }

    @Override
    public boolean hasClassValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof ClassValue;
    }

    @Override
    public boolean hasPropertyValue(String string) throws SQWRLException {
        return this.getValue(string) instanceof PropertyValue;
    }

    @Override
    public boolean hasPropertyValue(int n) throws SQWRLException {
        return this.getValue(n) instanceof PropertyValue;
    }

    public String toString() {
        String string = "[isConfigured: " + this.isConfigured + ", isPrepared: " + this.isPrepared + ", isRowOpen: " + this.isRowOpen + ", isOrdered: " + this.isOrdered + ", isAscending " + this.isAscending + ", isDistinct: " + this.isDistinct + ", hasAggregates: " + this.hasAggregates + "]\n";
        for (List<ResultValue> list : this.rows) {
            for (ResultValue resultValue : list) {
                string = string + "" + resultValue + " ";
            }
            string = string + "\n";
        }
        string = string + "--------------------------------------------------------------------------------\n";
        return string;
    }

    private void throwExceptionIfNotConfigured() throws SQWRLException {
        if (!this.isConfigured()) {
            throw new ResultStateException("attempt to add data to unconfigured result");
        }
    }

    private void throwExceptionIfAtEndOfResult() throws SQWRLException {
        if (!this.hasNext()) {
            throw new ResultStateException("attempt to get data after end of result reached");
        }
    }

    private void throwExceptionIfNotPrepared() throws SQWRLException {
        if (!this.isPrepared()) {
            throw new ResultStateException("attempt to process unprepared result");
        }
    }

    private void throwExceptionIfAlreadyConfigured() throws SQWRLException {
        if (this.isConfigured()) {
            throw new ResultStateException("attempt to configure already configured result");
        }
    }

    private void throwExceptionIfAlreadyPrepared() throws SQWRLException {
        if (this.isPrepared()) {
            throw new ResultStateException("attempt to modify prepared result");
        }
    }

    private void checkColumnName(String string) throws InvalidColumnNameException {
        if (!this.allColumnNames.contains(string)) {
            throw new InvalidColumnNameException("Invalid column name: " + string);
        }
    }

    private void throwExceptionIfRowNotOpen() throws SQWRLException {
        if (!this.isRowOpen) {
            throw new ResultStateException("attempt to add data to an unopened row");
        }
    }

    private void throwExceptionIfRowOpen() throws SQWRLException {
        if (this.isRowOpen) {
            throw new ResultStateException("attempt to process result with a partially prepared row");
        }
    }

    private void checkColumnIndex(int n) throws SQWRLException {
        if (n < 0 || n >= this.getNumberOfColumns()) {
            throw new InvalidColumnIndexException("column index " + n + " out of bounds");
        }
    }

    private void checkRowIndex(int n) throws SQWRLException {
        if (n < 0 || n >= this.getNumberOfRows()) {
            throw new InvalidRowIndexException("Row index " + n + " out of bounds");
        }
    }

    private boolean containsOneOf(Collection collection, Collection collection2) {
        for (Object e : collection2) {
            if (!collection.contains(e)) continue;
            return true;
        }
        return false;
    }

    private boolean isNumericValue(ResultValue resultValue) {
        return resultValue instanceof DatatypeValue && ((DatatypeValue)resultValue).isNumeric();
    }

    private List<List<ResultValue>> distinct(List<List<ResultValue>> list) {
        ArrayList<List<ResultValue>> arrayList = new ArrayList<List<ResultValue>>(list);
        ArrayList<List<ResultValue>> arrayList2 = new ArrayList<List<ResultValue>>();
        RowComparator rowComparator = new RowComparator(this.allColumnNames, true);
        Collections.sort(arrayList, rowComparator);
        for (List list2 : arrayList) {
            if (Collections.binarySearch(arrayList2, list2, rowComparator) >= 0) continue;
            arrayList2.add(list2);
        }
        return arrayList2;
    }

    private List<List<ResultValue>> aggregate(List<List<ResultValue>> list, List<String> list2, HashMap<Integer, String> hashMap) throws SQWRLException {
        ResultValue resultValue;
        List<ResultValue> list3;
        HashMap hashMap2;
        int n;
        ArrayList<List<ResultValue>> arrayList = new ArrayList<List<ResultValue>>();
        RowComparator rowComparator = new RowComparator(list2, this.selectedColumnIndexes, true);
        HashMap<Integer, HashMap> hashMap3 = new HashMap<Integer, HashMap>();
        for (List<ResultValue> list4 : list) {
            n = this.findRowIndex(arrayList, list4, rowComparator);
            if (n < 0) {
                hashMap2 = new HashMap();
                for (Integer n2 : hashMap.keySet()) {
                    list3 = new ArrayList<ResultValue>();
                    resultValue = list4.get(n2);
                    list3.add(resultValue);
                    hashMap2.put(n2, list3);
                }
                hashMap3.put(arrayList.size(), hashMap2);
                arrayList.add(list4);
                continue;
            }
            hashMap2 = (HashMap)hashMap3.get(n);
            for (Integer n2 : hashMap.keySet()) {
                resultValue = list4.get(n2);
                list3 = (List)hashMap2.get(n2);
                list3.add(resultValue);
            }
        }
        n = 0;
        for (List<ResultValue> list4 : arrayList) {
            hashMap2 = (HashMap)hashMap3.get(n);
            for (Integer n2 : hashMap.keySet()) {
                String string = hashMap.get(n2);
                list3 = (List)hashMap2.get(n2);
                if (string.equalsIgnoreCase("min")) {
                    resultValue = this.min(list3);
                } else if (string.equalsIgnoreCase("max")) {
                    resultValue = this.max(list3);
                } else if (string.equalsIgnoreCase("sum")) {
                    resultValue = this.sum(list3);
                } else if (string.equalsIgnoreCase("avg")) {
                    resultValue = this.avg(list3);
                } else if (string.equalsIgnoreCase("count")) {
                    resultValue = this.count(list3);
                } else if (string.equalsIgnoreCase("countDistinct")) {
                    resultValue = this.countDistinct(list3);
                } else {
                    throw new InvalidAggregateFunctionNameException("invalid aggregate function '" + string + "'");
                }
                list4.set(n2, resultValue);
            }
            ++n;
        }
        return arrayList;
    }

    private List<List<ResultValue>> orderBy(List<List<ResultValue>> list, List<String> list2, List<Integer> list3, boolean bl) throws SQWRLException {
        ArrayList<List<ResultValue>> arrayList = new ArrayList<List<ResultValue>>(list);
        RowComparator rowComparator = new RowComparator(list2, list3, bl);
        Collections.sort(arrayList, rowComparator);
        return arrayList;
    }

    private DatatypeValue min(List<ResultValue> list) throws SQWRLException {
        DatatypeValue datatypeValue = null;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for 'min'");
        }
        for (ResultValue resultValue : list) {
            if (!(resultValue instanceof DatatypeValue)) {
                throw new SQWRLException("attempt to use 'min' aggregate on non datatype '" + resultValue + "'");
            }
            DatatypeValue datatypeValue2 = (DatatypeValue)resultValue;
            if (!datatypeValue2.isNumeric()) {
                throw new SQWRLException("attempt to use 'min' aggregate on non numeric datatype '" + datatypeValue2 + "'");
            }
            if (datatypeValue == null) {
                datatypeValue = datatypeValue2;
                continue;
            }
            if (datatypeValue2.compareTo(datatypeValue) >= 0) continue;
            datatypeValue = datatypeValue2;
        }
        return datatypeValue;
    }

    private DatatypeValue max(List<ResultValue> list) throws SQWRLException {
        DatatypeValue datatypeValue = null;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for 'max'");
        }
        for (ResultValue resultValue : list) {
            if (!(resultValue instanceof DatatypeValue)) {
                throw new SQWRLException("attempt to use 'max' aggregate on non datatype '" + resultValue + "'");
            }
            DatatypeValue datatypeValue2 = (DatatypeValue)resultValue;
            if (!datatypeValue2.isNumeric()) {
                throw new SQWRLException("attempt to use 'max' aggregate on non numeric datatype '" + datatypeValue2 + "'");
            }
            if (datatypeValue == null) {
                datatypeValue = datatypeValue2;
                continue;
            }
            if (datatypeValue2.compareTo(datatypeValue) <= 0) continue;
            datatypeValue = datatypeValue2;
        }
        return datatypeValue;
    }

    private DatatypeValue sum(List<ResultValue> list) throws SQWRLException {
        BigDecimal bigDecimal = new BigDecimal(0);
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for 'sum'");
        }
        for (ResultValue resultValue : list) {
            BigDecimal bigDecimal2;
            if (!(resultValue instanceof DatatypeValue)) {
                throw new SQWRLException("attempt to use 'sum' aggregate on non datatype '" + resultValue + "'");
            }
            try {
                bigDecimal2 = new BigDecimal(((Object)((DatatypeValue)resultValue)).toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQWRLException("attempt to use 'sum' aggregate on non numeric datatype '" + resultValue + "'");
            }
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return OWLFactory.createOWLDatatypeValue(bigDecimal);
    }

    private DatatypeValue avg(List<ResultValue> list) throws SQWRLException {
        BigDecimal bigDecimal = new BigDecimal(0);
        int n = 0;
        if (list.isEmpty()) {
            throw new SQWRLException("empty aggregate list for 'avg'");
        }
        for (ResultValue resultValue : list) {
            BigDecimal bigDecimal2;
            if (!(resultValue instanceof DatatypeValue)) {
                throw new SQWRLException("attempt to use 'avg' aggregate on non datatype '" + resultValue + "'");
            }
            try {
                bigDecimal2 = new BigDecimal(((Object)((DatatypeValue)resultValue)).toString());
            }
            catch (NumberFormatException numberFormatException) {
                throw new SQWRLException("attempt to use 'avg' aggregate on non numeric datatype '" + resultValue + "'");
            }
            ++n;
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return OWLFactory.createOWLDatatypeValue(bigDecimal.divide(new BigDecimal(n), 1));
    }

    private DatatypeValue count(List<ResultValue> list) throws SQWRLException {
        return OWLFactory.createOWLDatatypeValue(list.size());
    }

    private DatatypeValue countDistinct(List<ResultValue> list) throws SQWRLException {
        HashSet<ResultValue> hashSet = new HashSet<ResultValue>(list);
        return OWLFactory.createOWLDatatypeValue(hashSet.size());
    }

    private int findRowIndex(List<List<ResultValue>> list, List<ResultValue> list2, Comparator<List<ResultValue>> comparator) {
        int n = 0;
        for (List<ResultValue> list3 : list) {
            if (comparator.compare(list2, list3) == 0) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RowComparator
    implements Comparator<List<ResultValue>> {
        private List<Integer> orderByColumnIndexes;
        private boolean ascending;

        public RowComparator(List<String> list, List<Integer> list2, boolean bl) {
            this.ascending = bl;
            this.orderByColumnIndexes = list2;
        }

        public RowComparator(List<String> list, boolean bl) {
            this.ascending = bl;
            this.orderByColumnIndexes = new ArrayList<Integer>();
            for (String string : list) {
                this.orderByColumnIndexes.add(list.indexOf(string));
            }
        }

        @Override
        public int compare(List<ResultValue> list, List<ResultValue> list2) {
            for (Integer n : this.orderByColumnIndexes) {
                int n2 = ((Comparable)list.get(n)).compareTo((Comparable)list2.get(n));
                if (n2 == 0) continue;
                if (this.ascending) {
                    return n2;
                }
                return -n2;
            }
            return 0;
        }
    }
}

