/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.examples;

import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Vector;

public class SWRLFactoryTest {
    public static void main(String[] stringArray) throws Exception {
        Vector vector = new Vector();
        JenaKnowledgeBaseFactory jenaKnowledgeBaseFactory = new JenaKnowledgeBaseFactory();
        Project project = new Project(null, vector);
        project.setKnowledgeBaseFactory((KnowledgeBaseFactory)jenaKnowledgeBaseFactory);
        project.createDomainKnowledgeBase((KnowledgeBaseFactory)jenaKnowledgeBaseFactory, vector, false);
        JenaOWLModel jenaOWLModel = (JenaOWLModel)project.getKnowledgeBase();
        jenaOWLModel.load(new URI("http://protege.stanford.edu/plugins/owl/testdata/importSWRL.owl"), "RDF/XML-ABBREV", vector);
        if (!vector.isEmpty()) {
            System.err.println("Error loading importSWRL.owl:" + vector);
            System.exit(-1);
        }
        SWRLFactory sWRLFactory = new SWRLFactory(jenaOWLModel);
        jenaOWLModel.setFrameFactory((FrameFactory)new SWRLJavaFactory((OWLModel)jenaOWLModel));
        SWRLFactoryTest.testRuleCreation(sWRLFactory, jenaOWLModel);
    }

    private static void testRuleCreation(SWRLFactory sWRLFactory, JenaOWLModel jenaOWLModel) {
        OWLNamedClass oWLNamedClass = jenaOWLModel.createOWLNamedClass("Pizza");
        OWLNamedClass oWLNamedClass2 = jenaOWLModel.createOWLNamedClass("PizzaBase");
        OWLObjectProperty oWLObjectProperty = jenaOWLModel.createOWLObjectProperty("hasIngredient");
        OWLDatatypeProperty oWLDatatypeProperty = jenaOWLModel.createOWLDatatypeProperty("myDatatypeProperty");
        SWRLVariable sWRLVariable = sWRLFactory.createVariable("x");
        SWRLVariable sWRLVariable2 = sWRLFactory.createVariable("y");
        SWRLVariable sWRLVariable3 = sWRLFactory.createVariable("z");
        SWRLBuiltin sWRLBuiltin = sWRLFactory.createBuiltin("lessThan");
        SWRLAtomList sWRLAtomList = sWRLFactory.createAtomList();
        SWRLAtomList sWRLAtomList2 = sWRLFactory.createAtomList();
        SWRLClassAtom sWRLClassAtom = sWRLFactory.createClassAtom(oWLNamedClass, sWRLVariable);
        sWRLAtomList2.append(sWRLClassAtom);
        sWRLClassAtom = sWRLFactory.createClassAtom(oWLNamedClass2, sWRLVariable3);
        sWRLAtomList.append(sWRLClassAtom);
        SWRLSameIndividualAtom sWRLSameIndividualAtom = sWRLFactory.createSameIndividualAtom(sWRLVariable, sWRLVariable2);
        sWRLAtomList.append(sWRLSameIndividualAtom);
        ArrayList<SWRLVariable> arrayList = new ArrayList<SWRLVariable>();
        arrayList.add(sWRLVariable);
        arrayList.add(sWRLVariable2);
        SWRLBuiltinAtom sWRLBuiltinAtom = sWRLFactory.createBuiltinAtom(sWRLBuiltin, arrayList.iterator());
        sWRLAtomList.append(sWRLBuiltinAtom);
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = sWRLFactory.createIndividualPropertyAtom(oWLObjectProperty, sWRLVariable, sWRLVariable3);
        sWRLAtomList.append(sWRLIndividualPropertyAtom);
        RDFSLiteral rDFSLiteral = jenaOWLModel.createRDFSLiteral("ddd", jenaOWLModel.getXSDstring());
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = sWRLFactory.createDatavaluedPropertyAtom(oWLDatatypeProperty, sWRLVariable, rDFSLiteral);
        sWRLAtomList.append(sWRLDatavaluedPropertyAtom);
        OWLDataRange oWLDataRange = jenaOWLModel.createOWLDataRange(new RDFSLiteral[]{jenaOWLModel.createRDFSLiteral("first"), jenaOWLModel.createRDFSLiteral("second")});
        SWRLDataRangeAtom sWRLDataRangeAtom = sWRLFactory.createDataRangeAtom(oWLDataRange, sWRLVariable);
        sWRLAtomList.append(sWRLDataRangeAtom);
        RDFSDatatype rDFSDatatype = jenaOWLModel.getXSDdouble();
        sWRLAtomList.append(sWRLFactory.createDataRangeAtom(rDFSDatatype, sWRLVariable));
        SWRLImp sWRLImp = sWRLFactory.createImp(sWRLAtomList, sWRLAtomList2);
        System.out.println("Imp: " + sWRLImp.getBrowserText());
    }
}

