/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLFactory {
    private OWLNamedClass atomListCls;
    private OWLNamedClass builtinAtomCls;
    private OWLNamedClass classAtomCls;
    private OWLNamedClass dataRangeAtomCls;
    private OWLNamedClass dataValuedPropertyAtomCls;
    private OWLNamedClass differentIndividualsAtomCls;
    private OWLNamedClass impCls;
    private OWLNamedClass individualPropertyAtomCls;
    private OWLNamedClass sameIndividualAtomCls;
    private OWLNamedClass atomCls;
    private OWLNamedClass variableCls;
    private OWLNamedClass builtInCls;
    private OWLObjectProperty bodyProperty;
    private OWLObjectProperty headProperty;
    private OWLObjectProperty argumentsProperty;
    private OWLObjectProperty builtInProperty;
    private OWLObjectProperty argument1Property;
    private OWLObjectProperty classPredicateProperty;
    private OWLObjectProperty propertyPredicateProperty;
    private OWLObjectProperty dataRangeProperty;
    private OWLDatatypeProperty argsProperty;
    private OWLDatatypeProperty minArgsProperty;
    private OWLDatatypeProperty maxArgsProperty;
    private RDFProperty argument2Property;
    private OWLModel owlModel;
    private List<SWRLBuiltin> coreSWRLBuiltIns;

    public SWRLFactory(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.initSWRLClasses();
        if (!(oWLModel.getOWLJavaFactory() instanceof SWRLJavaFactory)) {
            SWRLJavaFactory sWRLJavaFactory = new SWRLJavaFactory(oWLModel);
            oWLModel.setOWLJavaFactory(sWRLJavaFactory);
            if (oWLModel instanceof JenaOWLModel) {
                OWLJavaFactoryUpdater.run((JenaOWLModel)oWLModel);
            }
        }
    }

    private void initSWRLClasses() {
        TripleStoreModel tripleStoreModel = this.owlModel.getTripleStoreModel();
        TripleStore tripleStore = tripleStoreModel.getActiveTripleStore();
        TripleStore tripleStore2 = tripleStoreModel.getTripleStore(0);
        int n = 9500;
        tripleStoreModel.setActiveTripleStore(tripleStore2);
        this.impCls = this.getOrCreateOWLNamedClass("swrl:Imp", n++);
        this.variableCls = this.getOrCreateOWLNamedClass("swrl:Variable", n++);
        this.builtInCls = this.getOrCreateOWLNamedClass("swrl:Builtin", n++);
        this.atomListCls = this.getOrCreateOWLNamedClass("swrl:AtomList", n++, this.owlModel.getRDFListClass());
        this.atomCls = this.getOrCreateOWLNamedClass("swrl:Atom", n++);
        this.classAtomCls = this.getOrCreateOWLNamedClass("swrl:ClassAtom", n++, this.atomCls);
        this.builtinAtomCls = this.getOrCreateOWLNamedClass("swrl:BuiltinAtom", n++, this.atomCls);
        this.dataRangeAtomCls = this.getOrCreateOWLNamedClass("swrl:DataRangeAtom", n++, this.atomCls);
        this.dataValuedPropertyAtomCls = this.getOrCreateOWLNamedClass("swrl:DatavaluedPropertyAtom", n++, this.atomCls);
        this.differentIndividualsAtomCls = this.getOrCreateOWLNamedClass("swrl:DifferentIndividualsAtom", n++, this.atomCls);
        this.individualPropertyAtomCls = this.getOrCreateOWLNamedClass("swrl:IndividualPropertyAtom", n++, this.atomCls);
        this.sameIndividualAtomCls = this.getOrCreateOWLNamedClass("swrl:SameIndividualAtom", n++, this.atomCls);
        this.bodyProperty = this.getOrCreateOWLObjectProperty("swrl:body", n++);
        this.headProperty = this.getOrCreateOWLObjectProperty("swrl:head", n++);
        this.argumentsProperty = this.getOrCreateOWLObjectProperty("swrl:arguments", n++);
        this.builtInProperty = this.getOrCreateOWLObjectProperty("swrl:builtin", n++);
        this.argument1Property = this.getOrCreateOWLObjectProperty("swrl:argument1", n++);
        this.argument2Property = this.getOrCreateOWLProperty("swrl:argument2", n++);
        this.classPredicateProperty = this.getOrCreateOWLObjectProperty("swrl:classPredicate", n++);
        this.propertyPredicateProperty = this.getOrCreateOWLObjectProperty("swrl:propertyPredicate", n++);
        this.dataRangeProperty = this.getOrCreateOWLObjectProperty("swrl:dataRange", n++);
        this.argsProperty = this.getOrCreateOWLDatatypeProperty("swrlb:args", n++);
        this.minArgsProperty = this.getOrCreateOWLDatatypeProperty("swrlb:minArgs", n++);
        this.maxArgsProperty = this.getOrCreateOWLDatatypeProperty("swrlb:maxArgs", n++);
        this.initCoreSWRLBuiltIns(n);
        tripleStoreModel.setActiveTripleStore(tripleStore);
    }

    private OWLNamedClass getOrCreateOWLNamedClass(String string, int n) {
        return this.getOrCreateOWLNamedClass(string, n, null);
    }

    private OWLNamedClass getOrCreateOWLNamedClass(String string, int n, RDFSNamedClass rDFSNamedClass) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            DefaultOWLNamedClass defaultOWLNamedClass = new DefaultOWLNamedClass(this.owlModel, FrameID.createSystem((int)n));
            defaultOWLNamedClass.setName(string);
            defaultOWLNamedClass.setProtegeType(this.owlModel.getOWLNamedClassClass());
            if (rDFSNamedClass != null) {
                defaultOWLNamedClass.addSuperclass(rDFSNamedClass);
                defaultOWLNamedClass.removeSuperclass(this.owlModel.getOWLThingClass());
            } else {
                defaultOWLNamedClass.addSuperclass(this.owlModel.getOWLThingClass());
            }
        } else if (!(rDFResource instanceof OWLNamedClass)) {
            rDFResource.setProtegeType(this.owlModel.getOWLNamedClassClass());
            OWLNamedClass oWLNamedClass = this.owlModel.getOWLNamedClass(string);
            if (rDFSNamedClass != null) {
                oWLNamedClass.addSuperclass(rDFSNamedClass);
                oWLNamedClass.removeSuperclass(this.owlModel.getOWLThingClass());
            } else {
                oWLNamedClass.addSuperclass(this.owlModel.getOWLThingClass());
            }
        }
        return this.owlModel.getOWLNamedClass(string);
    }

    private OWLObjectProperty getOrCreateOWLObjectProperty(String string, int n) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            DefaultOWLObjectProperty defaultOWLObjectProperty = new DefaultOWLObjectProperty(this.owlModel, FrameID.createSystem((int)n));
            defaultOWLObjectProperty.setName(string);
            defaultOWLObjectProperty.setProtegeType(this.owlModel.getOWLObjectPropertyClass());
        } else if (!(rDFResource instanceof OWLObjectProperty)) {
            rDFResource.setProtegeType(this.owlModel.getOWLObjectPropertyClass());
        }
        return this.owlModel.getOWLObjectProperty(string);
    }

    private OWLDatatypeProperty getOrCreateOWLDatatypeProperty(String string, int n) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            DefaultOWLDatatypeProperty defaultOWLDatatypeProperty = new DefaultOWLDatatypeProperty(this.owlModel, FrameID.createSystem((int)n));
            defaultOWLDatatypeProperty.setName(string);
            defaultOWLDatatypeProperty.setProtegeType(this.owlModel.getOWLDatatypePropertyClass());
        } else if (!(rDFResource instanceof OWLDatatypeProperty)) {
            rDFResource.setProtegeType(this.owlModel.getOWLDatatypePropertyClass());
        }
        return this.owlModel.getOWLDatatypeProperty(string);
    }

    private RDFProperty getOrCreateOWLProperty(String string, int n) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            DefaultRDFProperty defaultRDFProperty = new DefaultRDFProperty(this.owlModel, FrameID.createSystem((int)n));
            defaultRDFProperty.setName(string);
            defaultRDFProperty.setProtegeType(this.owlModel.getRDFPropertyClass());
        } else if (!(rDFResource instanceof RDFProperty)) {
            rDFResource.setProtegeType(this.owlModel.getRDFPropertyClass());
        }
        return this.owlModel.getRDFProperty(string);
    }

    private SWRLBuiltin getOrCreateBuiltIn(String string, int n) {
        Object object;
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource == null) {
            object = string.indexOf(":") == -1 ? string : string.substring(string.indexOf(":") + 1);
            rDFResource = this.owlModel.getRDFResource("http://www.w3.org/2003/11/swrlb#" + (String)object);
            if (rDFResource != null) {
                rDFResource.setName(string);
            }
        }
        if (rDFResource == null) {
            object = new DefaultOWLIndividual(this.owlModel, FrameID.createSystem((int)n));
            object.setName(string);
            object.setProtegeType(this.builtInCls);
        } else if (!(rDFResource instanceof SWRLBuiltin)) {
            rDFResource.setProtegeType(this.builtInCls);
        }
        return (SWRLBuiltin)this.owlModel.getOWLIndividual(string);
    }

    public SWRLImp createImp() {
        String string = this.getNewImpName();
        return (SWRLImp)this.impCls.createInstance(string);
    }

    public SWRLImp createImpWithGivenName(String string) {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Imp");
        return (SWRLImp)rDFSNamedClass.createInstance(string);
    }

    public SWRLImp createImp(String string) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.owlModel);
        sWRLParser.setParseOnly(false);
        return sWRLParser.parse(string);
    }

    public SWRLImp createImp(String string, String string2) throws SWRLParseException {
        SWRLParser sWRLParser = new SWRLParser(this.owlModel);
        SWRLImp sWRLImp = this.createImpWithGivenName(string);
        sWRLParser.setParseOnly(false);
        return sWRLParser.parse(string2, sWRLImp);
    }

    public SWRLImp createImp(SWRLAtom sWRLAtom, Collection collection) {
        SWRLAtomList sWRLAtomList = this.createAtomList(Collections.singleton(sWRLAtom));
        SWRLAtomList sWRLAtomList2 = this.createAtomList(collection);
        return this.createImp(sWRLAtomList, sWRLAtomList2);
    }

    public SWRLImp createImp(SWRLAtomList sWRLAtomList, SWRLAtomList sWRLAtomList2) {
        SWRLImp sWRLImp = this.createImp();
        sWRLImp.setHead(sWRLAtomList);
        sWRLImp.setBody(sWRLAtomList2);
        return sWRLImp;
    }

    public SWRLAtomList createAtomList() {
        return (SWRLAtomList)this.atomListCls.createAnonymousInstance();
    }

    public SWRLAtomList createAtomList(Collection collection) {
        SWRLAtomList sWRLAtomList = this.createAtomList();
        for (Object e : collection) {
            sWRLAtomList.append(e);
        }
        return sWRLAtomList;
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, Iterator iterator) {
        RDFList rDFList = this.owlModel.createRDFList(iterator);
        return this.createBuiltinAtom(sWRLBuiltin, rDFList);
    }

    public SWRLBuiltinAtom createBuiltinAtom(SWRLBuiltin sWRLBuiltin, RDFList rDFList) {
        SWRLBuiltinAtom sWRLBuiltinAtom = (SWRLBuiltinAtom)this.builtinAtomCls.createAnonymousInstance();
        sWRLBuiltinAtom.setBuiltin(sWRLBuiltin);
        sWRLBuiltinAtom.setArguments(rDFList);
        return sWRLBuiltinAtom;
    }

    public SWRLClassAtom createClassAtom(RDFSNamedClass rDFSNamedClass, RDFResource rDFResource) {
        SWRLClassAtom sWRLClassAtom = (SWRLClassAtom)this.classAtomCls.createAnonymousInstance();
        sWRLClassAtom.setClassPredicate(rDFSNamedClass);
        sWRLClassAtom.setArgument1(rDFResource);
        return sWRLClassAtom;
    }

    public SWRLDataRangeAtom createDataRangeAtom(RDFResource rDFResource, RDFObject rDFObject) {
        SWRLDataRangeAtom sWRLDataRangeAtom = (SWRLDataRangeAtom)this.dataRangeAtomCls.createAnonymousInstance();
        sWRLDataRangeAtom.setArgument1(rDFObject);
        sWRLDataRangeAtom.setDataRange(rDFResource);
        return sWRLDataRangeAtom;
    }

    public SWRLDatavaluedPropertyAtom createDatavaluedPropertyAtom(OWLDatatypeProperty oWLDatatypeProperty, RDFResource rDFResource, RDFObject rDFObject) {
        SWRLDatavaluedPropertyAtom sWRLDatavaluedPropertyAtom = (SWRLDatavaluedPropertyAtom)this.dataValuedPropertyAtomCls.createAnonymousInstance();
        sWRLDatavaluedPropertyAtom.setPropertyPredicate(oWLDatatypeProperty);
        sWRLDatavaluedPropertyAtom.setArgument1(rDFResource);
        sWRLDatavaluedPropertyAtom.setArgument2(rDFObject);
        return sWRLDatavaluedPropertyAtom;
    }

    public SWRLIndividualPropertyAtom createIndividualPropertyAtom(OWLObjectProperty oWLObjectProperty, RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLIndividualPropertyAtom sWRLIndividualPropertyAtom = (SWRLIndividualPropertyAtom)this.individualPropertyAtomCls.createAnonymousInstance();
        sWRLIndividualPropertyAtom.setPropertyPredicate(oWLObjectProperty);
        sWRLIndividualPropertyAtom.setArgument1(rDFResource);
        sWRLIndividualPropertyAtom.setArgument2(rDFResource2);
        return sWRLIndividualPropertyAtom;
    }

    public SWRLDifferentIndividualsAtom createDifferentIndividualsAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLDifferentIndividualsAtom sWRLDifferentIndividualsAtom = (SWRLDifferentIndividualsAtom)this.differentIndividualsAtomCls.createAnonymousInstance();
        sWRLDifferentIndividualsAtom.setArgument1(rDFResource);
        sWRLDifferentIndividualsAtom.setArgument2(rDFResource2);
        return sWRLDifferentIndividualsAtom;
    }

    public SWRLSameIndividualAtom createSameIndividualAtom(RDFResource rDFResource, RDFResource rDFResource2) {
        SWRLSameIndividualAtom sWRLSameIndividualAtom = (SWRLSameIndividualAtom)this.sameIndividualAtomCls.createAnonymousInstance();
        sWRLSameIndividualAtom.setArgument1(rDFResource);
        sWRLSameIndividualAtom.setArgument2(rDFResource2);
        return sWRLSameIndividualAtom;
    }

    public SWRLVariable createVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFSNamedClass("swrl:Variable").createInstance(string);
    }

    public SWRLBuiltin createBuiltin(String string) {
        return (SWRLBuiltin)this.owlModel.getRDFSNamedClass("swrl:Builtin").createInstance(string);
    }

    public SWRLBuiltin getBuiltin(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        if (rDFResource instanceof SWRLBuiltin) {
            return (SWRLBuiltin)rDFResource;
        }
        System.err.println("[SWRLFactory]  Invalid attempt to cast " + string + " into SWRLBuiltin (real type is " + rDFResource.getProtegeType() + ")");
        return null;
    }

    public Collection getBuiltins() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Builtin");
        return rDFSNamedClass.getInstances(true);
    }

    public Collection getImps() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Imp");
        return rDFSNamedClass.getInstances(true);
    }

    public Collection getEnabledImps() {
        return this.getImps(new HashSet<String>(), true);
    }

    public Collection getEnabledImps(Set<String> set) {
        return this.getImps(set, true);
    }

    public Collection getEnabledImps(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        return this.getImps(hashSet, true);
    }

    private Collection getImps(Set<String> set, boolean bl) {
        ArrayList<SWRLImp> arrayList = new ArrayList<SWRLImp>();
        Collection collection = this.getImps();
        if (collection != null) {
            for (SWRLImp sWRLImp : collection) {
                if (!set.isEmpty() && !sWRLImp.isInRuleGroups(set) || sWRLImp.isEnabled() != bl) continue;
                arrayList.add(sWRLImp);
            }
        }
        return arrayList;
    }

    public void deleteImps() {
        for (Object e : this.getImps()) {
            SWRLImp sWRLImp = (SWRLImp)e;
            sWRLImp.deleteImp();
        }
    }

    public void replaceImps(OWLModel oWLModel) throws SWRLFactoryException {
        this.deleteImps();
        this.copyImps(oWLModel);
    }

    public void copyImps(OWLModel oWLModel) throws SWRLFactoryException {
        SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
        for (Object e : sWRLFactory.getImps()) {
            SWRLImp sWRLImp = (SWRLImp)e;
            String string = sWRLImp.getLocalName();
            String string2 = sWRLImp.getBrowserText();
            if (this.hasImp(string)) {
                throw new SWRLFactoryException("attempt to copy rule '" + string + "' that has same name as an existing rule");
            }
            try {
                this.createImp(string, string2);
            }
            catch (SWRLParseException sWRLParseException) {
                throw new SWRLFactoryException("error copying rule '" + string + "': " + sWRLParseException.getMessage());
            }
        }
    }

    public SWRLImp getImp(String string) throws SWRLFactoryException {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        SWRLImp sWRLImp = null;
        if (!(rDFResource instanceof SWRLImp)) {
            throw new SWRLFactoryException("invalid attempt to cast " + string + " into SWRLBuiltin (real type is " + rDFResource.getProtegeType() + ")");
        }
        sWRLImp = (SWRLImp)rDFResource;
        return sWRLImp;
    }

    public boolean hasImp(String string) {
        RDFResource rDFResource = this.owlModel.getRDFResource(string);
        return rDFResource != null && rDFResource instanceof SWRLImp;
    }

    public String getNewImpName() {
        String string = "Rule-";
        int n = Math.max(1, this.impCls.getInstances(false).size());
        while (this.owlModel.getRDFResource(string + n) != null) {
            ++n;
        }
        return string + n;
    }

    public SWRLVariable getVariable(String string) {
        return (SWRLVariable)this.owlModel.getRDFResource(string);
    }

    public Collection getVariables() {
        RDFSNamedClass rDFSNamedClass = this.owlModel.getRDFSNamedClass("swrl:Variable");
        return rDFSNamedClass.getInstances(true);
    }

    public Collection getReferencedImps(RDFResource rDFResource) {
        ArrayList<SWRLImp> arrayList = new ArrayList<SWRLImp>();
        if (rDFResource != null) {
            for (SWRLImp sWRLImp : this.getImps()) {
                Set set = sWRLImp.getReferencedInstances();
                if (!set.contains(rDFResource) || arrayList.contains(sWRLImp)) continue;
                arrayList.add(sWRLImp);
            }
        }
        return arrayList;
    }

    public void enableAll() {
        this.enableStatusUpdate(new HashSet<String>(), true);
    }

    public void disableAll() {
        this.enableStatusUpdate(new HashSet<String>(), false);
    }

    public void enableAll(Set<String> set) {
        this.enableStatusUpdate(set, true);
    }

    public void disableAll(Set<String> set) {
        this.enableStatusUpdate(set, false);
    }

    public void enableAll(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enableStatusUpdate(hashSet, true);
    }

    public void disableAll(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.enableStatusUpdate(hashSet, false);
    }

    public boolean isSWRLResource(RDFResource rDFResource) {
        return rDFResource instanceof SWRLAtomList || rDFResource instanceof SWRLBuiltinAtom || rDFResource instanceof SWRLClassAtom || rDFResource instanceof SWRLDataRangeAtom || rDFResource instanceof SWRLDatavaluedPropertyAtom || rDFResource instanceof SWRLDifferentIndividualsAtom || rDFResource instanceof SWRLImp || rDFResource instanceof SWRLIndividualPropertyAtom || rDFResource instanceof SWRLSameIndividualAtom || rDFResource instanceof SWRLBuiltin || rDFResource instanceof SWRLAtom || rDFResource instanceof SWRLVariable;
    }

    private void enableStatusUpdate(Set<String> set, boolean bl) {
        for (SWRLImp sWRLImp : this.getImps()) {
            if (!set.isEmpty() && !sWRLImp.isInRuleGroups(set)) continue;
            if (bl) {
                sWRLImp.enable();
                continue;
            }
            sWRLImp.disable();
        }
    }

    public Collection<RDFSNamedClass> getSWRLClasses() {
        ArrayList<RDFSNamedClass> arrayList = new ArrayList<RDFSNamedClass>();
        arrayList.add(this.atomListCls);
        arrayList.add(this.builtinAtomCls);
        arrayList.add(this.classAtomCls);
        arrayList.add(this.dataRangeAtomCls);
        arrayList.add(this.dataValuedPropertyAtomCls);
        arrayList.add(this.differentIndividualsAtomCls);
        arrayList.add(this.impCls);
        arrayList.add(this.individualPropertyAtomCls);
        arrayList.add(this.sameIndividualAtomCls);
        arrayList.add(this.builtInCls);
        arrayList.add(this.atomCls);
        arrayList.add(this.variableCls);
        return arrayList;
    }

    public Collection<RDFProperty> getSWRLProperties() {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        arrayList.add(this.bodyProperty);
        arrayList.add(this.headProperty);
        arrayList.add(this.argumentsProperty);
        arrayList.add(this.builtInProperty);
        arrayList.add(this.argument1Property);
        arrayList.add(this.argument2Property);
        arrayList.add(this.classPredicateProperty);
        arrayList.add(this.propertyPredicateProperty);
        arrayList.add(this.dataRangeProperty);
        return arrayList;
    }

    public Collection<RDFProperty> getSWRLBProperties() {
        RDFProperty rDFProperty;
        RDFProperty rDFProperty2;
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        RDFProperty rDFProperty3 = this.owlModel.getRDFProperty("swrlb:args");
        if (rDFProperty3 != null) {
            arrayList.add(rDFProperty3);
        }
        if ((rDFProperty2 = this.owlModel.getRDFProperty("swrlb:minArgs")) != null) {
            arrayList.add(rDFProperty2);
        }
        if ((rDFProperty = this.owlModel.getRDFProperty("swrlb:maxArgs")) != null) {
            arrayList.add(rDFProperty);
        }
        return arrayList;
    }

    private void initCoreSWRLBuiltIns(int n) {
        this.coreSWRLBuiltIns = new ArrayList<SWRLBuiltin>();
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:equal", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:notEqual", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:lessThan", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:lessThanOrEqual", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:greaterThan", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:greaterThanOrEqual", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:add", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtract", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:multiply", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:divide", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:integerDivide", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:mode", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:pow", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:unaryPlus", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:unaryMinus", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:abs", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:ceiling", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:floor", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:round", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:roundHalfToEven", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:sin", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:cos", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:tan", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:booleanNot", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:stringEqualIgnoreCase", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:stringConcat", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:substring", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:stringLength", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:normalizeSpace", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:upperCase", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:lowerCase", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:translate", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:contains", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:containsIgnoreCase", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:startsWith", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:endsWith", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:substringBefore", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:substringAfter", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:matches", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:replace", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:tokenize", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:yearMonthDuration", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:dayTimeDuration", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:dateTime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:date", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:time", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addYearMonthDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractYearMonthDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:multiplyYearMonthDuration", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:divideYearMonthDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addDayTimeDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDayTimeDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:multiplyDayTimeDurations", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:divideDayTimeDuration", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDates", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractTimes", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addYearMonthDurationToDatetime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addDayTimeDurationToDatetime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractYearMonthDurationFromDatetime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDayTimeDurationFromDatetime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addYearMonthDurationToDate", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addDayTimeDurationToDate", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractYearMonthDurationFromDate", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDayTimeDurationFromDate", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:addDayTimeDurationToTime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDatTimeDurationFromTime", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDatetimesYieldingYearMonthDuration", n++));
        this.coreSWRLBuiltIns.add(this.getOrCreateBuiltIn("swrlb:subtractDatetimesYieldingDayTimeDuration", n++));
    }
}

