/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ddm.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.Mapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypePropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLObjectPropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.MapperException;
import edu.stanford.smi.protegex.owl.swrl.ddm.Column;
import edu.stanford.smi.protegex.owl.swrl.ddm.DDMFactory;
import edu.stanford.smi.protegex.owl.swrl.ddm.Database;
import edu.stanford.smi.protegex.owl.swrl.ddm.DatabaseConnection;
import edu.stanford.smi.protegex.owl.swrl.ddm.ForeignKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.MapperGenerator;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLClassMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLDatatypePropertyMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.OWLObjectPropertyMap;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKeyColumn;
import edu.stanford.smi.protegex.owl.swrl.ddm.Table;
import edu.stanford.smi.protegex.owl.swrl.ddm.exceptions.JDBCException;
import edu.stanford.smi.protegex.owl.swrl.ddm.impl.DatabaseConnectionImpl;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLQueryEngine;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalMapper
implements Mapper,
MapperGenerator {
    private Map<String, OWLClassMap> classMaps = new HashMap<String, OWLClassMap>();
    private Map<String, OWLObjectPropertyMap> objectPropertyMaps = new HashMap<String, OWLObjectPropertyMap>();
    private Map<String, OWLDatatypePropertyMap> datatypePropertyMaps = new HashMap<String, OWLDatatypePropertyMap>();
    private Set<Database> databases = new HashSet<Database>();
    private Map<Database, DatabaseConnection> databaseConnections = new HashMap<Database, DatabaseConnection>();

    public RelationalMapper(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException {
        this.readMaps(sQWRLQueryEngine);
    }

    @Override
    public void open() throws MapperException {
        try {
            for (DatabaseConnection databaseConnection : this.databaseConnections.values()) {
                if (databaseConnection.isOpen()) continue;
                databaseConnection.open();
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error opening database connections: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error opening database connections: " + sQLException.getMessage());
        }
    }

    @Override
    public void close() throws MapperException {
        try {
            for (DatabaseConnection databaseConnection : this.databaseConnections.values()) {
                if (!databaseConnection.isOpen()) continue;
                databaseConnection.close();
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error closing database connections: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error closing database connections: " + sQLException.getMessage());
        }
    }

    @Override
    public boolean isMapped(OWLClass oWLClass) {
        return this.classMaps.containsKey(oWLClass.getClassName());
    }

    @Override
    public boolean isMapped(OWLProperty oWLProperty) {
        return this.objectPropertyMaps.containsKey(oWLProperty.getPropertyName()) || this.datatypePropertyMaps.containsKey(oWLProperty.getPropertyName());
    }

    @Override
    public void addMap(OWLClassMap oWLClassMap) {
        String string = oWLClassMap.getOWLClass().getClassName();
        if (this.classMaps.containsKey(string)) {
            this.classMaps.remove(string);
        }
        this.classMaps.put(string, oWLClassMap);
    }

    @Override
    public void addMap(OWLObjectPropertyMap oWLObjectPropertyMap) {
        String string = oWLObjectPropertyMap.getProperty().getPropertyName();
        if (this.objectPropertyMaps.containsKey(string)) {
            this.objectPropertyMaps.remove(string);
        }
        this.objectPropertyMaps.put(string, oWLObjectPropertyMap);
    }

    @Override
    public void addMap(OWLDatatypePropertyMap oWLDatatypePropertyMap) {
        String string = oWLDatatypePropertyMap.getProperty().getPropertyName();
        if (this.datatypePropertyMaps.containsKey(string)) {
            this.datatypePropertyMaps.remove(string);
        }
        this.datatypePropertyMaps.put(string, oWLDatatypePropertyMap);
    }

    @Override
    public Set<OWLIndividual> mapOWLClass(OWLClass oWLClass) throws MapperException {
        String string = oWLClass.getClassName();
        OWLClassMap oWLClassMap = this.getOWLClassMap(string);
        PrimaryKey primaryKey = oWLClassMap.getPrimaryKey();
        String string2 = primaryKey.getPrimaryKeyColumns().iterator().next().getColumnName();
        Database database = primaryKey.getBaseTable().getDatabase();
        String string3 = primaryKey.getBaseTable().getTableName();
        String string4 = primaryKey.getPrimaryKeyColumns().iterator().next().getColumnName();
        HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        try {
            ResultSet resultSet = databaseConnection.executeQuery("SELECT " + string2 + " FROM " + string3);
            while (resultSet.next()) {
                String string5 = resultSet.getString(string2);
                hashSet.add(OWLFactory.generateOWLIndividual(string5));
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping class '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping class '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLIndividual> mapOWLClass(OWLClass oWLClass, OWLIndividual oWLIndividual) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> mapOWLObjectProperty(OWLProperty oWLProperty) throws MapperException {
        String string = oWLProperty.getPropertyName();
        OWLObjectPropertyMap oWLObjectPropertyMap = this.getOWLObjectPropertyMap(string);
        ForeignKey foreignKey = oWLObjectPropertyMap.getForeignKey();
        String string2 = foreignKey.getBaseTable().getTableName();
        String string3 = foreignKey.getBaseTable().getPrimaryKey().getPrimaryKeyColumns().iterator().next().getColumnName();
        String string4 = foreignKey.getForeignKeyColumns().iterator().next().getColumnName();
        String string5 = foreignKey.getReferencedTable().getTableName();
        String string6 = foreignKey.getReferencedTable().getPrimaryKey().getPrimaryKeyColumns().iterator().next().getColumnName();
        Database database = foreignKey.getBaseTable().getDatabase();
        HashSet<OWLObjectPropertyAssertionAxiom> hashSet = new HashSet<OWLObjectPropertyAssertionAxiom>();
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        String string7 = "SELECT S." + string3 + ", S." + string4 + ", O." + string6 + " " + "FROM " + string2 + " AS S, " + string5 + " AS O " + "WHERE " + string4 + " = " + string6;
        try {
            ResultSet resultSet = databaseConnection.executeQuery(string7);
            while (resultSet.next()) {
                OWLIndividual oWLIndividual = OWLFactory.generateOWLIndividual(resultSet.getString(string3));
                OWLIndividual oWLIndividual2 = OWLFactory.generateOWLIndividual(resultSet.getString(string6));
                OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = OWLFactory.createOWLObjectPropertyAssertionAxiom(oWLIndividual, oWLProperty, oWLIndividual2);
                hashSet.add(oWLObjectPropertyAssertionAxiom);
            }
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping object property '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping object property '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> mapOWLObjectProperty(OWLProperty oWLProperty, OWLIndividual oWLIndividual) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLObjectPropertyAssertionAxiom> mapOWLObjectProperty(OWLProperty oWLProperty, OWLIndividual oWLIndividual, OWLIndividual oWLIndividual2) throws MapperException {
        throw new MapperException("not implemented");
    }

    @Override
    public Set<OWLDatatypePropertyAssertionAxiom> mapOWLDatatypeProperty(OWLProperty oWLProperty, OWLIndividual oWLIndividual, OWLDatatypeValue oWLDatatypeValue) throws MapperException {
        String string = oWLProperty.getPropertyName();
        OWLDatatypePropertyMap oWLDatatypePropertyMap = this.getOWLDatatypePropertyMap(string);
        PrimaryKey primaryKey = oWLDatatypePropertyMap.getPrimaryKey();
        String string2 = oWLDatatypePropertyMap.getValueColumn().getColumnName();
        String string3 = primaryKey.getPrimaryKeyColumns().iterator().next().getColumnName();
        String string4 = primaryKey.getBaseTable().getTableName();
        Database database = primaryKey.getBaseTable().getDatabase();
        HashSet<OWLDatatypePropertyAssertionAxiom> hashSet = new HashSet<OWLDatatypePropertyAssertionAxiom>();
        boolean bl = oWLIndividual != null;
        boolean bl2 = oWLDatatypeValue != null;
        DatabaseConnection databaseConnection = this.getDatabaseConnection(database);
        String string5 = "SELECT " + string3 + ", " + string2 + " FROM " + string4;
        if (bl || bl2) {
            string5 = string5 + " WHERE ";
            if (bl) {
                string5 = string5 + string3 + " = " + oWLIndividual.getIndividualName();
            }
            if (bl2) {
                if (bl) {
                    string5 = string5 + " AND ";
                }
                string5 = string5 + string2 + " = ";
                string5 = oWLDatatypeValue.isString() ? string5 + "\"" + oWLDatatypeValue.toString() + "\"" : string5 + oWLDatatypeValue.toString();
            }
        }
        try {
            ResultSet resultSet = databaseConnection.executeQuery(string5);
            while (resultSet.next()) {
                OWLIndividual oWLIndividual2 = OWLFactory.generateOWLIndividual(resultSet.getString(string3));
                OWLDatatypeValue oWLDatatypeValue2 = OWLFactory.createOWLDatatypeValue(resultSet.getFloat(string2));
                OWLDatatypePropertyAssertionAxiom oWLDatatypePropertyAssertionAxiom = OWLFactory.createOWLDatatypePropertyAssertionAxiom(oWLIndividual2, oWLProperty, oWLDatatypeValue2);
                hashSet.add(oWLDatatypePropertyAssertionAxiom);
            }
            resultSet.close();
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error mapping datatype property '" + string + "': " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error mapping datatype property '" + string + "': " + sQLException.getMessage());
        }
        return hashSet;
    }

    @Override
    public Set<OWLDatatypePropertyAssertionAxiom> mapOWLDatatypeProperty(OWLProperty oWLProperty, OWLIndividual oWLIndividual) throws MapperException {
        return this.mapOWLDatatypeProperty(oWLProperty, oWLIndividual, null);
    }

    @Override
    public Set<OWLDatatypePropertyAssertionAxiom> mapOWLDatatypeProperty(OWLProperty oWLProperty, OWLDatatypeValue oWLDatatypeValue) throws MapperException {
        return this.mapOWLDatatypeProperty(oWLProperty, null, oWLDatatypeValue);
    }

    @Override
    public Set<OWLDatatypePropertyAssertionAxiom> mapOWLDatatypeProperty(OWLProperty oWLProperty) throws MapperException {
        return this.mapOWLDatatypeProperty(oWLProperty, null, null);
    }

    private OWLClassMap getOWLClassMap(String string) throws MapperException {
        if (!this.classMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped class '" + string + "'");
        }
        return this.classMaps.get(string);
    }

    private OWLObjectPropertyMap getOWLObjectPropertyMap(String string) throws MapperException {
        if (!this.objectPropertyMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped object property '" + string + "'");
        }
        return this.objectPropertyMaps.get(string);
    }

    private OWLDatatypePropertyMap getOWLDatatypePropertyMap(String string) throws MapperException {
        if (!this.datatypePropertyMaps.containsKey(string)) {
            throw new MapperException("attempt to map unmapped datatype property '" + string + "'");
        }
        return this.datatypePropertyMaps.get(string);
    }

    private void readMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException {
        try {
            sQWRLQueryEngine.runSQWRLQueries();
            this.readOWLClassMaps(sQWRLQueryEngine);
            this.readOWLObjectPropertyMaps(sQWRLQueryEngine);
            this.readOWLDatatypePropertyMaps(sQWRLQueryEngine);
        }
        catch (JDBCException jDBCException) {
            throw new MapperException("JDBC error reading mapping information: " + jDBCException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new MapperException("SQL error reading mapping information: " + sQLException.getMessage());
        }
        catch (InvalidQueryNameException invalidQueryNameException) {
        }
        catch (SQWRLException sQWRLException) {
            throw new MapperException("SQWRL error reading mapping information: " + sQWRLException.getMessage());
        }
    }

    private void readOWLClassMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException {
    }

    private void readOWLObjectPropertyMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException {
    }

    private void readOWLDatatypePropertyMaps(SQWRLQueryEngine sQWRLQueryEngine) throws MapperException, SQWRLException, SQLException, JDBCException {
        SQWRLResult sQWRLResult = sQWRLQueryEngine.getSQWRLResult("ddm:OWLDatatypePropertyMap-Query");
        if (sQWRLResult != null) {
            while (sQWRLResult.hasNext()) {
                String string = sQWRLResult.getPropertyValue("?ddm:owlDatatypeProperty").getPropertyName();
                String string2 = sQWRLResult.getDatatypeValue("?ddm:schemaName").getString();
                String string3 = sQWRLResult.getDatatypeValue("?ddm:tableName").getString();
                String string4 = sQWRLResult.getDatatypeValue("?ddm:keyColumnName").getString();
                String string5 = sQWRLResult.getDatatypeValue("?ddm:valueColumnName").getString();
                String string6 = sQWRLResult.getDatatypeValue("?ddm:jdbcDriverName").getString();
                String string7 = sQWRLResult.getDatatypeValue("?ddm:databaseName").getString();
                String string8 = sQWRLResult.getDatatypeValue("?ddm:serverName").getString();
                int n = sQWRLResult.getDatatypeValue("?ddm:portNumber").getInt();
                OWLDatatypeProperty oWLDatatypeProperty = OWLFactory.getOWLDatatypeProperty(string);
                Database database = DDMFactory.createDatabase(string6, string8, string7, n);
                if (!this.databases.contains(database)) {
                    this.databases.add(database);
                }
                HashSet<Column> hashSet = new HashSet<Column>();
                HashSet<PrimaryKeyColumn> hashSet2 = new HashSet<PrimaryKeyColumn>();
                PrimaryKeyColumn primaryKeyColumn = DDMFactory.createPrimaryKeyColumn(string4, 999);
                hashSet2.add(primaryKeyColumn);
                hashSet.add(primaryKeyColumn);
                Column column = DDMFactory.createColumn(string5, 999);
                hashSet.add(primaryKeyColumn);
                Table table = DDMFactory.createTable(database, string2, string3, hashSet);
                PrimaryKey primaryKey = DDMFactory.createPrimaryKey(table, hashSet2);
                OWLDatatypePropertyMap oWLDatatypePropertyMap = DDMFactory.createOWLDatatypePropertyMap(oWLDatatypeProperty, primaryKey, column);
                this.datatypePropertyMaps.put(string, oWLDatatypePropertyMap);
                sQWRLResult.next();
            }
        }
    }

    private DatabaseConnection createDatabaseConnection(Database database) throws MapperException {
        DatabaseConnectionImpl databaseConnectionImpl = null;
        try {
            databaseConnectionImpl = new DatabaseConnectionImpl(database, "root", "w0rches");
        }
        catch (SQLException sQLException) {
            throw new MapperException("error creating connection to database '" + database + "': " + sQLException.getMessage());
        }
        return databaseConnectionImpl;
    }

    private DatabaseConnection getDatabaseConnection(Database database) throws MapperException {
        DatabaseConnection databaseConnection = null;
        if (!this.databaseConnections.containsKey(database)) {
            databaseConnection = this.createDatabaseConnection(database);
            this.databaseConnections.put(database, databaseConnection);
        } else {
            databaseConnection = this.databaseConnections.get(database);
        }
        try {
            if (!databaseConnection.isOpen()) {
                databaseConnection.open();
            }
        }
        catch (SQLException sQLException) {
            throw new MapperException("error connecting to database '" + database + "': " + sQLException.getMessage());
        }
        return databaseConnection;
    }
}

