/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.ddm.impl;

import edu.stanford.smi.protegex.owl.swrl.ddm.Column;
import edu.stanford.smi.protegex.owl.swrl.ddm.DDMFactory;
import edu.stanford.smi.protegex.owl.swrl.ddm.Database;
import edu.stanford.smi.protegex.owl.swrl.ddm.DatabaseConnection;
import edu.stanford.smi.protegex.owl.swrl.ddm.ForeignKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.ForeignKeyColumn;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKey;
import edu.stanford.smi.protegex.owl.swrl.ddm.PrimaryKeyColumn;
import edu.stanford.smi.protegex.owl.swrl.ddm.Table;
import edu.stanford.smi.protegex.owl.swrl.ddm.exceptions.JDBCException;
import edu.stanford.smi.protegex.owl.swrl.ddm.impl.JDBCConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnectionImpl
implements DatabaseConnection {
    private String jdbcConnectionString;
    private String userID;
    private String password;
    private Database database;
    private JDBCConnection jdbcConnection = null;
    private Map<String, Table> tableMap;

    public DatabaseConnectionImpl(Database database, String string, String string2) throws SQLException {
        this.database = database;
        this.userID = string;
        this.password = string2;
        this.jdbcConnectionString = JDBCConnection.getConnectionString(database.getJDBCDriverName(), database.getServerName(), database.getDatabaseName(), database.getPortNumber());
        this.tableMap = new HashMap<String, Table>();
    }

    @Override
    public void open() throws JDBCException, SQLException {
        if (this.isOpen()) {
            this.jdbcConnection.closeConnection();
        }
        this.jdbcConnection = new JDBCConnection(this.jdbcConnectionString, this.userID, this.password);
    }

    @Override
    public boolean isOpen() {
        return this.jdbcConnection != null;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (!this.isOpen()) {
            this.open();
        }
        return this.jdbcConnection.executeQuery(string);
    }

    @Override
    public void close() throws SQLException {
        if (this.jdbcConnection != null) {
            this.jdbcConnection.closeConnection();
        }
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Set<String> getSchemaNames() throws SQLException {
        Set<String> set = new HashSet<String>();
        if (this.isOpen()) {
            set = this.jdbcConnection.getSchemaNames();
        }
        return set;
    }

    @Override
    public Set<Table> getTables(String string) throws SQLException {
        HashSet<Table> hashSet = new HashSet<Table>();
        HashSet hashSet2 = new HashSet();
        if (this.isOpen()) {
            for (String string2 : this.jdbcConnection.getTableNames(string)) {
                Table table = this.getTable(string, string2);
                this.processColumns(table);
                this.processPrimaryKey(table);
                this.processForeignKeys(table);
                hashSet.add(table);
            }
        }
        return hashSet;
    }

    private void processColumns(Table table) throws SQLException {
        HashSet<Column> hashSet = new HashSet<Column>();
        String string = table.getSchemaName();
        String string2 = table.getTableName();
        for (String string3 : this.jdbcConnection.getColumnNames(string, string2)) {
            int n = this.jdbcConnection.getColumnType(string, string2, string3);
            hashSet.add(DDMFactory.createColumn(string3, n));
        }
    }

    private void processPrimaryKey(Table table) throws SQLException {
        HashSet<PrimaryKeyColumn> hashSet = new HashSet<PrimaryKeyColumn>();
        String string = table.getSchemaName();
        String string2 = table.getTableName();
        for (String string3 : this.jdbcConnection.getPrimaryKeyColumnNames(string, string2)) {
            int n = this.jdbcConnection.getColumnType(string, string2, string3);
            hashSet.add(DDMFactory.createPrimaryKeyColumn(string3, n));
        }
        if (!hashSet.isEmpty()) {
            PrimaryKey primaryKey = DDMFactory.createPrimaryKey(table, hashSet);
            table.setPrimaryKey(primaryKey);
        }
    }

    private void processForeignKeys(Table table) throws SQLException {
        String string = table.getSchemaName();
        String string2 = table.getTableName();
        Map<String, Map<String, String>> map = this.jdbcConnection.getForeignKeys(string, string2);
        HashSet<ForeignKeyColumn> hashSet = new HashSet<ForeignKeyColumn>();
        for (String string3 : map.keySet()) {
            String string4 = StringUtils.substringBefore((String)string3, (String)".");
            String string5 = string3.equals("") ? string3 : StringUtils.substringAfter((String)string3, (String)".");
            Map<String, String> map2 = map.get(string5);
            Table table2 = this.getTable(string4, string5);
            for (String string6 : map2.keySet()) {
                String string7 = map2.get(string6);
                int n = this.jdbcConnection.getColumnType(string4, string5, string7);
                ForeignKeyColumn foreignKeyColumn = DDMFactory.createForeignKeyColumn(string6, n, string7);
                hashSet.add(foreignKeyColumn);
            }
            ForeignKey foreignKey = DDMFactory.createForeignKey(table, hashSet, table2);
            table.addForeignKey(foreignKey);
        }
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys(String string) throws SQLException {
        HashSet<PrimaryKey> hashSet = new HashSet<PrimaryKey>();
        if (this.isOpen()) {
            for (Table table : this.getTables(string)) {
                if (!table.hasPrimaryKey()) continue;
                hashSet.add(table.getPrimaryKey());
            }
        }
        return hashSet;
    }

    @Override
    public Set<ForeignKey> getForeignKeys(String string) throws SQLException {
        HashSet<ForeignKey> hashSet = new HashSet<ForeignKey>();
        if (this.isOpen()) {
            for (Table table : this.getTables(string)) {
                if (!table.hasForeignKeys()) continue;
                hashSet.addAll(table.getForeignKeys());
            }
        }
        return hashSet;
    }

    @Override
    public Set<Table> getTables() throws SQLException {
        return this.getTables(null);
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() throws SQLException {
        return this.getPrimaryKeys(null);
    }

    @Override
    public Set<ForeignKey> getForeignKeys() throws SQLException {
        return this.getForeignKeys(null);
    }

    private Table getTable(String string, String string2) throws SQLException {
        String string3 = string + ":" + string2;
        Table table = null;
        if (this.tableMap.containsKey(string3)) {
            table = this.tableMap.get(string3);
        } else {
            table = DDMFactory.createTable(this.database, string, string2);
            this.tableMap.put(string3, table);
        }
        return table;
    }
}

