/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.swrl.bridge.Atom;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRule;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.DatatypeConversionException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLNames;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.ResultImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLRuleImpl
implements SWRLRule {
    private String ruleName;
    private List<Atom> bodyAtoms;
    private List<Atom> headAtoms;
    private Set<String> referencedVariableNames;
    private ResultImpl sqwrlResult = null;
    private boolean hasSQWRLBuiltIns;
    private boolean hasSQWRLCollectionBuiltIns;

    public SWRLRuleImpl(String string, List<Atom> list, List<Atom> list2) throws BuiltInException, SQWRLException {
        this.ruleName = string;
        this.bodyAtoms = list;
        this.headAtoms = list2;
        this.hasSQWRLBuiltIns = false;
        this.hasSQWRLCollectionBuiltIns = false;
        this.buildReferencedVariableNames();
        this.processBodyAtoms();
        this.processSQWRLAtoms();
    }

    @Override
    public String getRuleName() {
        return this.ruleName;
    }

    @Override
    public List<Atom> getHeadAtoms() {
        return this.headAtoms;
    }

    @Override
    public List<Atom> getBodyAtoms() {
        return this.bodyAtoms;
    }

    @Override
    public boolean isSQWRL() {
        return this.hasSQWRLBuiltIns;
    }

    @Override
    public boolean usesSQWRLCollections() {
        return this.hasSQWRLCollectionBuiltIns;
    }

    @Override
    public List<BuiltInAtom> getBuiltInAtomsFromHead() {
        return this.getBuiltInAtoms(this.headAtoms);
    }

    @Override
    public List<BuiltInAtom> getBuiltInAtomsFromHead(Set<String> set) {
        return this.getBuiltInAtoms(this.headAtoms, set);
    }

    @Override
    public List<BuiltInAtom> getBuiltInAtomsFromBody() {
        return this.getBuiltInAtoms(this.bodyAtoms);
    }

    @Override
    public List<BuiltInAtom> getBuiltInAtomsFromBody(Set<String> set) {
        return this.getBuiltInAtoms(this.bodyAtoms, set);
    }

    @Override
    public void appendAtomsToBody(List<Atom> list) {
        this.bodyAtoms.addAll(list);
    }

    @Override
    public List<Atom> getSQWRLPhase1BodyAtoms() {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Atom atom : this.bodyAtoms) {
            if (atom instanceof BuiltInAtom && ((BuiltInAtom)atom).usesSQWRLVariables()) continue;
            arrayList.add(atom);
        }
        return arrayList;
    }

    @Override
    public List<Atom> getSQWRLPhase2BodyAtoms() {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Atom atom : this.bodyAtoms) {
            if (atom instanceof BuiltInAtom && ((BuiltInAtom)atom).isSQWRLMakeCollection()) continue;
            arrayList.add(atom);
        }
        return arrayList;
    }

    @Override
    public ResultImpl getSQWRLResult() {
        return this.sqwrlResult;
    }

    private void processBodyAtoms() throws BuiltInException {
        ArrayList<BuiltInAtom> arrayList = new ArrayList<BuiltInAtom>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Atom atom : this.getBodyAtoms()) {
            if (atom instanceof BuiltInAtom) {
                arrayList.add((BuiltInAtom)atom);
                continue;
            }
            arrayList2.add(atom);
            hashSet.addAll(atom.getReferencedVariableNames());
        }
        for (BuiltInAtom builtInAtom : arrayList) {
            for (BuiltInArgument builtInArgument : builtInAtom.getArguments()) {
                String string;
                if (!builtInArgument.isVariable() || hashSet.contains(string = builtInArgument.getVariableName()) || hashSet2.contains(string)) continue;
                builtInArgument.setUnbound();
                hashSet2.add(string);
            }
        }
        this.bodyAtoms = this.processBodyNonBuiltInAtoms(arrayList2);
        this.bodyAtoms.addAll(arrayList);
    }

    private List<Atom> processBodyNonBuiltInAtoms(List<Atom> list) {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        ArrayList<Atom> arrayList3 = new ArrayList<Atom>();
        for (Atom atom : list) {
            if (atom instanceof ClassAtom) {
                arrayList.add(atom);
                continue;
            }
            arrayList2.add(atom);
        }
        arrayList3.addAll(arrayList2);
        arrayList3.addAll(arrayList);
        return arrayList3;
    }

    private List<BuiltInAtom> getBuiltInAtoms(List<Atom> list, Set<String> set) {
        ArrayList<BuiltInAtom> arrayList = new ArrayList<BuiltInAtom>();
        for (Atom atom : list) {
            BuiltInAtom builtInAtom;
            if (!(atom instanceof BuiltInAtom) || !set.contains((builtInAtom = (BuiltInAtom)atom).getBuiltInName())) continue;
            arrayList.add(builtInAtom);
        }
        return arrayList;
    }

    private List<BuiltInAtom> getBuiltInAtoms(List<Atom> list) {
        ArrayList<BuiltInAtom> arrayList = new ArrayList<BuiltInAtom>();
        for (Atom atom : list) {
            if (!(atom instanceof BuiltInAtom)) continue;
            arrayList.add((BuiltInAtom)atom);
        }
        return arrayList;
    }

    private void buildReferencedVariableNames() {
        this.referencedVariableNames = new HashSet<String>();
        for (Atom atom : this.getBodyAtoms()) {
            this.referencedVariableNames.addAll(atom.getReferencedVariableNames());
        }
    }

    private void processSQWRLAtoms() throws DatatypeConversionException, BuiltInException {
        HashMap<String, List<BuiltInArgument>> hashMap = new HashMap<String, List<BuiltInArgument>>();
        HashSet<String> hashSet = new HashSet<String>();
        this.sqwrlResult = new ResultImpl();
        this.preprocessSQWRLHeadBuiltIns();
        this.preprocessSQWRLMakeBuiltIns(hashSet, hashMap);
        this.preprocessSQWRLOperationBuiltIns(hashSet, hashMap);
        this.sqwrlResult.configured();
        this.sqwrlResult.openRow();
        if (this.hasSQWRLCollectionBuiltIns) {
            this.sqwrlResult.setIsDistinct();
        }
    }

    private void preprocessBuiltInIndexes() {
        int n = 0;
        for (BuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody()) {
            builtInAtom.setBuiltInIndex(n++);
        }
        for (BuiltInAtom builtInAtom : this.getBuiltInAtomsFromHead()) {
            builtInAtom.setBuiltInIndex(n++);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void preprocessSQWRLHeadBuiltIns() throws DatatypeConversionException, SQWRLException, BuiltInException {
        ArrayList<String> arrayList = new ArrayList<String>();
        this.preprocessBuiltInIndexes();
        for (BuiltInAtom builtInAtom : this.getBuiltInAtomsFromHead(SQWRLNames.getHeadBuiltInNames())) {
            String string = builtInAtom.getBuiltInName();
            this.hasSQWRLBuiltIns = true;
            for (BuiltInArgument builtInArgument : builtInAtom.getArguments()) {
                int n;
                String string2;
                boolean bl = builtInArgument.isVariable();
                String string3 = null;
                int n2 = 0;
                if (bl) {
                    string3 = builtInArgument.getVariableName();
                    arrayList.add(string3);
                }
                if (string.equalsIgnoreCase("sqwrl:select")) {
                    string2 = bl ? "?" + string3 : "[" + builtInArgument + "]";
                    this.sqwrlResult.addColumn(string2);
                } else if (string.equalsIgnoreCase("sqwrl:selectDistinct")) {
                    string2 = bl ? "?" + string3 : "[" + builtInArgument + "]";
                    this.sqwrlResult.addColumn(string2);
                    this.sqwrlResult.setIsDistinct();
                } else if (string.equalsIgnoreCase("sqwrl:count")) {
                    string2 = bl ? "count(?" + string3 + ")" : "[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "count");
                } else if (string.equalsIgnoreCase("sqwrl:countDistinct")) {
                    string2 = bl ? "countDistinct(?" + string3 + ")" : "[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "countDistinct");
                } else if (string.equalsIgnoreCase("sqwrl:min")) {
                    string2 = bl ? "min(?" + string3 + ")" : "min[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "min");
                } else if (string.equalsIgnoreCase("sqwrl:max")) {
                    string2 = bl ? "max(?" + string3 + ")" : "max[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "max");
                } else if (string.equalsIgnoreCase("sqwrl:sum")) {
                    string2 = bl ? "sum(?" + string3 + ")" : "sum[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "sum");
                } else if (string.equalsIgnoreCase("sqwrl:avg")) {
                    string2 = bl ? "avg(?" + string3 + ")" : "avg[" + builtInArgument + "]";
                    this.sqwrlResult.addAggregateColumn(string2, "avg");
                } else if (string.equalsIgnoreCase("sqwrl:orderBy")) {
                    if (!bl) {
                        throw new SQWRLException("only variables allowed for ordered columns - found '" + builtInArgument + "'");
                    }
                    n = arrayList.indexOf(string3);
                    if (n == -1) throw new SQWRLException("variable ?" + string3 + " must be selected before it can be ordered");
                    this.sqwrlResult.addOrderByColumn(n, true);
                } else if (string.equalsIgnoreCase("sqwrl:orderByDescending")) {
                    if (!bl) {
                        throw new SQWRLException("only variables allowed for ordered columns - found '" + builtInArgument + "'");
                    }
                    n = arrayList.indexOf(string3);
                    if (n == -1) throw new SQWRLException("variable ?" + string3 + " must be selected before it can be ordered");
                    this.sqwrlResult.addOrderByColumn(n, false);
                } else if (string.equalsIgnoreCase("sqwrl:columnNames")) {
                    if (!(builtInArgument instanceof OWLDatatypeValue) || !((OWLDatatypeValue)builtInArgument).isString()) throw new SQWRLException("only string literals allowed as column names - found '" + builtInArgument + "'");
                    OWLDatatypeValue oWLDatatypeValue = (OWLDatatypeValue)builtInArgument;
                    this.sqwrlResult.addColumnDisplayName(oWLDatatypeValue.getString());
                }
                ++n2;
            }
        }
    }

    private void preprocessSQWRLMakeBuiltIns(Set<String> set, Map<String, List<BuiltInArgument>> map) throws BuiltInException {
        for (BuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody(SQWRLNames.getCollectionMakeBuiltInNames())) {
            if (builtInAtom.getNumberOfArguments() < 2) {
                throw new SQWRLException("make-collection built-ins must have at least two arguments");
            }
            String string = builtInAtom.getArgumentVariableName(0);
            this.hasSQWRLCollectionBuiltIns = true;
            System.err.println("preprocessSQWRLMakeBuiltIns");
            builtInAtom.setIsSQWRLMakeCollection();
            if (!set.contains(string)) {
                set.add(string);
            }
            if (builtInAtom.getNumberOfArguments() > 2) {
                List<BuiltInArgument> list = builtInAtom.getArguments();
                List<BuiltInArgument> list2 = list.subList(2, list.size());
                if (map.containsKey(string)) {
                    throw new SQWRLException("pattern specified more than once for collection ?" + string);
                }
                map.put(string, list2);
                continue;
            }
            if (!map.containsKey(string)) continue;
            builtInAtom.addArguments(map.get(string));
        }
    }

    private void preprocessSQWRLOperationBuiltIns(Set<String> set, Map<String, List<BuiltInArgument>> map) throws SQWRLException, BuiltInException {
        HashSet<String> hashSet = new HashSet<String>();
        for (BuiltInAtom builtInAtom : this.getBuiltInAtomsFromBody()) {
            String string = builtInAtom.getBuiltInName();
            if (SQWRLNames.getCollectionOperationBuiltInNames().contains(string)) {
                if (builtInAtom.getNumberOfArguments() < 1) {
                    throw new SQWRLException("collection-operation built-ins must have at least one argument");
                }
                this.hasSQWRLCollectionBuiltIns = true;
                System.err.println("preprocessSQWRLOperationBuiltIns");
                for (String string2 : builtInAtom.getArgumentsVariableNames()) {
                    if (!map.containsKey(string2)) continue;
                    builtInAtom.addArguments(map.get(string2));
                }
                builtInAtom.setUsesSQWRLVariables();
                hashSet.addAll(builtInAtom.getUnboundArgumentVariableNames());
                continue;
            }
            if (SQWRLNames.getSQWRLBuiltInNames().contains(string) || !builtInAtom.usesAtLeastOneVariableOf(hashSet)) continue;
            builtInAtom.setUsesSQWRLVariables();
            hashSet.addAll(builtInAtom.getUnboundArgumentVariableNames());
        }
    }

    public String toString() {
        String string = this.getRuleName() + ": ";
        boolean bl = true;
        for (Atom atom : this.getBodyAtoms()) {
            if (!bl) {
                string = string + " ^ ";
            }
            string = string + "" + atom;
            bl = false;
        }
        string = string + " -> ";
        bl = true;
        for (Atom atom : this.getHeadAtoms()) {
            if (!bl) {
                string = string + " ^ ";
            }
            string = string + "" + atom;
            bl = false;
        }
        return string;
    }
}

