/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.DatatypeConversionException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.BuiltInArgumentImpl;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OWLPropertyImpl
extends BuiltInArgumentImpl
implements OWLProperty {
    private String propertyName;
    private Set<String> domainClassNames;
    private Set<String> rangeClassNames;
    private Set<String> superPropertyNames;
    private Set<String> subPropertyNames;
    private Set<String> equivalentPropertyNames;
    private Set<String> equivalentPropertySuperPropertyNames;

    public OWLPropertyImpl(OWLModel oWLModel, String string) throws OWLFactoryException {
        this.propertyName = string;
        edu.stanford.smi.protegex.owl.model.OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(string);
        }
        this.domainClassNames = SWRLOWLUtil.rdfResources2Names(oWLProperty.getUnionDomain(true));
        this.rangeClassNames = SWRLOWLUtil.rdfResources2Names(oWLProperty.getUnionRangeClasses());
        this.superPropertyNames = SWRLOWLUtil.rdfResources2Names(oWLProperty.getSuperproperties(true));
        this.subPropertyNames = SWRLOWLUtil.rdfResources2Names(oWLProperty.getSubproperties(true));
        this.equivalentPropertyNames = SWRLOWLUtil.rdfResources2Names(oWLProperty.getEquivalentProperties());
        this.equivalentPropertySuperPropertyNames = new HashSet<String>();
        for (String string2 : this.equivalentPropertyNames) {
            edu.stanford.smi.protegex.owl.model.OWLProperty oWLProperty2 = SWRLOWLUtil.getOWLProperty(oWLModel, string2);
            for (RDFProperty rDFProperty : oWLProperty2.getSuperproperties(true)) {
                this.equivalentPropertySuperPropertyNames.add(rDFProperty.getName());
            }
        }
    }

    public OWLPropertyImpl(String string) {
        this.propertyName = string;
        this.initialize();
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public Set<String> getDomainClassNames() {
        return this.domainClassNames;
    }

    @Override
    public Set<String> getRangeClassNames() {
        return this.rangeClassNames;
    }

    @Override
    public Set<String> getSuperPropertyNames() {
        return this.superPropertyNames;
    }

    @Override
    public Set<String> getSubPropertyNames() {
        return this.subPropertyNames;
    }

    @Override
    public Set<String> getEquivalentPropertyNames() {
        return this.equivalentPropertyNames;
    }

    @Override
    public Set<String> getEquivalentPropertySuperPropertyNames() {
        return this.equivalentPropertySuperPropertyNames;
    }

    public String getRepresentation() {
        return this.getPropertyName();
    }

    public String toString() {
        return this.getPropertyName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OWLPropertyImpl oWLPropertyImpl = (OWLPropertyImpl)object;
        return (this.getPropertyName() == oWLPropertyImpl.getPropertyName() || this.getPropertyName() != null && this.getPropertyName().equals(oWLPropertyImpl.getPropertyName())) && (this.domainClassNames == oWLPropertyImpl.domainClassNames || this.domainClassNames != null && ((Object)this.domainClassNames).equals(oWLPropertyImpl.domainClassNames)) && (this.rangeClassNames == oWLPropertyImpl.rangeClassNames || this.rangeClassNames != null && ((Object)this.rangeClassNames).equals(oWLPropertyImpl.rangeClassNames)) && (this.subPropertyNames == oWLPropertyImpl.subPropertyNames || this.subPropertyNames != null && ((Object)this.subPropertyNames).equals(oWLPropertyImpl.subPropertyNames)) && (this.superPropertyNames == oWLPropertyImpl.superPropertyNames || this.superPropertyNames != null && ((Object)this.superPropertyNames).equals(oWLPropertyImpl.superPropertyNames)) && (this.equivalentPropertyNames == oWLPropertyImpl.equivalentPropertyNames || this.equivalentPropertyNames != null && ((Object)this.equivalentPropertyNames).equals(oWLPropertyImpl.equivalentPropertyNames)) && (this.equivalentPropertySuperPropertyNames == oWLPropertyImpl.equivalentPropertySuperPropertyNames || this.equivalentPropertySuperPropertyNames != null && ((Object)this.equivalentPropertySuperPropertyNames).equals(oWLPropertyImpl.equivalentPropertySuperPropertyNames));
    }

    @Override
    public int hashCode() {
        int n = 767;
        n += null == this.getPropertyName() ? 0 : this.getPropertyName().hashCode();
        n += null == this.domainClassNames ? 0 : ((Object)this.domainClassNames).hashCode();
        n += null == this.rangeClassNames ? 0 : ((Object)this.rangeClassNames).hashCode();
        n += null == this.subPropertyNames ? 0 : ((Object)this.subPropertyNames).hashCode();
        n += null == this.superPropertyNames ? 0 : ((Object)this.superPropertyNames).hashCode();
        n += null == this.equivalentPropertyNames ? 0 : ((Object)this.equivalentPropertyNames).hashCode();
        return n += null == this.equivalentPropertySuperPropertyNames ? 0 : ((Object)this.equivalentPropertySuperPropertyNames).hashCode();
    }

    public int compareTo(Object object) {
        return this.propertyName.compareTo(((OWLPropertyImpl)object).getPropertyName());
    }

    public static Set<OWLPropertyAssertionAxiom> buildOWLPropertyAssertionAxioms(OWLModel oWLModel, String string) throws OWLFactoryException, DatatypeConversionException {
        HashSet<OWLPropertyAssertionAxiom> hashSet = new HashSet<OWLPropertyAssertionAxiom>();
        edu.stanford.smi.protegex.owl.model.OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(oWLModel, string);
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(string);
        }
        TripleStoreModel tripleStoreModel = oWLModel.getTripleStoreModel();
        Iterator<RDFResource> iterator = tripleStoreModel.listSubjects(oWLProperty);
        while (iterator.hasNext()) {
            RDFResource rDFResource = iterator.next();
            if (!(rDFResource instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual)) continue;
            edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual = (edu.stanford.smi.protegex.owl.model.OWLIndividual)rDFResource;
            for (Object e : rDFResource.getPropertyValues(oWLProperty)) {
                OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom;
                AtomArgument atomArgument;
                Comparable comparable;
                Object object;
                if (oWLProperty.hasObjectRange()) {
                    if (e instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual) {
                        object = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e;
                        comparable = OWLFactory.createOWLIndividual(oWLModel, oWLIndividual.getName());
                        atomArgument = OWLFactory.createOWLIndividual(oWLModel, object.getName());
                        oWLPropertyAssertionAxiom = OWLFactory.createOWLObjectPropertyAssertionAxiom((OWLIndividual)comparable, OWLFactory.createOWLObjectProperty(oWLModel, string), (OWLIndividual)atomArgument);
                        hashSet.add(oWLPropertyAssertionAxiom);
                        continue;
                    }
                    if (e instanceof OWLNamedClass) {
                        object = (OWLNamedClass)e;
                        comparable = OWLFactory.createOWLIndividual(oWLModel, oWLIndividual.getName());
                        atomArgument = OWLFactory.createOWLClass(oWLModel, object.getName());
                        oWLPropertyAssertionAxiom = OWLFactory.createOWLClassPropertyAssertionAxiom((OWLIndividual)comparable, OWLFactory.createOWLObjectProperty(oWLModel, string), (OWLClass)atomArgument);
                        hashSet.add(oWLPropertyAssertionAxiom);
                        continue;
                    }
                    if (!(e instanceof edu.stanford.smi.protegex.owl.model.OWLProperty)) continue;
                    object = (edu.stanford.smi.protegex.owl.model.OWLProperty)e;
                    comparable = OWLFactory.createOWLIndividual(oWLModel, oWLIndividual.getName());
                    atomArgument = object.isObjectProperty() ? OWLFactory.createOWLObjectProperty(oWLModel, object.getName()) : OWLFactory.createOWLDatatypeProperty(oWLModel, object.getName());
                    oWLPropertyAssertionAxiom = OWLFactory.createOWLPropertyPropertyAssertionAxiom((OWLIndividual)comparable, OWLFactory.createOWLObjectProperty(oWLModel, string), (OWLProperty)atomArgument);
                    hashSet.add(oWLPropertyAssertionAxiom);
                    continue;
                }
                object = OWLFactory.createOWLIndividual(oWLModel, oWLIndividual.getName());
                comparable = oWLModel.asRDFSLiteral(e);
                atomArgument = OWLFactory.createOWLDatatypeValue(oWLModel, comparable);
                oWLPropertyAssertionAxiom = OWLFactory.createOWLDatatypePropertyAssertionAxiom((OWLIndividual)object, OWLFactory.createOWLDatatypeProperty(oWLModel, string), atomArgument);
                hashSet.add(oWLPropertyAssertionAxiom);
            }
        }
        return hashSet;
    }

    private void initialize() {
        this.domainClassNames = new HashSet<String>();
        this.rangeClassNames = new HashSet<String>();
        this.superPropertyNames = new HashSet<String>();
        this.subPropertyNames = new HashSet<String>();
        this.equivalentPropertyNames = new HashSet<String>();
        this.equivalentPropertySuperPropertyNames = new HashSet<String>();
    }
}

