/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidIndividualNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.PropertyValueImpl;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLIndividualImpl
extends PropertyValueImpl
implements OWLIndividual {
    private String individualName;
    private Set<String> definingClassNames;
    private Set<String> definingSuperclassNames;
    private Set<String> definingEquivalentClassNames;
    private Set<String> definingEquivalentClassSuperclassNames;
    private Set<String> sameAsIndividualNames;

    public OWLIndividualImpl(edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual) throws OWLFactoryException {
        this.initialize(oWLIndividual.getName());
        this.buildDefiningClassNames(oWLIndividual);
        this.buildDefiningSuperclassNames(oWLIndividual);
        this.buildDefiningEquivalentClassNames(oWLIndividual);
        this.buildSameAsIndividualNames(oWLIndividual);
    }

    public OWLIndividualImpl(OWLModel oWLModel, String string) throws OWLFactoryException {
        edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(string);
        if (oWLIndividual == null) {
            throw new InvalidIndividualNameException(string);
        }
        this.initialize(string);
        this.buildDefiningClassNames(oWLIndividual);
        this.buildDefiningSuperclassNames(oWLIndividual);
        this.buildDefiningEquivalentClassNames(oWLIndividual);
        this.buildSameAsIndividualNames(oWLIndividual);
    }

    public OWLIndividualImpl(String string, String string2) {
        this.initialize(string);
        this.definingClassNames.add(string2);
    }

    public OWLIndividualImpl(String string) {
        this.initialize(string);
    }

    @Override
    public String getIndividualName() {
        return this.individualName;
    }

    @Override
    public Set<String> getDefiningClassNames() {
        return this.definingClassNames;
    }

    @Override
    public Set<String> getDefiningSuperclassNames() {
        return this.definingSuperclassNames;
    }

    @Override
    public Set<String> getDefiningEquivalentClassNames() {
        return this.definingEquivalentClassNames;
    }

    @Override
    public Set<String> getDefiningEquivalentClassSuperclassNames() {
        return this.definingEquivalentClassSuperclassNames;
    }

    @Override
    public Set<String> getSameAsIndividualNames() {
        return this.sameAsIndividualNames;
    }

    @Override
    public void write2OWL(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual = oWLModel.getOWLIndividual(this.getIndividualName());
        if (oWLIndividual == null) {
            throw new InvalidIndividualNameException(this.getIndividualName());
        }
        for (String string : this.getDefiningClassNames()) {
            OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
            if (oWLIndividual.hasRDFType(oWLNamedClass)) continue;
            if (oWLIndividual.hasRDFType(oWLModel.getOWLThingClass())) {
                oWLIndividual.setRDFType(oWLNamedClass);
                continue;
            }
            oWLIndividual.addRDFType(oWLNamedClass);
        }
    }

    public String getRepresentation() {
        return this.getIndividualName();
    }

    public String toString() {
        return this.getIndividualName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OWLIndividualImpl oWLIndividualImpl = (OWLIndividualImpl)object;
        return (this.getIndividualName() == oWLIndividualImpl.getIndividualName() || this.getIndividualName() != null && this.getIndividualName().equals(oWLIndividualImpl.getIndividualName())) && this.definingClassNames != null && oWLIndividualImpl.definingClassNames != null && ((Object)this.definingClassNames).equals(oWLIndividualImpl.definingClassNames) && this.definingSuperclassNames != null && oWLIndividualImpl.definingSuperclassNames != null && ((Object)this.definingSuperclassNames).equals(oWLIndividualImpl.definingSuperclassNames) && this.definingEquivalentClassNames != null && oWLIndividualImpl.definingEquivalentClassNames != null && ((Object)this.definingEquivalentClassNames).equals(oWLIndividualImpl.definingEquivalentClassNames) && this.definingEquivalentClassSuperclassNames != null && oWLIndividualImpl.definingEquivalentClassSuperclassNames != null && ((Object)this.definingEquivalentClassSuperclassNames).equals(oWLIndividualImpl.definingEquivalentClassSuperclassNames);
    }

    @Override
    public int hashCode() {
        int n = 8;
        n += null == this.getIndividualName() ? 0 : this.getIndividualName().hashCode();
        n += null == this.getDefiningClassNames() ? 0 : ((Object)this.getDefiningClassNames()).hashCode();
        n += null == this.getDefiningSuperclassNames() ? 0 : ((Object)this.getDefiningSuperclassNames()).hashCode();
        n += null == this.getDefiningEquivalentClassNames() ? 0 : ((Object)this.getDefiningEquivalentClassNames()).hashCode();
        return n += null == this.getDefiningEquivalentClassSuperclassNames() ? 0 : ((Object)this.getDefiningEquivalentClassSuperclassNames()).hashCode();
    }

    public int compareTo(Object object) {
        return this.individualName.compareTo(((OWLIndividualImpl)object).getIndividualName());
    }

    private void initialize(String string) {
        this.individualName = string;
        this.definingClassNames = new HashSet<String>();
        this.definingSuperclassNames = new HashSet<String>();
        this.definingEquivalentClassNames = new HashSet<String>();
        this.sameAsIndividualNames = new HashSet<String>();
        this.definingEquivalentClassSuperclassNames = new HashSet<String>();
    }

    private void buildDefiningClassNames(edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual) {
        for (Object e : oWLIndividual.getRDFTypes()) {
            RDFSClass rDFSClass = (RDFSClass)e;
            if (rDFSClass.isAnonymous()) continue;
            this.definingClassNames.add(rDFSClass.getName());
        }
    }

    private void buildDefiningSuperclassNames(edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual) {
        for (RDFSClass rDFSClass : oWLIndividual.getRDFTypes()) {
            for (RDFSClass rDFSClass2 : rDFSClass.getNamedSuperclasses(true)) {
                if (rDFSClass2.isAnonymous() || this.definingSuperclassNames.contains(rDFSClass2.getName())) continue;
                this.definingSuperclassNames.add(rDFSClass2.getName());
            }
        }
    }

    private void buildDefiningEquivalentClassNames(edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual) {
        for (RDFSClass rDFSClass : oWLIndividual.getRDFTypes()) {
            for (RDFSClass rDFSClass2 : rDFSClass.getEquivalentClasses()) {
                if (rDFSClass2.isAnonymous() || this.definingEquivalentClassNames.contains(rDFSClass2.getName())) continue;
                for (RDFSClass rDFSClass3 : rDFSClass2.getNamedSuperclasses(true)) {
                    this.definingEquivalentClassSuperclassNames.add(rDFSClass3.getName());
                }
                this.definingEquivalentClassNames.add(rDFSClass2.getName());
            }
        }
    }

    private void buildSameAsIndividualNames(edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual) {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLSameAsProperty(oWLIndividual.getOWLModel());
        if (oWLIndividual.hasPropertyValue(rDFProperty)) {
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e : collection) {
                if (!(e instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual)) continue;
                edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual2 = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e;
                this.sameAsIndividualNames.add(oWLIndividual2.getName());
            }
        }
    }
}

