/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.DatatypeConversionException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.BuiltInArgumentImpl;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.AnyURI;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.Base64Binary;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.Date;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.DateTime;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.Duration;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.GDay;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.GMonth;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.GMonthDay;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.GYear;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.GYearMonth;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.HexBinary;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.NOTATION;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.PrimitiveXSDType;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.QName;
import edu.stanford.smi.protegex.owl.swrl.bridge.xsd.Time;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;

public class OWLDatatypeValueImpl
extends BuiltInArgumentImpl
implements OWLDatatypeValue,
Externalizable {
    private Object value;

    public OWLDatatypeValueImpl() {
        this.value = null;
    }

    public OWLDatatypeValueImpl(String string) {
        this.value = string;
    }

    public OWLDatatypeValueImpl(Number number) {
        this.value = number;
    }

    public OWLDatatypeValueImpl(boolean bl) {
        this.value = bl;
    }

    public OWLDatatypeValueImpl(int n) {
        this.value = n;
    }

    public OWLDatatypeValueImpl(long l) {
        this.value = l;
    }

    public OWLDatatypeValueImpl(float f) {
        this.value = Float.valueOf(f);
    }

    public OWLDatatypeValueImpl(double d) {
        this.value = d;
    }

    public OWLDatatypeValueImpl(short s) {
        this.value = s;
    }

    public OWLDatatypeValueImpl(PrimitiveXSDType primitiveXSDType) {
        this.value = primitiveXSDType;
    }

    public OWLDatatypeValueImpl(OWLModel oWLModel, RDFSLiteral rDFSLiteral) throws DatatypeConversionException {
        RDFSDatatype rDFSDatatype = rDFSLiteral.getDatatype();
        if (rDFSDatatype == oWLModel.getXSDint() || rDFSDatatype == oWLModel.getXSDinteger()) {
            this.value = rDFSLiteral.getInt();
        } else if (rDFSDatatype == oWLModel.getXSDshort()) {
            this.value = rDFSLiteral.getShort();
        } else if (rDFSDatatype == oWLModel.getXSDlong()) {
            this.value = rDFSLiteral.getLong();
        } else if (rDFSDatatype == oWLModel.getXSDboolean()) {
            this.value = rDFSLiteral.getBoolean();
        } else if (rDFSDatatype == oWLModel.getXSDfloat()) {
            this.value = Float.valueOf(rDFSLiteral.getFloat());
        } else if (rDFSDatatype == oWLModel.getXSDdouble()) {
            this.value = rDFSLiteral.getDouble();
        } else if (rDFSDatatype == oWLModel.getXSDstring()) {
            this.value = String.valueOf(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDtime()) {
            this.value = new Time(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDanyURI()) {
            this.value = new AnyURI(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDbase64Binary()) {
            this.value = new Base64Binary(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDbyte()) {
            this.value = Byte.valueOf(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDduration()) {
            this.value = new Duration(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDdateTime()) {
            this.value = new DateTime(rDFSLiteral.getString());
        } else if (rDFSDatatype == oWLModel.getXSDdate()) {
            this.value = new Date(rDFSLiteral.getString());
        } else {
            throw new DatatypeConversionException("cannot create an OWLDatatypeValue object for RDFS literal '" + rDFSLiteral.getString() + "' of type '" + rDFSDatatype + "'");
        }
    }

    public RDFSLiteral asRDFSLiteral(OWLModel oWLModel) throws DatatypeConversionException {
        RDFSLiteral rDFSLiteral = null;
        if (this.isString()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getString());
        } else if (this.isInteger()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getInt());
        } else if (this.isLong()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getLong());
        } else if (this.isBoolean()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getBoolean());
        } else if (this.isFloat()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(Float.valueOf(this.getFloat()));
        } else if (this.isDouble()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getDouble());
        } else if (this.isShort()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getShort());
        } else if (this.isBigDecimal()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getBigDecimal());
        } else if (this.isBigInteger()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getBigInteger());
        } else if (this.isByte()) {
            rDFSLiteral = oWLModel.asRDFSLiteral(this.getByte());
        } else {
            throw new DatatypeConversionException("cannot convert OWLDatatypeValue with value '" + this.value + "' to RDFSLiteral");
        }
        return rDFSLiteral;
    }

    public boolean isString() {
        return this.value instanceof String;
    }

    public boolean isBoolean() {
        return this.value instanceof Boolean;
    }

    public boolean isNumeric() {
        return this.value instanceof Number;
    }

    public boolean isInteger() {
        return this.value instanceof Integer;
    }

    public boolean isLong() {
        return this.value instanceof Long;
    }

    public boolean isFloat() {
        return this.value instanceof Float;
    }

    public boolean isDouble() {
        return this.value instanceof Double;
    }

    public boolean isShort() {
        return this.value instanceof Short;
    }

    public boolean isByte() {
        return this.value instanceof Byte;
    }

    public boolean isBigDecimal() {
        return this.value instanceof BigDecimal;
    }

    public boolean isBigInteger() {
        return this.value instanceof BigInteger;
    }

    public boolean isPrimitiveXSDType() {
        return this.value instanceof PrimitiveXSDType;
    }

    public boolean isTime() {
        return this.value instanceof Time;
    }

    public boolean isDate() {
        return this.value instanceof Date;
    }

    public boolean isDateTime() {
        return this.value instanceof DateTime;
    }

    public boolean isDuration() {
        return this.value instanceof Duration;
    }

    public boolean isAnyURI() {
        return this.value instanceof AnyURI;
    }

    public boolean isBase64Binary() {
        return this.value instanceof Base64Binary;
    }

    public boolean isHexBinary() {
        return this.value instanceof HexBinary;
    }

    public boolean isGMonth() {
        return this.value instanceof GMonth;
    }

    public boolean isGYear() {
        return this.value instanceof GYear;
    }

    public boolean isGYearMonth() {
        return this.value instanceof GYearMonth;
    }

    public boolean isGDay() {
        return this.value instanceof GDay;
    }

    public boolean isGMonthDay() {
        return this.value instanceof GMonthDay;
    }

    public boolean isNOTATION() {
        return this.value instanceof NOTATION;
    }

    public boolean isQName() {
        return this.value instanceof QName;
    }

    public String getString() throws DatatypeConversionException {
        if (!this.isString()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to String");
        }
        return (String)this.value;
    }

    public Number getNumber() throws DatatypeConversionException {
        if (!this.isNumeric()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to Number");
        }
        return (Number)this.value;
    }

    public PrimitiveXSDType getPrimitiveXSDType() throws DatatypeConversionException {
        if (!this.isPrimitiveXSDType()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to PrimitiveXSDType");
        }
        return (PrimitiveXSDType)this.value;
    }

    public boolean getBoolean() throws DatatypeConversionException {
        if (!this.isBoolean()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to boolean");
        }
        return (Boolean)this.value;
    }

    public int getInt() throws DatatypeConversionException {
        int n = 0;
        if (this.isInteger()) {
            n = (Integer)this.value;
        } else if (this.isShort()) {
            n = ((Short)this.value).shortValue();
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to int");
        }
        return n;
    }

    public long getLong() throws DatatypeConversionException {
        long l = 0L;
        if (this.isLong()) {
            l = (Long)this.value;
        } else if (this.isInteger()) {
            l = ((Integer)this.value).intValue();
        } else if (this.isShort()) {
            l = ((Short)this.value).shortValue();
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to long");
        }
        return l;
    }

    public float getFloat() throws DatatypeConversionException {
        float f = 0.0f;
        if (this.isFloat()) {
            f = ((Float)this.value).floatValue();
        } else if (this.isInteger()) {
            f = ((Integer)this.value).intValue();
        } else if (this.isLong()) {
            f = ((Long)this.value).longValue();
        } else if (this.isShort()) {
            f = ((Short)this.value).shortValue();
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to float");
        }
        return f;
    }

    public double getDouble() throws DatatypeConversionException {
        double d = 0.0;
        if (this.isDouble()) {
            d = (Double)this.value;
        } else if (this.isFloat()) {
            d = ((Float)this.value).floatValue();
        } else if (this.isInteger()) {
            d = ((Integer)this.value).intValue();
        } else if (this.isLong()) {
            d = ((Long)this.value).longValue();
        } else if (this.isShort()) {
            d = ((Short)this.value).shortValue();
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to double");
        }
        return d;
    }

    public BigDecimal getBigDecimal() throws DatatypeConversionException {
        BigDecimal bigDecimal = null;
        if (this.isBigDecimal()) {
            bigDecimal = (BigDecimal)this.value;
        } else if (this.isBigInteger()) {
            bigDecimal = new BigDecimal((BigInteger)this.value);
        }
        if (this.isDouble()) {
            bigDecimal = new BigDecimal(this.getDouble());
        } else if (this.isFloat()) {
            bigDecimal = new BigDecimal(this.getDouble());
        } else if (this.isInteger()) {
            bigDecimal = new BigDecimal(this.getDouble());
        } else if (this.isLong()) {
            bigDecimal = new BigDecimal(this.getDouble());
        } else if (this.isShort()) {
            bigDecimal = new BigDecimal(this.getDouble());
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to BigDecimal");
        }
        return bigDecimal;
    }

    public BigInteger getBigInteger() throws DatatypeConversionException {
        BigInteger bigInteger = null;
        if (this.isBigInteger()) {
            bigInteger = (BigInteger)this.value;
        } else if (this.isInteger()) {
            bigInteger = BigInteger.valueOf(this.getLong());
        } else if (this.isLong()) {
            bigInteger = BigInteger.valueOf(this.getLong());
        } else if (this.isShort()) {
            bigInteger = BigInteger.valueOf(this.getLong());
        } else {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to BigInteger");
        }
        return bigInteger;
    }

    public short getShort() throws DatatypeConversionException {
        if (!this.isShort()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to short");
        }
        return (Short)this.value;
    }

    public byte getByte() throws DatatypeConversionException {
        if (!this.isByte()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getCanonicalName() + "' to byte");
        }
        return (Byte)this.value;
    }

    public Time getTime() throws DatatypeConversionException {
        if (!this.isTime()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to Time");
        }
        return (Time)this.value;
    }

    public Date getDate() throws DatatypeConversionException {
        if (!this.isDate()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to Date");
        }
        return (Date)this.value;
    }

    public DateTime getDateTime() throws DatatypeConversionException {
        if (!this.isDateTime()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to DateTime");
        }
        return (DateTime)this.value;
    }

    public Duration getDuration() throws DatatypeConversionException {
        if (!this.isDuration()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to Duration");
        }
        return (Duration)this.value;
    }

    public AnyURI getAnyURI() throws DatatypeConversionException {
        if (!this.isAnyURI()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to AnyURI");
        }
        return (AnyURI)this.value;
    }

    public HexBinary getHexBinary() throws DatatypeConversionException {
        if (!this.isHexBinary()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to HexBinary");
        }
        return (HexBinary)this.value;
    }

    public Base64Binary getBase64Binary() throws DatatypeConversionException {
        if (!this.isBase64Binary()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to Base64Binary");
        }
        return (Base64Binary)this.value;
    }

    public GDay getGDay() throws DatatypeConversionException {
        if (!this.isGDay()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to GDay");
        }
        return (GDay)this.value;
    }

    public GYearMonth getGYearMonth() throws DatatypeConversionException {
        if (!this.isGYearMonth()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to GYearMonth");
        }
        return (GYearMonth)this.value;
    }

    public GMonth getGMonth() throws DatatypeConversionException {
        if (!this.isGMonth()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to GMonth");
        }
        return (GMonth)this.value;
    }

    public GMonthDay getGMonthDay() throws DatatypeConversionException {
        if (!this.isGMonthDay()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to GMonthDay");
        }
        return (GMonthDay)this.value;
    }

    public GYear getGYear() throws DatatypeConversionException {
        if (!this.isGYear()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to GYear");
        }
        return (GYear)this.value;
    }

    public NOTATION getNOTATION() throws DatatypeConversionException {
        if (!this.isNOTATION()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to NOTATION");
        }
        return (NOTATION)this.value;
    }

    public QName getQName() throws DatatypeConversionException {
        if (!this.isQName()) {
            throw new DatatypeConversionException("cannot convert value of type '" + this.value.getClass().getName() + "' to QName");
        }
        return (QName)this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    public String getValueClassName() {
        return this.value.getClass().getName();
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object object) {
        this.value = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OWLDatatypeValueImpl oWLDatatypeValueImpl = (OWLDatatypeValueImpl)object;
        return this.value != null && oWLDatatypeValueImpl.value != null && this.value.toString().equals(oWLDatatypeValueImpl.value.toString());
    }

    public int hashCode() {
        int n = 66;
        return n += null == this.value ? 0 : this.value.toString().hashCode();
    }

    public int compareTo(Object object) {
        return ((Comparable)this.value).compareTo(((OWLDatatypeValueImpl)object).getValue());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.setValue(objectInput.readObject());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getValue());
    }
}

