/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.OWLFactoryException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.BuiltInArgumentImpl;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassImpl
extends BuiltInArgumentImpl
implements OWLClass {
    private String className;
    private Set<String> superclassNames;
    private Set<String> directSuperClassNames;
    private Set<String> directSubClassNames;
    private Set<String> equivalentClassNames;
    private Set<String> equivalentClassSuperclassNames;

    public OWLClassImpl(OWLModel oWLModel, String string) throws OWLFactoryException {
        this.className = string;
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLNamedClass(oWLModel, string);
        if (oWLNamedClass == null) {
            throw new InvalidClassNameException(string);
        }
        if (string.equals("owl:Thing")) {
            this.initialize(string);
        } else {
            this.superclassNames = SWRLOWLUtil.rdfResources2Names(oWLNamedClass.getNamedSuperclasses(true));
            this.directSuperClassNames = SWRLOWLUtil.rdfResources2Names(oWLNamedClass.getNamedSuperclasses());
            this.directSubClassNames = SWRLOWLUtil.rdfResources2Names(oWLNamedClass.getNamedSubclasses());
            this.equivalentClassNames = SWRLOWLUtil.rdfResources2OWLNamedClassNames(oWLNamedClass.getEquivalentClasses());
            this.equivalentClassSuperclassNames = new HashSet<String>();
            for (String string2 : this.equivalentClassNames) {
                OWLNamedClass oWLNamedClass2 = SWRLOWLUtil.getOWLNamedClass(oWLModel, string2);
                for (Object e : oWLNamedClass2.getNamedSuperclasses(true)) {
                    if (!(e instanceof OWLNamedClass)) continue;
                    OWLNamedClass oWLNamedClass3 = (OWLNamedClass)e;
                    this.equivalentClassSuperclassNames.add(oWLNamedClass3.getName());
                }
            }
        }
    }

    public OWLClassImpl(String string) {
        this.initialize(string);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public Set<String> getSuperclassNames() {
        return this.superclassNames;
    }

    @Override
    public Set<String> getDirectSuperClassNames() {
        return this.directSuperClassNames;
    }

    @Override
    public Set<String> getDirectSubClassNames() {
        return this.directSubClassNames;
    }

    @Override
    public Set<String> getEquivalentClassNames() {
        return this.equivalentClassNames;
    }

    @Override
    public Set<String> getEquivalentClassSuperclassNames() {
        return this.equivalentClassSuperclassNames;
    }

    @Override
    public boolean isNamedClass() {
        return true;
    }

    @Override
    public String getRepresentation() {
        return this.getClassName();
    }

    public String toString() {
        return this.getClassName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        OWLClassImpl oWLClassImpl = (OWLClassImpl)object;
        return (this.getClassName() == oWLClassImpl.getClassName() || this.getClassName() != null && this.getClassName().equals(oWLClassImpl.getClassName())) && this.superclassNames != null && oWLClassImpl.superclassNames != null && ((Object)this.superclassNames).equals(oWLClassImpl.superclassNames) && this.directSuperClassNames != null && oWLClassImpl.directSuperClassNames != null && ((Object)this.directSuperClassNames).equals(oWLClassImpl.directSuperClassNames) && this.directSubClassNames != null && oWLClassImpl.directSubClassNames != null && ((Object)this.directSubClassNames).equals(oWLClassImpl.directSubClassNames) && this.equivalentClassNames != null && oWLClassImpl.equivalentClassNames != null && ((Object)this.equivalentClassNames).equals(oWLClassImpl.equivalentClassNames) && this.equivalentClassSuperclassNames != null && oWLClassImpl.equivalentClassSuperclassNames != null && ((Object)this.equivalentClassSuperclassNames).equals(oWLClassImpl.equivalentClassSuperclassNames);
    }

    @Override
    public int hashCode() {
        int n = 12;
        n += null == this.getClassName() ? 0 : this.getClassName().hashCode();
        n += null == this.getSuperclassNames() ? 0 : ((Object)this.getSuperclassNames()).hashCode();
        n += null == this.getDirectSuperClassNames() ? 0 : ((Object)this.getDirectSuperClassNames()).hashCode();
        n += null == this.getDirectSubClassNames() ? 0 : ((Object)this.getDirectSubClassNames()).hashCode();
        n += null == this.getEquivalentClassNames() ? 0 : ((Object)this.getEquivalentClassNames()).hashCode();
        return n += null == this.getEquivalentClassSuperclassNames() ? 0 : ((Object)this.getEquivalentClassSuperclassNames()).hashCode();
    }

    public int compareTo(Object object) {
        return this.className.compareTo(((OWLClassImpl)object).getClassName());
    }

    private void initialize(String string) {
        this.className = string;
        this.superclassNames = new HashSet<String>();
        this.directSuperClassNames = new HashSet<String>();
        this.directSubClassNames = new HashSet<String>();
        this.equivalentClassNames = new HashSet<String>();
        this.equivalentClassSuperclassNames = new HashSet<String>();
    }
}

