/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.impl;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.Atom;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatatypeValueArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.bridge.Mapper;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypePropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDatatypeValue;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLDifferentIndividualsAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLObjectPropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLProperty;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLPropertyAssertionAxiom;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRule;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.VariableAtomArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.BuiltInLibraryManager;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InconsistentKnowledgeBaseException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidSWRLAtomException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.impl.OWLPropertyImpl;
import edu.stanford.smi.protegex.owl.swrl.exceptions.InvalidRuleNameException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.SQWRLResult;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.InvalidQueryNameException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.exceptions.SQWRLException;
import edu.stanford.smi.protegex.owl.swrl.sqwrl.impl.ResultImpl;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWRLRuleEngineBridge
implements SWRLRuleEngineBridge {
    protected OWLModel owlModel;
    private HashMap<String, SWRLRule> importedSWRLRules;
    private Set<String> referencedClassNames;
    private Set<String> referencedPropertyNames;
    private Set<String> referencedIndividualNames;
    private HashMap<String, OWLClass> importedClasses;
    private HashMap<String, OWLIndividual> importedIndividuals;
    private Set<String> importedPropertyNames;
    private Set<OWLPropertyAssertionAxiom> importedPropertyAssertionAxioms;
    private Set<OWLAxiom> importedAxioms;
    private Set<String> exportedClassNames;
    private Set<String> exportedIndividualNames;
    private Set<OWLIndividual> inferredIndividuals;
    private Set<OWLPropertyAssertionAxiom> inferredPropertyAssertionAxioms;
    private HashMap<String, OWLIndividual> createdIndividuals;
    private Set<OWLPropertyAssertionAxiom> createdPropertyAssertionAxioms;
    private Mapper mapper = null;
    private SWRLFactory factory;

    protected AbstractSWRLRuleEngineBridge(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        this.owlModel = oWLModel;
        this.initialize();
        BuiltInLibraryManager.invokeAllBuiltInLibrariesResetMethod(this);
        this.factory = new SWRLFactory(oWLModel);
    }

    @Override
    public void importSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.importSWRLRulesAndOWLKnowledge(new HashSet<String>());
    }

    @Override
    public void importSWRLRulesAndOWLKnowledge(String string) throws SWRLRuleEngineBridgeException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.importSWRLRulesAndOWLKnowledge(hashSet);
    }

    @Override
    public void importSWRLRulesAndOWLKnowledge(Set<String> set) throws SWRLRuleEngineBridgeException {
        if (SWRLOWLUtil.hasInconsistentClasses(this.owlModel)) {
            throw new InconsistentKnowledgeBaseException("cannot import rules from an inconsistent ontology");
        }
        this.importSWRLRules(set);
        this.importOWLClasses(this.referencedClassNames);
        this.importOWLPropertyAssertionAxioms(this.referencedPropertyNames);
        this.importOWLIndividuals(this.referencedIndividualNames);
        this.importAllOWLIndividualsOfClasses(this.referencedClassNames);
        this.importAxioms();
        this.exportSWRLRulesAndOWLKnowledge();
    }

    private void exportSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.exportClasses();
        this.exportSWRLRules();
        this.exportIndividuals();
        this.exportPropertyAssertionAxioms();
        this.exportAxioms();
    }

    private void exportOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.exportClasses();
        this.exportIndividuals();
        this.exportPropertyAssertionAxioms();
        this.exportAxioms();
    }

    @Override
    public void run() throws SWRLRuleEngineBridgeException {
        if (this.hasMapper()) {
            this.mapper.open();
        }
        this.runRuleEngine();
        if (this.hasMapper()) {
            this.mapper.close();
        }
    }

    @Override
    public void writeInferredKnowledge2OWL() throws SWRLRuleEngineBridgeException {
        this.writeCreatedIndividuals();
        this.writeInferredIndividuals2OWL();
        this.writeInferredPropertyAssertionAxioms2OWL();
    }

    @Override
    public void reset() throws SWRLRuleEngineBridgeException {
        this.resetRuleEngine();
        BuiltInLibraryManager.invokeAllBuiltInLibrariesResetMethod(this);
        this.initialize();
    }

    @Override
    public void infer(Set<String> set) throws SWRLRuleEngineBridgeException {
        this.reset();
        this.importSWRLRulesAndOWLKnowledge(set);
        this.run();
        this.writeInferredKnowledge2OWL();
    }

    @Override
    public void infer(String string) throws SWRLRuleEngineBridgeException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.infer(hashSet);
    }

    @Override
    public void infer() throws SWRLRuleEngineBridgeException {
        HashSet<String> hashSet = new HashSet<String>();
        this.infer(hashSet);
    }

    @Override
    public void runSQWRLQueries() throws SQWRLException {
        try {
            this.reset();
            this.importSWRLRulesAndOWLKnowledge();
            this.run();
        }
        catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
            throw new SQWRLException("error running SQWRL queries: " + sWRLRuleEngineBridgeException.getMessage());
        }
    }

    @Override
    public SQWRLResult getSQWRLResult(String string) throws SQWRLException {
        if (!this.importedSWRLRules.containsKey(string)) {
            throw new InvalidQueryNameException(string);
        }
        ResultImpl resultImpl = this.importedSWRLRules.get(string).getSQWRLResult();
        if (!resultImpl.isPrepared()) {
            resultImpl.prepared();
        }
        return resultImpl;
    }

    @Override
    public SWRLRule getRule(String string) throws InvalidRuleNameException {
        if (!this.importedSWRLRules.containsKey(string)) {
            throw new InvalidRuleNameException(string);
        }
        return this.importedSWRLRules.get(string);
    }

    @Override
    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    @Override
    public int getNumberOfImportedSWRLRules() {
        return this.importedSWRLRules.size();
    }

    @Override
    public int getNumberOfImportedClasses() {
        return this.importedClasses.size();
    }

    @Override
    public int getNumberOfImportedIndividuals() {
        return this.importedIndividuals.size();
    }

    @Override
    public int getNumberOfImportedPropertyAssertionAxioms() {
        return this.importedPropertyAssertionAxioms.size();
    }

    @Override
    public int getNumberOfImportedAxioms() {
        return this.importedAxioms.size();
    }

    @Override
    public int getNumberOfInferredIndividuals() {
        return this.inferredIndividuals.size();
    }

    @Override
    public int getNumberOfInferredPropertyAssertionAxioms() {
        return this.inferredPropertyAssertionAxioms.size();
    }

    @Override
    public int getNumberOfCreatedIndividuals() {
        return this.createdIndividuals.size();
    }

    @Override
    public int getNumberOfCreatedPropertyAssertionAxioms() {
        return this.createdPropertyAssertionAxioms.size();
    }

    public boolean isClass(String string) {
        return this.importedClasses.containsKey(string);
    }

    public boolean isProperty(String string) {
        return this.importedPropertyNames.contains(string);
    }

    public boolean isIndividual(String string) {
        return this.importedIndividuals.containsKey(string);
    }

    @Override
    public boolean isCreatedIndividual(String string) {
        return this.createdIndividuals.containsKey(string);
    }

    @Override
    public boolean isCreatedPropertyAssertionAxiom(OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom) {
        return this.createdPropertyAssertionAxioms.contains(oWLPropertyAssertionAxiom);
    }

    @Override
    public Set<SWRLRule> getImportedSWRLRules() {
        return new HashSet<SWRLRule>(this.importedSWRLRules.values());
    }

    @Override
    public Set<OWLClass> getImportedClasses() {
        return new HashSet<OWLClass>(this.importedClasses.values());
    }

    @Override
    public Set<OWLIndividual> getImportedIndividuals() {
        return new HashSet<OWLIndividual>(this.importedIndividuals.values());
    }

    @Override
    public Set<OWLPropertyAssertionAxiom> getImportedPropertyAssertionAxioms() {
        return this.importedPropertyAssertionAxioms;
    }

    @Override
    public Set<OWLAxiom> getImportedAxioms() {
        return this.importedAxioms;
    }

    @Override
    public Set<OWLIndividual> getInferredIndividuals() {
        return this.inferredIndividuals;
    }

    @Override
    public Set<OWLPropertyAssertionAxiom> getInferredPropertyAssertionAxioms() {
        return this.inferredPropertyAssertionAxioms;
    }

    @Override
    public Set<OWLIndividual> getCreatedIndividuals() {
        return new HashSet<OWLIndividual>(this.createdIndividuals.values());
    }

    @Override
    public Set<OWLPropertyAssertionAxiom> getCreatedPropertyAssertionAxioms() {
        return this.createdPropertyAssertionAxioms;
    }

    @Override
    public void inferPropertyAssertionAxiom(OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom) throws SWRLRuleEngineBridgeException {
        if (!this.inferredPropertyAssertionAxioms.contains(oWLPropertyAssertionAxiom)) {
            this.inferredPropertyAssertionAxioms.add(oWLPropertyAssertionAxiom);
        }
    }

    @Override
    public void inferIndividual(OWLIndividual oWLIndividual) throws SWRLRuleEngineBridgeException {
        if (!this.inferredIndividuals.contains(oWLIndividual)) {
            this.inferredIndividuals.add(oWLIndividual);
        }
    }

    @Override
    public boolean invokeSWRLBuiltIn(String string, String string2, int n, List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = SWRLBuiltInUtil.hasUnboundArguments(list);
        if (!SWRLOWLUtil.isSWRLBuiltIn(this.owlModel, string2)) {
            throw new InvalidBuiltInNameException(string, string2);
        }
        boolean bl2 = BuiltInLibraryManager.invokeSWRLBuiltIn(this, string, string2, n, list);
        if (bl2 && bl) {
            SWRLBuiltInUtil.checkForUnboundArguments(string, string2, list);
            SWRLBuiltInUtil.generateBuiltInBindings(this, string, string2, n, list);
        }
        return bl2;
    }

    @Override
    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public boolean hasMapper() {
        return this.mapper != null;
    }

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public OWLIndividual createOWLIndividual() throws SWRLRuleEngineBridgeException {
        String string = SWRLOWLUtil.createNewResourceName(this.owlModel, "SWRLCreated");
        OWLIndividual oWLIndividual = OWLFactory.generateOWLIndividual(string, "owl:Thing");
        this.createOWLIndividual(oWLIndividual);
        return oWLIndividual;
    }

    @Override
    public void createOWLIndividual(OWLIndividual oWLIndividual) throws SWRLRuleEngineBridgeException {
        this.createdIndividuals.put(oWLIndividual.getIndividualName(), oWLIndividual);
        this.defineIndividual(oWLIndividual);
    }

    @Override
    public OWLIndividual createOWLIndividual(OWLClass oWLClass) throws SWRLRuleEngineBridgeException {
        String string = SWRLOWLUtil.createNewResourceName(this.owlModel, "SWRLCreated");
        OWLIndividual oWLIndividual = OWLFactory.generateOWLIndividual(string, oWLClass.getClassName());
        if (!this.importedClasses.containsKey(oWLClass.getClassName())) {
            this.defineClass(oWLClass);
        }
        this.createdIndividuals.put(string, oWLIndividual);
        this.defineIndividual(oWLIndividual);
        return oWLIndividual;
    }

    @Override
    public void createOWLIndividuals(Set<OWLIndividual> set) throws SWRLRuleEngineBridgeException {
        for (OWLIndividual oWLIndividual : set) {
            this.createOWLIndividual(oWLIndividual);
        }
    }

    @Override
    public OWLDatatypePropertyAssertionAxiom createOWLDatatypePropertyAssertionAxiom(OWLIndividual oWLIndividual, OWLProperty oWLProperty, OWLDatatypeValue oWLDatatypeValue) throws SWRLRuleEngineBridgeException {
        OWLDatatypePropertyAssertionAxiom oWLDatatypePropertyAssertionAxiom = OWLFactory.createOWLDatatypePropertyAssertionAxiom(oWLIndividual, oWLProperty, oWLDatatypeValue);
        this.createOWLDatatypePropertyAssertionAxiom(oWLDatatypePropertyAssertionAxiom);
        return oWLDatatypePropertyAssertionAxiom;
    }

    @Override
    public OWLDatatypePropertyAssertionAxiom createOWLDatatypePropertyAssertionAxiom(OWLDatatypePropertyAssertionAxiom oWLDatatypePropertyAssertionAxiom) throws SWRLRuleEngineBridgeException {
        if (!this.createdPropertyAssertionAxioms.contains(oWLDatatypePropertyAssertionAxiom)) {
            this.createdPropertyAssertionAxioms.add(oWLDatatypePropertyAssertionAxiom);
        }
        this.defineAxiom(oWLDatatypePropertyAssertionAxiom);
        return oWLDatatypePropertyAssertionAxiom;
    }

    @Override
    public void createOWLDatatypePropertyAssertionAxioms(Set<OWLDatatypePropertyAssertionAxiom> set) throws SWRLRuleEngineBridgeException {
        for (OWLDatatypePropertyAssertionAxiom oWLDatatypePropertyAssertionAxiom : set) {
            this.createOWLDatatypePropertyAssertionAxiom(oWLDatatypePropertyAssertionAxiom);
        }
    }

    @Override
    public OWLObjectPropertyAssertionAxiom createOWLObjectPropertyAssertionAxiom(OWLIndividual oWLIndividual, OWLProperty oWLProperty, OWLIndividual oWLIndividual2) throws SWRLRuleEngineBridgeException {
        OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom = OWLFactory.createOWLObjectPropertyAssertionAxiom(oWLIndividual, oWLProperty, oWLIndividual2);
        this.createOWLObjectPropertyAssertionAxiom(oWLObjectPropertyAssertionAxiom);
        return oWLObjectPropertyAssertionAxiom;
    }

    @Override
    public OWLObjectPropertyAssertionAxiom createOWLObjectPropertyAssertionAxiom(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) throws SWRLRuleEngineBridgeException {
        if (!this.createdPropertyAssertionAxioms.contains(oWLObjectPropertyAssertionAxiom)) {
            this.createdPropertyAssertionAxioms.add(oWLObjectPropertyAssertionAxiom);
        }
        this.defineAxiom(oWLObjectPropertyAssertionAxiom);
        return oWLObjectPropertyAssertionAxiom;
    }

    @Override
    public void createOWLObjectPropertyAssertionAxioms(Set<OWLObjectPropertyAssertionAxiom> set) throws SWRLRuleEngineBridgeException {
        for (OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom : set) {
            this.createOWLObjectPropertyAssertionAxiom(oWLObjectPropertyAssertionAxiom);
        }
    }

    private void writeCreatedIndividuals() throws SWRLRuleEngineBridgeException {
        for (OWLIndividual oWLIndividual : this.createdIndividuals.values()) {
            String string = oWLIndividual.getIndividualName();
            if (SWRLOWLUtil.isOWLIndividual(this.owlModel, string)) continue;
            try {
                edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual2 = SWRLOWLUtil.createIndividualOfClass(this.owlModel, SWRLOWLUtil.getOWLThingClass(this.owlModel), string);
            }
            catch (SWRLOWLUtilException sWRLOWLUtilException) {
                throw new SWRLRuleEngineBridgeException("cannot create OWL individual '" + string + "': " + sWRLOWLUtilException.getMessage());
            }
        }
    }

    private void importSWRLRules(Set<String> set) throws SWRLRuleEngineBridgeException {
        Collection collection = this.factory.getEnabledImps(set);
        if (collection == null) {
            return;
        }
        for (SWRLImp sWRLImp : collection) {
            if (sWRLImp == null) {
                throw new SWRLRuleEngineBridgeException("empty rule");
            }
            this.importSWRLRule(sWRLImp);
        }
    }

    private void importSWRLRule(SWRLImp sWRLImp) throws SWRLRuleEngineBridgeException {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        ArrayList<Atom> arrayList2 = new ArrayList<Atom>();
        for (SWRLAtom sWRLAtom : sWRLImp.getBody().getValues()) {
            arrayList.add(this.processSWRLAtom(sWRLAtom, false));
        }
        for (SWRLAtom sWRLAtom : sWRLImp.getHead().getValues()) {
            arrayList2.add(this.processSWRLAtom(sWRLAtom, true));
        }
        SWRLRule sWRLRule = OWLFactory.createSWRLRule(sWRLImp.getName(), arrayList, arrayList2);
        this.importedSWRLRules.put(sWRLRule.getRuleName(), sWRLRule);
    }

    private Atom processSWRLAtom(SWRLAtom sWRLAtom, boolean bl) throws SWRLRuleEngineBridgeException {
        Atom atom;
        if (sWRLAtom instanceof SWRLClassAtom) {
            atom = OWLFactory.createClassAtom((SWRLClassAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLDatavaluedPropertyAtom) {
            atom = OWLFactory.createDatavaluedPropertyAtom(this.owlModel, (SWRLDatavaluedPropertyAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLIndividualPropertyAtom) {
            atom = OWLFactory.createIndividualPropertyAtom((SWRLIndividualPropertyAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLSameIndividualAtom) {
            atom = OWLFactory.createSameIndividualAtom((SWRLSameIndividualAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLDifferentIndividualsAtom) {
            atom = OWLFactory.createDifferentIndividualsAtom((SWRLDifferentIndividualsAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLBuiltinAtom) {
            atom = OWLFactory.createBuiltInAtom(this.owlModel, (SWRLBuiltinAtom)sWRLAtom);
        } else if (sWRLAtom instanceof SWRLDataRangeAtom) {
            atom = OWLFactory.createDataRangeAtom((SWRLDataRangeAtom)sWRLAtom);
        } else {
            throw new InvalidSWRLAtomException(sWRLAtom.getBrowserText());
        }
        if (atom.hasReferencedClasses()) {
            this.referencedClassNames.addAll(atom.getReferencedClassNames());
        }
        if (atom.hasReferencedProperties()) {
            this.referencedPropertyNames.addAll(atom.getReferencedPropertyNames());
        }
        if (atom.hasReferencedIndividuals()) {
            this.referencedIndividualNames.addAll(atom.getReferencedIndividualNames());
        }
        return atom;
    }

    private void importOWLClass(String string) throws SWRLRuleEngineBridgeException {
        RDFSNamedClass rDFSNamedClass = SWRLOWLUtil.getRDFSNamedClass(this.owlModel, string);
        if (rDFSNamedClass == null) {
            throw new InvalidClassNameException(string);
        }
        if (rDFSNamedClass.isMetaclass()) {
            return;
        }
        if (rDFSNamedClass.isAnonymous()) {
            return;
        }
        if (!this.importedClasses.containsKey(string)) {
            OWLClass oWLClass = OWLFactory.createOWLClass(this.owlModel, string);
            this.importedClasses.put(string, oWLClass);
            this.importOWLClasses(oWLClass.getDirectSuperClassNames());
            this.importOWLClasses(oWLClass.getDirectSubClassNames());
        }
    }

    private void importOWLClasses(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLClass(string);
        }
    }

    private void importAllOWLIndividualsOfClasses(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importAllOWLIndividualsOfClass(string);
        }
    }

    private void importAllOWLIndividualsOfClass(String string) throws SWRLRuleEngineBridgeException {
        RDFSNamedClass rDFSNamedClass = SWRLOWLUtil.getRDFSNamedClass(this.owlModel, string);
        if (rDFSNamedClass == null) {
            throw new InvalidClassNameException(string);
        }
        Collection collection = rDFSNamedClass.getInstances(true);
        collection.addAll(rDFSNamedClass.getInferredInstances(true));
        for (Object e : collection) {
            RDFResource rDFResource;
            if (e instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual) {
                rDFResource = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e;
                this.importOWLIndividual(rDFResource.getName());
                continue;
            }
            if (!(e instanceof OWLNamedClass)) continue;
            rDFResource = (OWLNamedClass)e;
            this.importOWLClass(rDFResource.getName());
        }
    }

    private void importOWLPropertyAssertionAxioms(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLPropertyAssertionAxioms(string);
        }
    }

    private void importOWLPropertyAssertionAxioms(String string) throws SWRLRuleEngineBridgeException {
        edu.stanford.smi.protegex.owl.model.OWLProperty oWLProperty = SWRLOWLUtil.getOWLProperty(this.owlModel, string);
        if (oWLProperty == null) {
            throw new InvalidPropertyNameException(string);
        }
        if (!this.importedPropertyNames.contains(string)) {
            Set<OWLPropertyAssertionAxiom> set = OWLPropertyImpl.buildOWLPropertyAssertionAxioms(this.owlModel, string);
            this.importedPropertyAssertionAxioms.addAll(set);
            this.importedPropertyNames.add(string);
            this.importOWLClasses(SWRLOWLUtil.rdfResources2Names(oWLProperty.getUnionDomain()));
            this.importOWLClasses(SWRLOWLUtil.rdfResources2Names(oWLProperty.getUnionRangeClasses()));
            this.importOWLPropertyAssertionAxioms(SWRLOWLUtil.rdfResources2Names(oWLProperty.getSuperproperties(true)));
            this.importOWLPropertyAssertionAxioms(SWRLOWLUtil.rdfResources2Names(oWLProperty.getSubproperties(true)));
            this.importOWLPropertyAssertionAxioms(SWRLOWLUtil.rdfResources2Names(oWLProperty.getEquivalentProperties()));
        }
    }

    private void importOWLIndividuals(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (String string : set) {
            this.importOWLIndividual(string);
        }
    }

    private void importOWLIndividual(String string) throws SWRLRuleEngineBridgeException {
        if (!this.importedIndividuals.containsKey(string)) {
            OWLIndividual oWLIndividual = OWLFactory.createOWLIndividual(this.owlModel, string);
            this.importedIndividuals.put(string, oWLIndividual);
            this.importOWLClasses(oWLIndividual.getDefiningClassNames());
            this.importOWLClasses(oWLIndividual.getDefiningSuperclassNames());
            this.importOWLClasses(oWLIndividual.getDefiningEquivalentClassNames());
            this.importOWLClasses(oWLIndividual.getDefiningEquivalentClassSuperclassNames());
        }
    }

    private void importAxioms() throws SWRLRuleEngineBridgeException {
        this.importClassDescriptions();
        this.importClassAxioms();
        this.importPropertyAxioms();
        this.importIndividualAxioms();
        this.importDatatypeAxioms();
        this.importAnnotations();
    }

    private void importClassDescriptions() throws SWRLRuleEngineBridgeException {
        this.importClassEnumerationDescriptions();
        this.importPropertyRestrictions();
        this.importIntersectionOfDescriptions();
        this.importUnionOfDescriptions();
        this.importComplementOfDescriptions();
    }

    private void importClassAxioms() throws SWRLRuleEngineBridgeException {
        this.importEquivalentClassAxioms();
        this.importDisjointWithAxioms();
    }

    private void importClassEnumerationDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importPropertyRestrictions() throws SWRLRuleEngineBridgeException {
        this.importCardinalityRestrictions();
        this.importMinCardinalityRestrictions();
        this.importMaxCardinalityRestrictions();
        this.importAllValuesFromRestrictions();
        this.importSomeValuesFromRestrictions();
        this.importHasValueRestrictions();
    }

    private void importPropertyAxioms() throws SWRLRuleEngineBridgeException {
        this.importEquivalentPropertyAxioms();
        this.importInverseOfAxioms();
        this.importFunctionalPropertyAxioms();
        this.importInverseFunctionalPropertyAxioms();
        this.importTransitivePropertyAxioms();
        this.importSymmetricPropertyAxioms();
    }

    private void importIndividualAxioms() throws SWRLRuleEngineBridgeException {
        this.importSameAsAxioms();
        this.importDifferentFromAxioms();
        this.importAllDifferentsAxioms();
    }

    private void importDatatypeAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importAnnotations() throws SWRLRuleEngineBridgeException {
    }

    private void importCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importMinCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importMaxCardinalityRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importAllValuesFromRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importSomeValuesFromRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importHasValueRestrictions() throws SWRLRuleEngineBridgeException {
    }

    private void importIntersectionOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importUnionOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importComplementOfDescriptions() throws SWRLRuleEngineBridgeException {
    }

    private void importEquivalentPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importInverseOfAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importFunctionalPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importInverseFunctionalPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importTransitivePropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importSymmetricPropertyAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importEquivalentClassAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importDisjointWithAxioms() throws SWRLRuleEngineBridgeException {
    }

    private void importSameAsAxioms() throws SWRLRuleEngineBridgeException {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLSameAsProperty(this.owlModel);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLThingClass(this.owlModel);
        for (Object e : oWLNamedClass.getInstances(true)) {
            edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual;
            if (!(e instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual) || !(oWLIndividual = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e).hasPropertyValue(rDFProperty)) continue;
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e2 : collection) {
                if (!(e2 instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual)) continue;
                edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual2 = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e2;
                this.importedAxioms.add(OWLFactory.createOWLSameIndividualsAxiom(OWLFactory.createOWLIndividual(oWLIndividual), OWLFactory.createOWLIndividual(oWLIndividual2)));
            }
        }
    }

    private void importDifferentFromAxioms() throws SWRLRuleEngineBridgeException {
        RDFProperty rDFProperty = SWRLOWLUtil.getOWLDifferentFromProperty(this.owlModel);
        OWLNamedClass oWLNamedClass = SWRLOWLUtil.getOWLThingClass(this.owlModel);
        for (Object e : oWLNamedClass.getInstances(true)) {
            edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual;
            if (!(e instanceof OWLIndividual) || !(oWLIndividual = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e).hasPropertyValue(rDFProperty)) continue;
            Collection collection = oWLIndividual.getPropertyValues(rDFProperty);
            for (Object e2 : collection) {
                if (!(e2 instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual)) continue;
                edu.stanford.smi.protegex.owl.model.OWLIndividual oWLIndividual2 = (edu.stanford.smi.protegex.owl.model.OWLIndividual)e2;
                this.importedAxioms.add(OWLFactory.createOWLDifferentIndividualsAxiom(OWLFactory.createOWLIndividual(oWLIndividual), OWLFactory.createOWLIndividual(oWLIndividual2)));
            }
        }
    }

    private void importAllDifferentsAxioms() throws SWRLRuleEngineBridgeException {
        Collection collection = SWRLOWLUtil.getOWLAllDifferents(this.owlModel);
        if (!collection.isEmpty()) {
            for (OWLAllDifferent oWLAllDifferent : collection) {
                if (oWLAllDifferent.getDistinctMembers().size() == 0) continue;
                HashSet<OWLIndividual> hashSet = new HashSet<OWLIndividual>();
                for (RDFIndividual rDFIndividual : oWLAllDifferent.getDistinctMembers()) {
                    if (!(rDFIndividual instanceof edu.stanford.smi.protegex.owl.model.OWLIndividual)) continue;
                    hashSet.add(OWLFactory.createOWLIndividual((edu.stanford.smi.protegex.owl.model.OWLIndividual)rDFIndividual));
                }
                OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom = OWLFactory.createOWLDifferentIndividualsAxiom(hashSet);
                this.importedAxioms.add(oWLDifferentIndividualsAxiom);
            }
        }
    }

    private void exportSWRLRules() throws SWRLRuleEngineBridgeException {
        for (SWRLRule sWRLRule : this.importedSWRLRules.values()) {
            this.exportSWRLRule(sWRLRule);
        }
    }

    private void exportSWRLRules(Set<String> set) throws SWRLRuleEngineBridgeException {
        for (SWRLRule sWRLRule : this.importedSWRLRules.values()) {
            if (!set.contains(sWRLRule.getRuleName())) continue;
            this.exportSWRLRule(sWRLRule);
        }
    }

    private void exportSWRLRule(String string) throws SWRLRuleEngineBridgeException {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        this.exportSWRLRules(hashSet);
    }

    private void exportSWRLRule(SWRLRule sWRLRule) throws SWRLRuleEngineBridgeException {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        if (this.hasMapper()) {
            for (Atom atom : sWRLRule.getBodyAtoms()) {
                AtomArgument atomArgument;
                Atom atom2;
                if (atom instanceof ClassAtom) {
                    atom2 = (ClassAtom)atom;
                    atomArgument = OWLFactory.getOWLClass(atom2.getClassName());
                    if (!this.mapper.isMapped((OWLClass)atomArgument)) continue;
                }
                if (atom instanceof DatavaluedPropertyAtom) {
                    atom2 = (DatavaluedPropertyAtom)atom;
                    atomArgument = OWLFactory.getOWLDatatypeProperty(atom2.getPropertyName());
                    if (!this.mapper.isMapped((OWLProperty)atomArgument)) continue;
                    ArrayList<BuiltInArgument> arrayList2 = new ArrayList<BuiltInArgument>();
                    BuiltInArgument builtInArgument = this.convertAtomArgument2BuiltInArgument(atom2.getArgument1());
                    BuiltInArgument builtInArgument2 = this.convertAtomArgument2BuiltInArgument(atom2.getArgument2());
                    arrayList2.add((BuiltInArgument)((Object)atomArgument));
                    arrayList2.add(builtInArgument2);
                    arrayList2.add(builtInArgument);
                    BuiltInAtom builtInAtom = OWLFactory.createBuiltInAtom("ddm:mapOWLDatatypeProperty", arrayList2);
                    arrayList.add(builtInAtom);
                    continue;
                }
                if (atom instanceof IndividualPropertyAtom && !this.mapper.isMapped((OWLProperty)(atomArgument = OWLFactory.getOWLObjectProperty((atom2 = (IndividualPropertyAtom)atom).getPropertyName())))) continue;
            }
        }
        sWRLRule.appendAtomsToBody(arrayList);
        this.defineRule(sWRLRule);
    }

    private BuiltInArgument convertAtomArgument2BuiltInArgument(AtomArgument atomArgument) throws SWRLRuleEngineBridgeException {
        BuiltInArgument builtInArgument = null;
        if (atomArgument instanceof VariableAtomArgument) {
            builtInArgument = OWLFactory.createVariableBuiltInArgument(((VariableAtomArgument)atomArgument).getVariableName());
        } else if (atomArgument instanceof IndividualArgument) {
            builtInArgument = OWLFactory.getOWLIndividual(((IndividualArgument)atomArgument).getIndividualName());
        } else if (atomArgument instanceof DatatypeValueArgument) {
            builtInArgument = (OWLDatatypeValue)atomArgument;
        } else {
            throw new SWRLRuleEngineBridgeException("cannon convert atom argument '" + atomArgument.getClass() + "' to built-in argument");
        }
        return builtInArgument;
    }

    private void exportClasses() throws SWRLRuleEngineBridgeException {
        for (OWLClass oWLClass : this.importedClasses.values()) {
            this.exportClass(oWLClass);
        }
    }

    private void exportClass(OWLClass oWLClass) throws SWRLRuleEngineBridgeException {
        String string = oWLClass.getClassName();
        Set<String> set = oWLClass.getDirectSuperClassNames();
        if (!this.exportedClassNames.contains(string)) {
            this.defineClass(oWLClass);
            this.exportedClassNames.add(string);
            if (!set.isEmpty()) {
                for (String string2 : set) {
                    OWLClass oWLClass2 = this.importedClasses.get(string2);
                    this.exportClass(oWLClass2);
                }
            }
        }
    }

    private void exportPropertyAssertionAxioms() throws SWRLRuleEngineBridgeException {
        for (OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom : this.importedPropertyAssertionAxioms) {
            this.defineAxiom(oWLPropertyAssertionAxiom);
        }
    }

    private void exportIndividuals() throws SWRLRuleEngineBridgeException {
        for (OWLIndividual oWLIndividual : this.importedIndividuals.values()) {
            String string = oWLIndividual.getIndividualName();
            if (this.exportedIndividualNames.contains(string)) continue;
            this.defineIndividual(oWLIndividual);
            this.exportedIndividualNames.add(string);
        }
    }

    private void exportAxioms() throws SWRLRuleEngineBridgeException {
        for (OWLAxiom oWLAxiom : this.importedAxioms) {
            this.defineAxiom(oWLAxiom);
        }
    }

    private void writeInferredPropertyAssertionAxioms2OWL() throws SWRLRuleEngineBridgeException {
        for (OWLPropertyAssertionAxiom oWLPropertyAssertionAxiom : this.inferredPropertyAssertionAxioms) {
            oWLPropertyAssertionAxiom.write2OWL(this.owlModel);
        }
    }

    private void writeInferredIndividuals2OWL() throws SWRLRuleEngineBridgeException {
        for (OWLIndividual oWLIndividual : this.inferredIndividuals) {
            oWLIndividual.write2OWL(this.owlModel);
        }
    }

    private void initialize() {
        this.importedSWRLRules = new HashMap();
        this.referencedClassNames = new HashSet<String>();
        this.referencedIndividualNames = new HashSet<String>();
        this.referencedPropertyNames = new HashSet<String>();
        this.importedClasses = new HashMap();
        this.importedIndividuals = new HashMap();
        this.importedPropertyAssertionAxioms = new HashSet<OWLPropertyAssertionAxiom>();
        this.importedPropertyNames = new HashSet<String>();
        this.importedAxioms = new HashSet<OWLAxiom>();
        this.exportedClassNames = new HashSet<String>();
        this.exportedIndividualNames = new HashSet<String>();
        this.inferredIndividuals = new HashSet<OWLIndividual>();
        this.inferredPropertyAssertionAxioms = new HashSet<OWLPropertyAssertionAxiom>();
        this.createdIndividuals = new HashMap();
        this.createdPropertyAssertionAxioms = new HashSet<OWLPropertyAssertionAxiom>();
    }
}

