/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml;

import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlxml.XMLProcessorException;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLProcessor {
    private XMLOutputter serializer = new XMLOutputter(Format.getPrettyFormat());

    public void generateXMLFile(Document document, String string) throws XMLProcessorException {
        OutputStream outputStream = this.createOutputXMLStream(string);
        if (document == null || !document.hasRootElement()) {
            throw new XMLProcessorException("document is empty");
        }
        try {
            this.serializer.output(document, outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error writing XML file '" + string + "': " + iOException.getMessage());
        }
    }

    public String generateXMLString(Document document) throws XMLProcessorException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (document == null || !document.hasRootElement()) {
            throw new XMLProcessorException("document is empty");
        }
        try {
            this.serializer.output(document, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error writing XML string: " + iOException.getMessage());
        }
        return byteArrayOutputStream.toString();
    }

    public Document processXMLStream(String string) throws XMLProcessorException {
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            InputStream inputStream = this.createInputXMLStream(string);
            document = sAXBuilder.build(inputStream);
            inputStream.close();
        }
        catch (Exception exception) {
            throw new XMLProcessorException("error opening XML file '" + string + "': " + exception.getMessage());
        }
        return document;
    }

    public Document processXMLString(String string) throws XMLProcessorException {
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            document = sAXBuilder.build((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new XMLProcessorException("error processing XML string: " + exception.getMessage());
        }
        return document;
    }

    private OutputStream createOutputXMLStream(String string) throws XMLProcessorException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("error creating XML serializer for XML stream '" + string + "': " + iOException.getMessage());
        }
        return fileOutputStream;
    }

    private InputStream createInputXMLStream(String string) throws XMLProcessorException {
        InputStream inputStream = null;
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getProtocol();
            if (string2.equals("file")) {
                String string3 = uRL.getPath();
                inputStream = new FileInputStream(string3);
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new XMLProcessorException("invalid URL for XML stream '" + string + "': " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            throw new XMLProcessorException("IO error opening XML stream '" + string + "': " + iOException.getMessage());
        }
        return inputStream;
    }
}

