/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlx;

import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.OWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLXLibraryName = "SWRLExtensionsBuiltIns";
    private ArgumentFactory argumentFactory = ArgumentFactory.getFactory();
    private HashMap<String, OWLIndividual> createInvocationMap;

    public SWRLBuiltInLibraryImpl() {
        super(SWRLXLibraryName);
    }

    @Override
    public void reset() {
        this.createInvocationMap = new HashMap();
    }

    public boolean makeOWLThing(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(2, list.size());
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            OWLIndividual oWLIndividual = null;
            String string = SWRLBuiltInUtil.createInvocationPattern(this.getInvokingBridge(), this.getInvokingRuleName(), this.getInvokingBuiltInIndex(), list.subList(1, list.size()));
            if (this.createInvocationMap.containsKey(string)) {
                oWLIndividual = this.createInvocationMap.get(string);
            } else {
                try {
                    oWLIndividual = this.getInvokingBridge().createOWLIndividual();
                }
                catch (SWRLRuleEngineBridgeException sWRLRuleEngineBridgeException) {
                    throw new BuiltInException("error calling bridge to create OWL individual: " + sWRLRuleEngineBridgeException.getMessage());
                }
                this.createInvocationMap.put(string, oWLIndividual);
            }
            list.set(0, oWLIndividual);
        }
        return true;
    }

    public boolean createOWLThing(List<BuiltInArgument> list) throws BuiltInException {
        return this.makeOWLThing(list);
    }
}

