/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.swrlb;

import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInNotImplementedException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInArgumentException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLBLibraryName = "SWRLCoreBuiltIns";
    private static String SWRLBPrefix = "swrlb:";
    private static String SWRLB_GREATER_THAN = SWRLBPrefix + "greaterThan";
    private static String SWRLB_LESS_THAN = SWRLBPrefix + "lessThan";
    private static String SWRLB_EQUAL = SWRLBPrefix + "equal";
    private static String SWRLB_NOT_EQUAL = SWRLBPrefix + "notEqual";
    private static String SWRLB_LESS_THAN_OR_EQUAL = SWRLBPrefix + "lessThanOrEqual";
    private static String SWRLB_GREATER_THAN_OR_EQUAL = SWRLBPrefix + "greaterThanOrEqual";
    private static String SWRLB_ADD = SWRLBPrefix + "add";
    private static String SWRLB_SUBTRACT = SWRLBPrefix + "subtract";
    private static String SWRLB_MULTIPLY = SWRLBPrefix + "multiply";
    private static String SWRLB_DIVIDE = SWRLBPrefix + "divide";
    private static String SWRLB_INTEGER_DIVIDE = SWRLBPrefix + "integerDivide";
    private static String SWRLB_MOD = SWRLBPrefix + "mod";
    private static String SWRLB_POW = SWRLBPrefix + "pow";
    private static String SWRLB_UNARY_PLUS = SWRLBPrefix + "unaryPlus";
    private static String SWRLB_UNARY_MINUS = SWRLBPrefix + "unaryMinus";
    private static String SWRLB_ABS = SWRLBPrefix + "abs";
    private static String SWRLB_CEILING = SWRLBPrefix + "ceiling";
    private static String SWRLB_FLOOR = SWRLBPrefix + "floor";
    private static String SWRLB_ROUND = SWRLBPrefix + "round";
    private static String SWRLB_ROUND_HALF_TO_EVEN = SWRLBPrefix + "roundHalfToEven";
    private static String SWRLB_SIN = SWRLBPrefix + "sin";
    private static String SWRLB_COS = SWRLBPrefix + "cos";
    private static String SWRLB_TAN = SWRLBPrefix + "tan";
    private static String SWRLB_BOOLEAN_NOT = SWRLBPrefix + "booleanNot";
    private static String SWRLB_STRING_EQUAL_IGNORECASE = SWRLBPrefix + "stringEqualIgnoreCase";
    private static String SWRLB_STRING_CONCAT = SWRLBPrefix + "stringConcat";
    private static String SWRLB_SUBSTRING = SWRLBPrefix + "substring";
    private static String SWRLB_STRING_LENGTH = SWRLBPrefix + "stringLength";
    private static String SWRLB_NORMALIZE_SPACE = SWRLBPrefix + "normalizeSpace";
    private static String SWRLB_UPPER_CASE = SWRLBPrefix + "upperCase";
    private static String SWRLB_LOWER_CASE = SWRLBPrefix + "lowerCase";
    private static String SWRLB_TRANSLATE = SWRLBPrefix + "translate";
    private static String SWRLB_CONTAINS = SWRLBPrefix + "contains";
    private static String SWRLB_CONTAINS_IGNORE_CASE = SWRLBPrefix + "containsIgnoreCase";
    private static String SWRLB_STARTS_WITH = SWRLBPrefix + "startsWith";
    private static String SWRLB_ENDS_WITH = SWRLBPrefix + "endsWith";
    private static String SWRLB_SUBSTRING_BEFORE = SWRLBPrefix + "substringBefore";
    private static String SWRLB_SUBSTRING_AFTER = SWRLBPrefix + "substringAfter";
    private static String SWRLB_MATCHES = SWRLBPrefix + "matches";
    private static String SWRLB_REPLACE = SWRLBPrefix + "replace";
    private static String SWRLB_TOKENIZE = SWRLBPrefix + "tokenize";
    private ArgumentFactory argumentFactory = ArgumentFactory.getFactory();

    public SWRLBuiltInLibraryImpl() {
        super(SWRLBLibraryName);
    }

    @Override
    public void reset() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean greaterThan(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        if (SWRLBuiltInUtil.isArgumentAString(0, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            if (!SWRLBuiltInUtil.isArgumentAString(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting string argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(1, list) + "'");
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
            if (string.compareTo(string2) <= 0) return false;
            return true;
        }
        if (!SWRLBuiltInUtil.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(0, list) + "'");
        if (!SWRLBuiltInUtil.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(1, list) + "'");
        if (this.compareTwoNumericArguments(list) <= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean lessThan(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        if (SWRLBuiltInUtil.isArgumentAString(0, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            if (!SWRLBuiltInUtil.isArgumentAString(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting string argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(1, list) + "'");
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
            if (string.compareTo(string2) >= 0) return false;
            return true;
        }
        if (!SWRLBuiltInUtil.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string or numeric argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(0, list) + "'");
        if (!SWRLBuiltInUtil.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(1, list) + "'");
        if (this.compareTwoNumericArguments(list) >= 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equal(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            throw new InvalidBuiltInArgumentException(0, "comparison built-ins do not support argument binding");
        }
        if (SWRLBuiltInUtil.isArgumentABoolean(0, list)) {
            boolean bl2 = SWRLBuiltInUtil.getArgumentAsABoolean(0, list);
            if (!SWRLBuiltInUtil.isArgumentABoolean(1, list)) return false;
            boolean bl3 = SWRLBuiltInUtil.getArgumentAsABoolean(1, list);
            if (bl2 != bl3) return false;
            return true;
        }
        if (SWRLBuiltInUtil.isArgumentAString(0, list)) {
            String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            if (!SWRLBuiltInUtil.isArgumentAString(1, list)) return false;
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
            if (string.compareTo(string2) != 0) return false;
            return true;
        }
        if (!SWRLBuiltInUtil.isArgumentNumeric(0, list)) throw new InvalidBuiltInArgumentException(0, "expecting string, numeric or boolean argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(0, list) + "'");
        if (!SWRLBuiltInUtil.isArgumentNumeric(1, list)) throw new InvalidBuiltInArgumentException(1, "expecting numeric argument for comparison, got '" + SWRLBuiltInUtil.getArgumentAsAString(1, list) + "'");
        if (this.compareTwoNumericArguments(list) != 0) return false;
        return true;
    }

    public boolean notEqual(List<BuiltInArgument> list) throws BuiltInException {
        return !this.equal(list);
    }

    public boolean lessThanOrEqual(List<BuiltInArgument> list) throws BuiltInException {
        return this.equal(list) || this.lessThan(list);
    }

    public boolean greaterThanOrEqual(List<BuiltInArgument> list) throws BuiltInException {
        return this.equal(list) || this.greaterThan(list);
    }

    public boolean add(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(2, list.size());
        return this.mathOperation(SWRLB_ADD, list);
    }

    public boolean subtract(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_SUBTRACT, list);
    }

    public boolean multiply(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(2, list.size());
        return this.mathOperation(SWRLB_MULTIPLY, list);
    }

    public boolean divide(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_DIVIDE, list);
    }

    public boolean integerDivide(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_INTEGER_DIVIDE, list);
    }

    public boolean mod(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_MOD, list);
    }

    public boolean pow(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        return this.mathOperation(SWRLB_POW, list);
    }

    public boolean unaryPlus(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_UNARY_PLUS, list);
    }

    public boolean unaryMinus(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_UNARY_MINUS, list);
    }

    public boolean abs(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ABS, list);
    }

    public boolean ceiling(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_CEILING, list);
    }

    public boolean floor(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_FLOOR, list);
    }

    public boolean round(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ROUND, list);
    }

    public boolean roundHalfToEven(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_ROUND_HALF_TO_EVEN, list);
    }

    public boolean sin(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_SIN, list);
    }

    public boolean cos(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_COS, list);
    }

    public boolean tan(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        return this.mathOperation(SWRLB_TAN, list);
    }

    public boolean booleanNot(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(list.subList(1, list.size()))) {
                throw new InvalidBuiltInArgumentException(1, "expecting a Boolean");
            }
            boolean bl2 = !SWRLBuiltInUtil.getArgumentAsABoolean(1, list);
            list.set(0, this.argumentFactory.createDatatypeValueArgument(bl2));
            bl = true;
        } else {
            if (!SWRLBuiltInUtil.areAllArgumentsBooleans(list)) {
                throw new InvalidBuiltInArgumentException("expecting all Boolean arguments");
            }
            bl = !this.equal(list);
        }
        return bl;
    }

    public boolean stringEqualIgnoreCase(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        return string.equalsIgnoreCase(string2);
    }

    public boolean stringConcat(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        String string = "";
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        for (int i = 1; i < list.size(); ++i) {
            string = string.concat(SWRLBuiltInUtil.getArgumentAsALiteral(i, list).toString());
        }
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string));
            bl = true;
        } else {
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string2.equals(string);
        }
        return bl;
    }

    public boolean substring(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        String string;
        SWRLBuiltInUtil.checkNumberOfArgumentsAtLeast(3, list.size());
        SWRLBuiltInUtil.checkNumberOfArgumentsAtMost(4, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        int n = SWRLBuiltInUtil.getArgumentAsAnInteger(2, list);
        if (list.size() == 4) {
            int n2 = SWRLBuiltInUtil.getArgumentAsAnInteger(3, list);
            string = string2.substring(n, n2);
        } else {
            string = string2.substring(n);
        }
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string3.equals(string);
        }
        return bl;
    }

    public boolean stringLength(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        int n = string.length();
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(n));
            bl = true;
        } else {
            String string2 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string2.length() == n;
        }
        return bl;
    }

    public boolean upperCase(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = string.toUpperCase();
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string2));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string3.equals(string2);
        }
        return bl;
    }

    public boolean lowerCase(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = string.toLowerCase();
        if (SWRLBuiltInUtil.hasUnboundArguments(list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string2));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string3.equals(string2);
        }
        return bl;
    }

    public boolean contains(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        return string.lastIndexOf(string2) != -1;
    }

    public boolean containsIgnoreCase(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        return string.toLowerCase().lastIndexOf(string2.toLowerCase()) != -1;
    }

    public boolean startsWith(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        return string.startsWith(string2);
    }

    public boolean endsWith(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        return string.endsWith(string2);
    }

    public boolean translate(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(4, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        String string3 = SWRLBuiltInUtil.getArgumentAsAString(3, list);
        String string4 = StringUtils.replaceChars((String)string, (String)string2, (String)string3);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string4));
            bl = true;
        } else {
            String string5 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string5.equals(string4);
        }
        return bl;
    }

    public boolean substringAfter(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        String string3 = StringUtils.substringAfter((String)string, (String)string2);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string3));
            bl = true;
        } else {
            String string4 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string4.equals(string3);
        }
        return bl;
    }

    public boolean substringBefore(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        String string3 = StringUtils.substringBefore((String)string, (String)string2);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string3));
            bl = true;
        } else {
            String string4 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string4.equals(string3);
        }
        return bl;
    }

    public boolean matches(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(0, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        try {
            bl = Pattern.matches(string2, string);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new InvalidBuiltInArgumentException(1, "invalid regular expression '" + string2 + "': " + patternSyntaxException.getMessage());
        }
        return bl;
    }

    public boolean replace(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(4, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        String string3 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        String string4 = matcher.replaceAll(string3);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string4));
            bl = true;
        } else {
            String string5 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string5.equals(string4);
        }
        return bl;
    }

    public boolean normalizeSpace(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        Pattern pattern = Pattern.compile("\\s*");
        Matcher matcher = pattern.matcher(string);
        String string2 = matcher.replaceAll(" ");
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            list.set(0, this.argumentFactory.createDatatypeValueArgument(string2));
            bl = true;
        } else {
            String string3 = SWRLBuiltInUtil.getArgumentAsAString(0, list);
            bl = string3.equals(string2);
        }
        return bl;
    }

    public boolean tokenize(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            throw new InvalidBuiltInArgumentException(0, "unexpected bound argument found");
        }
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        String string = SWRLBuiltInUtil.getArgumentAsAString(1, list);
        String string2 = SWRLBuiltInUtil.getArgumentAsAString(2, list);
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), string2);
        MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(0, list));
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            multiArgument.addArgument(this.argumentFactory.createDatatypeValueArgument(string3));
        }
        list.set(0, multiArgument);
        bl = !multiArgument.hasNoArguments();
        return bl;
    }

    public boolean yearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean dayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean dateTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean date(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean time(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addYearMonthDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractYearMonthDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean multiplyYearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean divideYearMonthDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addDayTimeDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDayTimeDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean multiplyDayTimeDurations(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean divideDayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDates(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractTimes(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addYearMonthDurationToDateTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addDayTimeDurationToDateTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractYearMonthDurationFromDateTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDayTimeDurationFromDateTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addYearMonthDurationToDate(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addDayTimeDurationToDate(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractYearMonthDurationFromDate(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDayTimeDurationFromDate(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean addDayTimeDurationToTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDayTimeDurationFromTime(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDateTimesYieldingYearMonthDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean subtractDateTimesYieldingDayTimeDuration(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean resolveURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean anyURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listConcat(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listIntersection(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean listSubtraction(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean member(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean length(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean first(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean rest(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean sublist(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean empty(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    private int compareTwoNumericArguments(List<BuiltInArgument> list) throws BuiltInException {
        double d;
        double d2;
        float f;
        float f2;
        long l;
        long l2;
        int n;
        int n2;
        short s;
        short s2;
        int n3 = 0;
        SWRLBuiltInUtil.checkThatAllArgumentsAreNumeric(list);
        n3 = SWRLBuiltInUtil.isShortMostPreciseArgument(list) ? ((s2 = SWRLBuiltInUtil.getArgumentAsAShort(0, list)) < (s = SWRLBuiltInUtil.getArgumentAsAShort(1, list)) ? -1 : (s2 > s ? 1 : 0)) : (SWRLBuiltInUtil.isIntegerMostPreciseArgument(list) ? ((n2 = SWRLBuiltInUtil.getArgumentAsAnInteger(0, list)) < (n = SWRLBuiltInUtil.getArgumentAsAnInteger(1, list)) ? -1 : (n2 > n ? 1 : 0)) : (SWRLBuiltInUtil.isLongMostPreciseArgument(list) ? ((l2 = SWRLBuiltInUtil.getArgumentAsALong(0, list)) < (l = SWRLBuiltInUtil.getArgumentAsALong(1, list)) ? -1 : (l2 > l ? 1 : 0)) : (SWRLBuiltInUtil.isFloatMostPreciseArgument(list) ? ((f2 = SWRLBuiltInUtil.getArgumentAsAFloat(0, list)) < (f = SWRLBuiltInUtil.getArgumentAsAFloat(1, list)) ? -1 : (f2 > f ? 1 : 0)) : ((d2 = SWRLBuiltInUtil.getArgumentAsADouble(0, list)) < (d = SWRLBuiltInUtil.getArgumentAsADouble(1, list)) ? -1 : (d2 > d ? 1 : 0)))));
        return n3;
    }

    private boolean mathOperation(String string, List<BuiltInArgument> list) throws BuiltInException {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        SWRLBuiltInUtil.checkForUnboundNonFirstArguments(list);
        if (SWRLBuiltInUtil.isUnboundArgument(0, list)) {
            bl2 = true;
        }
        if (!bl2) {
            d = SWRLBuiltInUtil.getArgumentAsADouble(0, list);
        }
        double d3 = SWRLBuiltInUtil.getArgumentAsADouble(1, list);
        if (string.equalsIgnoreCase(SWRLB_ADD)) {
            d2 = 0.0;
            for (int i = 1; i < list.size(); ++i) {
                d2 += SWRLBuiltInUtil.getArgumentAsADouble(i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_MULTIPLY)) {
            d2 = 1.0;
            for (int i = 1; i < list.size(); ++i) {
                d2 *= SWRLBuiltInUtil.getArgumentAsADouble(i, list);
            }
        } else if (string.equalsIgnoreCase(SWRLB_SUBTRACT)) {
            double d4 = SWRLBuiltInUtil.getArgumentAsADouble(2, list);
            d2 = d3 - d4;
        } else if (string.equalsIgnoreCase(SWRLB_DIVIDE)) {
            double d5 = SWRLBuiltInUtil.getArgumentAsADouble(2, list);
            d2 = d3 / d5;
        } else if (string.equalsIgnoreCase(SWRLB_INTEGER_DIVIDE)) {
            double d6 = SWRLBuiltInUtil.getArgumentAsADouble(2, list);
            if (d6 == 0.0) {
                throw new InvalidBuiltInArgumentException(2, "zero passed as divisor");
            }
            d2 = d6 >= 0.0 ? d3 + d6 + 1.0 / d6 : d3 / d6;
        } else if (string.equalsIgnoreCase(SWRLB_MOD)) {
            double d7 = SWRLBuiltInUtil.getArgumentAsADouble(2, list);
            d2 = d3 % d7;
        } else if (string.equalsIgnoreCase(SWRLB_POW)) {
            double d8 = SWRLBuiltInUtil.getArgumentAsADouble(2, list);
            d2 = (int)Math.pow(d3, d8);
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_PLUS)) {
            d2 = d3;
        } else if (string.equalsIgnoreCase(SWRLB_UNARY_MINUS)) {
            d2 = -d3;
        } else if (string.equalsIgnoreCase(SWRLB_ABS)) {
            d2 = Math.abs(d3);
        } else if (string.equalsIgnoreCase(SWRLB_CEILING)) {
            d2 = Math.ceil(d3);
        } else if (string.equalsIgnoreCase(SWRLB_FLOOR)) {
            d2 = Math.floor(d3);
        } else if (string.equalsIgnoreCase(SWRLB_ROUND)) {
            d2 = Math.rint(d3);
        } else if (string.equalsIgnoreCase(SWRLB_ROUND_HALF_TO_EVEN)) {
            d2 = Math.rint(d3);
        } else if (string.equalsIgnoreCase(SWRLB_SIN)) {
            d2 = Math.sin(d3);
        } else if (string.equalsIgnoreCase(SWRLB_COS)) {
            d2 = Math.cos(d3);
        } else if (string.equalsIgnoreCase(SWRLB_TAN)) {
            d2 = Math.tan(d3);
        } else {
            throw new InvalidBuiltInNameException(string);
        }
        if (bl2) {
            List<BuiltInArgument> list2 = list.subList(1, list.size());
            if (string.equalsIgnoreCase(SWRLB_SIN) || string.equalsIgnoreCase(SWRLB_COS) || string.equalsIgnoreCase(SWRLB_TAN)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument(d2));
            } else if (SWRLBuiltInUtil.isShortMostPreciseArgument(list2)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument((short)d2));
            } else if (SWRLBuiltInUtil.isIntegerMostPreciseArgument(list2)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument((int)d2));
            } else if (SWRLBuiltInUtil.isFloatMostPreciseArgument(list2)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument((float)d2));
            } else if (SWRLBuiltInUtil.isLongMostPreciseArgument(list2)) {
                list.set(0, this.argumentFactory.createDatatypeValueArgument((long)d2));
            } else {
                list.set(0, this.argumentFactory.createDatatypeValueArgument(d2));
            }
            bl = true;
        } else {
            bl = d == d2;
        }
        return bl;
    }
}

