/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge.builtins.abox;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.bridge.ArgumentFactory;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.MultiArgument;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.AbstractSWRLBuiltInLibrary;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInUtil;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInNotImplementedException;
import edu.stanford.smi.protegex.owl.swrl.exceptions.SWRLOWLUtilException;
import edu.stanford.smi.protegex.owl.swrl.util.SWRLOWLUtil;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWRLBuiltInLibraryImpl
extends AbstractSWRLBuiltInLibrary {
    private static String SWRLABoxLibraryName = "SWRLABoxBuiltIns";
    private static String SWRLABoxPrefix = "abox:";
    private ArgumentFactory argumentFactory = ArgumentFactory.getFactory();

    public SWRLBuiltInLibraryImpl() {
        super(SWRLABoxLibraryName);
    }

    @Override
    public void reset() {
    }

    public boolean isIndividual(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        boolean bl = SWRLBuiltInUtil.isUnboundArgument(0, list);
        boolean bl2 = false;
        try {
            if (bl) {
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(0, list));
                for (OWLIndividual oWLIndividual : SWRLOWLUtil.getAllIndividuals(this.getInvokingBridge().getOWLModel())) {
                    multiArgument.addArgument(this.argumentFactory.createIndividualArgument(oWLIndividual.getName()));
                }
                list.set(0, multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(0, list);
                bl2 = SWRLOWLUtil.isIndividual(this.getInvokingBridge().getOWLModel(), string, false);
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl2;
    }

    public boolean hasValue(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl;
        block10: {
            String string = null;
            Object object = null;
            bl = false;
            SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(3, list.size());
            String string2 = SWRLBuiltInUtil.getArgumentAsAnIndividualName(0, list);
            string = SWRLBuiltInUtil.getArgumentAsAPropertyName(1, list);
            boolean bl2 = !SWRLBuiltInUtil.isUnboundArgument(2, list);
            try {
                boolean bl3 = SWRLOWLUtil.isObjectProperty(this.getInvokingBridge().getOWLModel(), string);
                if (bl2) {
                    object = SWRLBuiltInUtil.getArgumentAsAPropertyValue(2, list);
                    bl = bl3 ? object == SWRLOWLUtil.getObjectPropertyValue(this.getInvokingBridge().getOWLModel(), string2, string, false) : object == SWRLOWLUtil.getDatavaluedPropertyValues(this.getInvokingBridge().getOWLModel(), string2, string, false);
                    break block10;
                }
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(2, list));
                if (bl3) {
                    for (Object object2 : SWRLOWLUtil.getObjectPropertyValues(this.getInvokingBridge().getOWLModel(), string2, string)) {
                        RDFResource rDFResource;
                        if (object2 instanceof OWLIndividual) {
                            rDFResource = (OWLIndividual)object2;
                            multiArgument.addArgument(this.argumentFactory.createIndividualArgument(rDFResource.getName()));
                            continue;
                        }
                        if (object2 instanceof OWLNamedClass) {
                            rDFResource = (OWLNamedClass)object2;
                            multiArgument.addArgument(this.argumentFactory.createClassArgument(rDFResource.getName()));
                            continue;
                        }
                        if (object2 instanceof OWLDatatypeProperty) {
                            rDFResource = (OWLDatatypeProperty)object2;
                            multiArgument.addArgument(this.argumentFactory.createDatatypePropertyArgument(rDFResource.getName()));
                            continue;
                        }
                        if (!(object2 instanceof OWLObjectProperty)) continue;
                        rDFResource = (OWLObjectProperty)object2;
                        multiArgument.addArgument(this.argumentFactory.createObjectPropertyArgument(rDFResource.getName()));
                    }
                } else {
                    for (Object object3 : SWRLOWLUtil.getDatavaluedPropertyValues(this.getInvokingBridge().getOWLModel(), string2, string)) {
                        if (!(object3 instanceof RDFSLiteral)) continue;
                        RDFSLiteral rDFSLiteral = (RDFSLiteral)object3;
                        multiArgument.addArgument(this.argumentFactory.createDatatypeValueArgument(this.getInvokingBridge().getOWLModel(), rDFSLiteral));
                    }
                }
                list.set(2, multiArgument);
                bl = !multiArgument.hasNoArguments();
            }
            catch (SWRLOWLUtilException sWRLOWLUtilException) {
                throw new BuiltInException(sWRLOWLUtilException.getMessage());
            }
        }
        return bl;
    }

    public boolean hasProperty(List<BuiltInArgument> list) throws BuiltInException {
        String string = null;
        Object var4_3 = null;
        boolean bl = SWRLBuiltInUtil.isUnboundArgument(1, list);
        boolean bl2 = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsInRange(2, 3, list.size());
        String string2 = SWRLBuiltInUtil.getArgumentAsAnIndividualName(0, list);
        string = SWRLBuiltInUtil.getArgumentAsAPropertyName(1, list);
        try {
            if (bl) {
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(1, list));
                for (OWLProperty oWLProperty : SWRLOWLUtil.getPropertiesOfIndividual(this.getInvokingBridge().getOWLModel(), string2)) {
                    if (oWLProperty.isObjectProperty()) {
                        multiArgument.addArgument(this.argumentFactory.createObjectPropertyArgument(oWLProperty.getName()));
                        continue;
                    }
                    multiArgument.addArgument(this.argumentFactory.createDatatypePropertyArgument(oWLProperty.getName()));
                }
                list.set(1, multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                bl2 = SWRLOWLUtil.getNumberOfPropertyValues(this.getInvokingBridge().getOWLModel(), string2, string, true) != 0;
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl2;
    }

    public boolean hasIndividual(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = SWRLBuiltInUtil.isUnboundArgument(1, list);
        boolean bl2 = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkThatArgumentIsAClass(0, list);
        String string = SWRLBuiltInUtil.getArgumentAsAClassName(0, list);
        try {
            if (bl) {
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(1, list));
                for (OWLIndividual oWLIndividual : SWRLOWLUtil.getIndividuals(this.getInvokingBridge().getOWLModel(), string)) {
                    multiArgument.addArgument(this.argumentFactory.createIndividualArgument(oWLIndividual.getName()));
                }
                list.set(1, multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                String string2 = SWRLBuiltInUtil.getArgumentAsAnIndividualName(1, list);
                bl2 = SWRLOWLUtil.isIndividualOfClass(this.getInvokingBridge().getOWLModel(), string2, string);
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl2;
    }

    public boolean hasURI(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = SWRLBuiltInUtil.isUnboundArgument(1, list);
        boolean bl2 = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkThatArgumentIsAClassPropertyOrIndividual(0, list);
        String string = SWRLBuiltInUtil.getArgumentAsAResourceName(0, list);
        try {
            if (bl) {
                String string2 = SWRLOWLUtil.getURI(this.getInvokingBridge().getOWLModel(), string);
                list.set(1, this.argumentFactory.createDatatypeValueArgument(string2));
                bl2 = true;
            } else {
                String string3 = SWRLBuiltInUtil.getArgumentAsAString(1, list);
                bl2 = string3.equals(SWRLOWLUtil.getURI(this.getInvokingBridge().getOWLModel(), string));
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl2;
    }

    public boolean hasClass(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = SWRLBuiltInUtil.isUnboundArgument(1, list);
        boolean bl2 = false;
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(2, list.size());
        SWRLBuiltInUtil.checkThatArgumentIsAnIndividual(0, list);
        String string = SWRLBuiltInUtil.getArgumentAsAnIndividualName(0, list);
        try {
            if (bl) {
                MultiArgument multiArgument = this.argumentFactory.createMultiArgument(SWRLBuiltInUtil.getVariableName(1, list));
                for (OWLNamedClass oWLNamedClass : SWRLOWLUtil.getClassesOfIndividual(this.getInvokingBridge().getOWLModel(), string)) {
                    multiArgument.addArgument(this.argumentFactory.createClassArgument(oWLNamedClass.getName()));
                }
                list.set(1, multiArgument);
                bl2 = !multiArgument.hasNoArguments();
            } else {
                String string2 = SWRLBuiltInUtil.getArgumentAsAClassName(1, list);
                bl2 = SWRLOWLUtil.isIndividualOfClass(this.getInvokingBridge().getOWLModel(), string, string2);
            }
        }
        catch (SWRLOWLUtilException sWRLOWLUtilException) {
            throw new BuiltInException(sWRLOWLUtilException.getMessage());
        }
        return bl2;
    }

    public boolean setClass(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean setValue(List<BuiltInArgument> list) throws BuiltInException {
        boolean bl = false;
        if (!bl) {
            throw new BuiltInNotImplementedException();
        }
        return bl;
    }

    public boolean isConstant(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        return SWRLBuiltInUtil.isArgumentALiteral(0, list);
    }

    public boolean isNumeric(List<BuiltInArgument> list) throws BuiltInException {
        SWRLBuiltInUtil.checkNumberOfArgumentsEqualTo(1, list.size());
        return SWRLBuiltInUtil.isArgumentNumeric(0, list);
    }

    public boolean notNumeric(List<BuiltInArgument> list) throws BuiltInException {
        return !this.isNumeric(list);
    }
}

