/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.swrl.bridge.SWRLRuleEngineBridge;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBridgeNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.NoRegisteredBridgesException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BridgeFactory {
    private static HashMap<String, BridgeCreator> registeredBridges = new HashMap();

    public static void registerBridge(String string, BridgeCreator bridgeCreator) {
        if (registeredBridges.containsKey(string)) {
            registeredBridges.remove(string);
            registeredBridges.put(string, bridgeCreator);
        } else {
            registeredBridges.put(string, bridgeCreator);
        }
        System.out.println("Rule engine '" + string + "' registered with the SWRLTab bridge.");
    }

    public static boolean isBridgeRegistered(String string) {
        return registeredBridges.containsKey(string);
    }

    public static Set<String> getRegisteredBridgeNames() {
        return registeredBridges.keySet();
    }

    public static SWRLRuleEngineBridge createBridge(OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        if (!registeredBridges.isEmpty()) {
            return BridgeFactory.createBridge(registeredBridges.keySet().iterator().next(), oWLModel);
        }
        throw new NoRegisteredBridgesException();
    }

    public static SWRLRuleEngineBridge createBridge(String string, OWLModel oWLModel) throws SWRLRuleEngineBridgeException {
        SWRLRuleEngineBridge sWRLRuleEngineBridge = null;
        if (registeredBridges.containsKey(string)) {
            try {
                sWRLRuleEngineBridge = registeredBridges.get(string).create(oWLModel);
            }
            catch (Throwable throwable) {
                throw new SWRLRuleEngineBridgeException("Error creating rule engine '" + string + "': " + throwable.getMessage());
            }
        } else {
            throw new InvalidBridgeNameException(string);
        }
        return sWRLRuleEngineBridge;
    }

    public static void unregisterBridge(String string) {
        if (registeredBridges.containsKey(string)) {
            registeredBridges.remove(string);
        }
    }

    static {
        Class clazz = PluginUtilities.forName((String)"edu.stanford.smi.protegex.owl.swrl.bridge.jess.SWRLJessBridge", (boolean)true);
        if (clazz == null) {
            System.err.println("SWRLJessBridge load failed - could not find class");
        }
    }

    public static interface BridgeCreator {
        public SWRLRuleEngineBridge create(OWLModel var1) throws SWRLRuleEngineBridgeException;
    }
}

