/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.server;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.server.framestore.background.ServerCacheStateMachine;
import edu.stanford.smi.protege.server.framestore.background.ServerCachedState;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.server.OwlState;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OwlStateMachine
implements ServerCacheStateMachine {
    private static transient Logger log = Log.getLogger(OwlStateMachine.class);
    private FrameStore fs;
    private final Object kbLock;
    private Map<StateAndSlot, OwlState> transitionMap = new HashMap<StateAndSlot, OwlState>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OwlStateMachine(FrameStore frameStore, Object object) {
        this.fs = frameStore;
        this.kbLock = object;
        Object object2 = object;
        synchronized (object2) {
            this.addTransition(OwlState.Start, ":DIRECT-SUPERCLASSES", OwlState.OwlExpr);
            this.addTransition(OwlState.Start, "owl:equivalentClass", OwlState.OwlExpr);
            this.addTransition(OwlState.OwlExpr, "owl:intersectionOf", OwlState.RDFList);
            this.addTransition(OwlState.OwlExpr, ":DIRECT-SUPERCLASSES", OwlState.End);
            this.addTransition(OwlState.OwlExpr, "owl:someValuesFrom", OwlState.End);
            this.addTransition(OwlState.RDFList, "rdf:rest", OwlState.RDFList);
            this.addTransition(OwlState.RDFList, "rdf:first", OwlState.OwlExpr);
            this.addTransition(OwlState.Start, ":DIRECT-INSTANCES", OwlState.UserIndividual);
        }
    }

    private void addTransition(OwlState owlState, String string, OwlState owlState2) {
        block4: {
            Slot slot = null;
            try {
                Frame frame = this.fs.getFrame(string);
                if (frame == null || !(frame instanceof Slot)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("frame found for transition " + (Object)((Object)owlState) + ", " + string + "/" + frame + " -> " + (Object)((Object)owlState2) + " but not a slot");
                    }
                    return;
                }
                slot = (Slot)frame;
                this.transitionMap.put(new StateAndSlot(owlState, slot), owlState2);
            }
            catch (Exception exception) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.fine("Exception caught creating transition " + (Object)((Object)owlState) + ", " + string + " -> " + (Object)((Object)owlState2) + ": " + exception);
                log.log(Level.FINER, "Exception = ", exception);
            }
        }
    }

    public ServerCachedState getInitialState() {
        return OwlState.Start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OwlState nextState(ServerCachedState serverCachedState, Frame frame, Slot slot, Frame frame2) {
        if (!(serverCachedState instanceof OwlState)) {
            return null;
        }
        OwlState owlState = this.transitionMap.get(new StateAndSlot((OwlState)serverCachedState, slot));
        Object object = this.kbLock;
        synchronized (object) {
            if (owlState != null && OwlState.allowTransition(this.fs, (OwlState)serverCachedState, frame, owlState, frame2)) {
                return owlState;
            }
        }
        return null;
    }

    private class StateAndSlot {
        private OwlState state;
        private Slot slot;

        public Slot getSlot() {
            return this.slot;
        }

        public OwlState getState() {
            return this.state;
        }

        public StateAndSlot(OwlState owlState, Slot slot) {
            this.state = owlState;
            this.slot = slot;
        }

        public int hashCode() {
            return this.state.ordinal() + this.slot.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof StateAndSlot)) {
                return false;
            }
            StateAndSlot stateAndSlot = (StateAndSlot)object;
            return stateAndSlot.state.equals((Object)this.state) && stateAndSlot.slot.equals(this.slot);
        }
    }
}

