/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.factory.RepositoryFactoryPlugin;
import edu.stanford.smi.protegex.owl.repository.impl.RelativeFolderRepository;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;

public class RelativeFolderRepositoryFactoryPlugin
implements RepositoryFactoryPlugin {
    public boolean isSuitable(OWLModel oWLModel, String string) {
        if (oWLModel.getProject() != null) {
            Object object;
            URI uRI = oWLModel.getProject().getProjectURI();
            if (uRI == null && oWLModel.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                object = JenaKnowledgeBaseFactory.getOWLFilePath(oWLModel.getProject().getSources());
                uRI = URIUtilities.createURI((String)object);
            }
            if (uRI != null) {
                try {
                    object = new URI(string.trim());
                    return !((URI)object).isAbsolute();
                }
                catch (URISyntaxException uRISyntaxException) {
                    return false;
                }
            }
        }
        return false;
    }

    public Repository createRepository(OWLModel oWLModel, String string) {
        try {
            URI uRI = oWLModel.getProject().getProjectURI();
            if (uRI == null && oWLModel.getKnowledgeBaseFactory() instanceof JenaKnowledgeBaseFactory) {
                String string2 = JenaKnowledgeBaseFactory.getOWLFilePath(oWLModel.getProject().getSources());
                uRI = URIUtilities.createURI((String)string2);
            }
            if (uRI == null) {
                return null;
            }
            return new RelativeFolderRepository(uRI.toURL(), string.trim());
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", uRISyntaxException);
        }
        return null;
    }
}

