/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.impl;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.repository.impl.AbstractLocalRepository;
import edu.stanford.smi.protegex.owl.repository.util.OntologyNameExtractor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;

public class LocalFolderRepository
extends AbstractLocalRepository {
    private static transient Logger log = Log.getLogger(LocalFolderRepository.class);
    public static final String RECURSIVE_FLAG = "Recursive";
    private boolean recursive;

    public LocalFolderRepository(File file) {
        this(file, false);
    }

    public LocalFolderRepository(File file, boolean bl) {
        this(file, bl, false);
    }

    public LocalFolderRepository(File file, boolean bl, boolean bl2) {
        super(file, bl);
        this.recursive = bl2;
        this.refresh();
    }

    public void refresh() {
        super.refresh();
        this.update();
    }

    private void update() {
        if (!this.getFile().isDirectory()) {
            Log.getLogger().warning("[Local Folder Repository] The specified file must be a directory. (" + this.getFile() + ")");
            return;
        }
        this.update(this.getFile());
    }

    private void update(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                try {
                    this.checkFile(file2);
                }
                catch (IOException iOException) {
                    Log.emptyCatchBlock((Throwable)iOException);
                }
                continue;
            }
            if (!this.recursive || !file2.isDirectory() || file2.isHidden()) continue;
            this.update(file2);
        }
    }

    private void checkFile(File file) throws IOException {
        if (file.getName().endsWith(".owl") && file.isFile()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            file.toURL();
            OntologyNameExtractor ontologyNameExtractor = new OntologyNameExtractor(fileInputStream, file.toURI().toURL());
            if (ontologyNameExtractor.getOntologyName() != null) {
                URI uRI = ontologyNameExtractor.getOntologyName();
                this.putOntology(uRI, file);
            }
        }
    }

    public String getRepositoryDescriptor() {
        String string = super.getRepositoryDescriptor();
        if (string != null) {
            string = string + "&Recursive=" + Boolean.toString(this.recursive);
        }
        return string;
    }

    public String getRepositoryDescription() {
        String string = "Local folder ";
        string = string + this.getFile().getPath();
        return string;
    }
}

