/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class XSDVisibility {
    public static Set getDefaultDatatypes(OWLModel oWLModel) {
        HashSet<RDFSDatatype> hashSet = new HashSet<RDFSDatatype>();
        hashSet.add(oWLModel.getXSDboolean());
        hashSet.add(oWLModel.getXSDfloat());
        hashSet.add(oWLModel.getXSDint());
        hashSet.add(oWLModel.getXSDstring());
        hashSet.add(oWLModel.getXSDdate());
        hashSet.add(oWLModel.getXSDdateTime());
        hashSet.add(oWLModel.getXSDtime());
        return hashSet;
    }

    public static void updateVisibility(OWLModel oWLModel) {
        Set set = XSDVisibility.getDefaultDatatypes(oWLModel);
        for (RDFSDatatype rDFSDatatype : oWLModel.getRDFSDatatypes()) {
            if (!rDFSDatatype.isSystem() || set.contains(rDFSDatatype)) continue;
            Collection collection = oWLModel.getReferences(rDFSDatatype, 10);
            boolean bl = collection.size() > 1;
            rDFSDatatype.setVisible(bl);
        }
    }
}

