/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class RDFSNamedClassPostProcessor {
    private KnowledgeBase kb;
    private OWLModel owlModel;

    RDFSNamedClassPostProcessor(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.kb = oWLModel;
        RDFProperty rDFProperty = oWLModel.getOWLOneOfProperty();
        if (oWLModel.getOWLFrameStore() != null) {
            oWLModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(true);
        }
        Collection collection = oWLModel.getUserDefinedRDFSNamedClasses();
        for (RDFSNamedClass rDFSNamedClass : collection) {
            if (rDFSNamedClass.getPropertyValues(rDFProperty).size() == 1) {
                this.convertToOWLEnumeratedClass(rDFSNamedClass);
                continue;
            }
            this.updateEquivalentClasses(rDFSNamedClass);
            this.updateDirectSuperclasses(rDFSNamedClass);
        }
        if (oWLModel.getOWLFrameStore() != null) {
            oWLModel.getOWLFrameStore().setSuperclassSynchronizationBlocked(false);
        }
        if (((AbstractOWLModel)oWLModel).isProtegeMetaOntologyImported()) {
            this.updateProtegeFeatures(collection);
        }
    }

    private void removeDuplicateSuperclasses(RDFSNamedClass rDFSNamedClass) {
        ArrayList arrayList = new ArrayList(rDFSNamedClass.getPureSuperclasses());
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            if (!(arrayList.get(i) instanceof OWLAnonymousClass)) continue;
            OWLAnonymousClass oWLAnonymousClass = (OWLAnonymousClass)arrayList.get(i);
            for (int j = arrayList.size() - 1; j > i; --j) {
                if (arrayList.get(j).getClass() != oWLAnonymousClass.getClass()) continue;
                String string = ((Cls)arrayList.get(i)).getBrowserText();
                OWLAnonymousClass oWLAnonymousClass2 = (OWLAnonymousClass)arrayList.get(j);
                if (!oWLAnonymousClass2.getBrowserText().equals(string)) continue;
                rDFSNamedClass.removeDirectSuperclass(oWLAnonymousClass2);
            }
        }
    }

    private void convertToOWLEnumeratedClass(Cls cls) {
        TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
        cls.setDirectType(this.kb.getCls("owl:EnumeratedClass"));
        cls.setDirectOwnSlotValue((Slot)this.owlModel.getRDFTypeProperty(), (Object)this.owlModel.getOWLNamedClassClass());
    }

    private void updateDirectSuperclasses(Cls cls) {
        Collection collection = cls.getDirectSuperclasses();
        for (Object e : collection) {
            if (!(e instanceof Cls)) {
                throw new RuntimeException("Illegal superclass " + e + " of " + cls.getName() + " has type " + e.getClass());
            }
            Cls cls2 = (Cls)e;
            if (!(cls2 instanceof RDFSNamedClass) || cls2.hasDirectSuperclass(cls)) continue;
            return;
        }
        TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
        cls.addDirectSuperclass(this.kb.getRootCls());
    }

    private void updateEquivalentClasses(Cls cls) {
        List list = cls.getDirectOwnSlotValues((Slot)this.owlModel.getOWLEquivalentClassProperty());
        for (Cls cls2 : list) {
            TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
            cls.addDirectSuperclass(cls2);
            cls2.addDirectSuperclass(cls);
        }
    }

    private void updateProtegeFeatures(Collection collection) {
        RDFProperty rDFProperty = this.owlModel.getRDFProperty(ProtegeNames.Slot.ABSTRACT);
        for (Cls cls : collection) {
            if (rDFProperty == null || !Boolean.TRUE.equals(cls.getDirectOwnSlotValue((Slot)rDFProperty))) continue;
            TripleStoreUtil.ensureActiveTripleStore((RDFResource)cls);
            cls.setAbstract(true);
        }
    }
}

