/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.OWLFrameStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

class DuplicateSuperclassesPostProcessor {
    DuplicateSuperclassesPostProcessor(OWLModel oWLModel) {
        OWLFrameStore oWLFrameStore = oWLModel.getOWLFrameStore();
        if (oWLFrameStore != null) {
            oWLFrameStore.setSuperclassSynchronizationBlocked(true);
        }
        Collection collection = oWLModel.getUserDefinedOWLNamedClasses();
        for (OWLNamedClass oWLNamedClass : collection) {
            this.removeDuplicateSuperclasses(oWLNamedClass);
        }
        if (oWLFrameStore != null) {
            oWLFrameStore.setSuperclassSynchronizationBlocked(false);
        }
    }

    private void removeDuplicateSuperclasses(RDFSNamedClass rDFSNamedClass) {
        String string;
        ArrayList arrayList = new ArrayList(rDFSNamedClass.getPureSuperclasses());
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        for (Cls cls : arrayList) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            string = cls.getBrowserText();
            if (hashSet.contains(string)) {
                System.err.println("[DuplicateSuperclassesPostProcessor]  Class " + rDFSNamedClass.getBrowserText() + " has duplicate superclass " + string);
                bl = true;
                break;
            }
            hashSet.add(string);
        }
        if (bl) {
            for (int i = 0; i < arrayList.size() - 1; ++i) {
                Cls cls;
                if (!(arrayList.get(i) instanceof OWLAnonymousClass)) continue;
                cls = (OWLAnonymousClass)arrayList.get(i);
                string = cls.getBrowserText();
                for (int j = arrayList.size() - 1; j > i; --j) {
                    OWLAnonymousClass oWLAnonymousClass;
                    String string2;
                    if (arrayList.get(j).getClass() != cls.getClass() || !(string2 = (oWLAnonymousClass = (OWLAnonymousClass)arrayList.get(j)).getBrowserText()).equals(string)) continue;
                    rDFSNamedClass.removeDirectSuperclass(oWLAnonymousClass);
                    arrayList.remove(j);
                }
            }
        }
    }
}

