/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFNames;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractAddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.util.Collection;

class AddRDFTypePropertyHandler
extends AbstractAddPropertyValueHandler {
    private Slot directInstancesSlot;
    private Slot directTypesSlot;
    private Cls owlClassClass;
    private TripleStore tripleStore;
    private TripleStoreModel tripleStoreModel;
    private Cls untypedResourceClass;

    AddRDFTypePropertyHandler(ProtegeTripleAdder protegeTripleAdder, KnowledgeBase knowledgeBase, TripleStoreModel tripleStoreModel, TripleStore tripleStore) {
        super(protegeTripleAdder);
        this.directInstancesSlot = knowledgeBase.getSlot(":DIRECT-INSTANCES");
        this.directTypesSlot = knowledgeBase.getSlot(":DIRECT-TYPE");
        this.owlClassClass = knowledgeBase.getCls("owl:Class");
        this.untypedResourceClass = knowledgeBase.getCls(RDFNames.Cls.EXTERNAL_RESOURCE);
        this.tripleStoreModel = tripleStoreModel;
        this.tripleStore = tripleStore;
    }

    public void handleAdd(RDFResource rDFResource, Object object) {
        Collection collection = this.adder.getSlotValues(rDFResource, this.directTypesSlot);
        if (collection.isEmpty()) {
            this.tripleStoreModel.setHomeTripleStore(rDFResource, this.tripleStore);
        }
        if (!object.equals(this.owlClassClass)) {
            if (this.adder.addValue(rDFResource, this.directTypesSlot, object)) {
                this.adder.addValueFast((Instance)object, this.directInstancesSlot, rDFResource);
            }
        } else if (collection.isEmpty() && this.adder.addValue(rDFResource, this.directTypesSlot, object)) {
            this.adder.addValueFast((Instance)object, this.directInstancesSlot, rDFResource);
        }
        if (collection.size() == 1 && collection.contains(this.untypedResourceClass)) {
            rDFResource.removeDirectType(this.untypedResourceClass);
            this.tripleStoreModel.setHomeTripleStore(rDFResource, this.tripleStore);
        }
    }
}

