/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactoryUpdater;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.TripleChangePostProcessor;
import edu.stanford.smi.protegex.owl.util.OWLFrameStoreUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTripleStoreModel
implements TripleStoreModel {
    protected MergingNarrowFrameStore mnfs;
    private Slot nameSlot;
    private OWLModel owlModel;
    protected List<TripleStore> ts = new ArrayList<TripleStore>();

    public AbstractTripleStoreModel(OWLModel oWLModel) {
        this.nameSlot = oWLModel.getSlot(":NAME");
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)oWLModel);
        this.owlModel = oWLModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTripleStoreChanges() {
        this.owlModel.flushCache();
        Collection collection = this.owlModel.getRDFResources();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RDFResource rDFResource = (RDFResource)iterator.next();
            if (!rDFResource.isSystem()) continue;
            iterator.remove();
        }
        OWLJavaFactoryUpdater.run(this.owlModel, collection);
        boolean bl = this.owlModel.setGenerateEventsEnabled(false);
        try {
            TripleChangePostProcessor.postProcess(this.owlModel);
        }
        finally {
            this.owlModel.setGenerateEventsEnabled(bl);
        }
        this.owlModel.flushCache();
    }

    @Override
    public TripleStore getActiveTripleStore() {
        if (this.mnfs == null) {
            return this.ts.get(this.ts.size() - 1);
        }
        NarrowFrameStore narrowFrameStore = this.mnfs.getActiveFrameStore();
        String string = narrowFrameStore.getName();
        return this.getTripleStore(string);
    }

    @Override
    public TripleStore getHomeTripleStore(RDFResource rDFResource) {
        for (TripleStore tripleStore : this.ts) {
            if (tripleStore.getNarrowFrameStore().getValuesCount((Frame)rDFResource, this.nameSlot, null, false) <= 0) continue;
            return tripleStore;
        }
        return null;
    }

    @Override
    public Collection getPropertyValues(RDFResource rDFResource, RDFProperty rDFProperty) {
        List list = this.mnfs.getValues((Frame)rDFResource, (Slot)rDFProperty, null, false);
        return OWLFrameStoreUtils.convertValueListToRDFLiterals(this.owlModel, list);
    }

    @Override
    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.mnfs.getValues((Frame)instance, slot, null, false);
    }

    @Override
    public TripleStore getTripleStore(String string) {
        if (string == null) {
            return this.getActiveTripleStore();
        }
        for (TripleStore tripleStore : this.ts) {
            if (!string.equals(tripleStore.getName())) continue;
            return tripleStore;
        }
        return null;
    }

    @Override
    public TripleStore getTripleStore(int n) {
        return this.getTripleStores().get(n);
    }

    @Override
    public List<TripleStore> getTripleStores() {
        return new ArrayList<TripleStore>(this.ts);
    }

    @Override
    public TripleStore getTopTripleStore() {
        if (this.mnfs == null && this.ts.size() == 1) {
            return this.ts.get(0);
        }
        return this.ts.get(1);
    }

    @Override
    public boolean isActiveTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        return this.getActiveTripleStore().contains(rDFResource, rDFProperty, object);
    }

    @Override
    public boolean isEditableTriple(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        object = DefaultRDFSLiteral.getPlainValueIfPossible(object);
        Iterator iterator = this.listUserTripleStores();
        while (iterator.hasNext()) {
            TripleStore tripleStore = (TripleStore)iterator.next();
            if (!tripleStore.contains(rDFResource, rDFProperty, object)) continue;
            return this.isEditableTripleStore(tripleStore);
        }
        return false;
    }

    @Override
    public boolean isEditableTripleStore(TripleStore tripleStore) {
        int n = this.ts.indexOf(tripleStore);
        if (this.mnfs == null) {
            return n == this.ts.size() - 1;
        }
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        try {
            URI uRI = new URI(tripleStore.getName());
            return this.owlModel.getRepositoryManager().getRepository(uRI).isWritable(uRI);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public Iterator<Triple> listTriplesWithSubject(RDFResource rDFResource) {
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (TripleStore tripleStore : this.getTripleStores()) {
            Iterator<Triple> iterator = tripleStore.listTriplesWithSubject(rDFResource);
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                arrayList.add(triple);
            }
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<RDFResource> listSubjects(RDFProperty rDFProperty) {
        HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
        for (TripleStore tripleStore : this.getTripleStores()) {
            Iterator<RDFResource> iterator = tripleStore.listSubjects(rDFProperty);
            while (iterator.hasNext()) {
                Frame frame = (Frame)iterator.next();
                if (!(frame instanceof RDFResource)) continue;
                hashSet.add((RDFResource)frame);
            }
        }
        return hashSet.iterator();
    }

    public Iterator listUserTripleStores() {
        if (this.mnfs == null && this.ts.size() == 1) {
            return CollectionUtilities.createCollection((Object)this.ts.get(0)).iterator();
        }
        Iterator<TripleStore> iterator = this.getTripleStores().iterator();
        iterator.next();
        return iterator;
    }

    @Override
    public void replaceJavaObject(RDFResource rDFResource) {
        this.mnfs.replaceFrame((Frame)rDFResource);
    }

    @Override
    public void setActiveTripleStore(TripleStore tripleStore) {
        if (this.mnfs == null && this.ts.size() == 1) {
            return;
        }
        if (this.mnfs.getActiveFrameStore() != tripleStore.getNarrowFrameStore()) {
            this.mnfs.setActiveFrameStore(tripleStore.getNarrowFrameStore());
        }
    }

    @Override
    public void setHomeTripleStore(RDFResource rDFResource, TripleStore tripleStore) {
        TripleStore tripleStore2 = this.getHomeTripleStore(rDFResource);
        if (tripleStore2 != tripleStore) {
            List list = this.mnfs.getValues((Frame)rDFResource, this.nameSlot, null, false);
            String string = (String)list.get(0);
            tripleStore2.getNarrowFrameStore().removeValue((Frame)rDFResource, this.nameSlot, null, false, (Object)string);
            tripleStore.getNarrowFrameStore().addValues((Frame)rDFResource, this.nameSlot, null, false, Collections.singleton(string));
        }
    }

    @Override
    public void updateEditableResourceState() {
        Slot slot = this.owlModel.getSlot(":NAME");
        TripleStoreUtil.updateFrameInclusion(this.mnfs, slot);
    }

    @Override
    public void dispose() {
        for (TripleStore tripleStore : this.ts) {
            tripleStore.dispose();
        }
        if (this.mnfs != null) {
            this.mnfs.close();
        }
        this.ts.clear();
        this.ts = null;
    }
}

