/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class DefaultRDFList
extends DefaultRDFIndividual
implements RDFList {
    public DefaultRDFList(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    public DefaultRDFList() {
    }

    public void accept(OWLModelVisitor oWLModelVisitor) {
        oWLModelVisitor.visitRDFList(this);
    }

    public void append(Object object) {
        boolean bl = false;
        RDFList rDFList = this;
        while (!bl) {
            if (rDFList.getFirst() == null) {
                rDFList.setFirst(object);
                rDFList.setRest(this.getOWLModel().getRDFNil());
                bl = true;
                continue;
            }
            if (rDFList.getRest() == null || this.getOWLModel().getRDFNil().equals(rDFList.getRest())) {
                RDFSNamedClass rDFSNamedClass = (RDFSNamedClass)this.getDirectType();
                RDFList rDFList2 = (RDFList)rDFSNamedClass.createAnonymousInstance();
                rDFList2.setFirst(object);
                rDFList2.setRest(this.getOWLModel().getRDFNil());
                rDFList.setRest(rDFList2);
                bl = true;
                continue;
            }
            rDFList = rDFList.getRest();
        }
    }

    public boolean contains(Object object) {
        return this.getValues().contains(object);
    }

    public boolean equalsStructurally(RDFObject rDFObject) {
        if (rDFObject instanceof RDFList) {
            RDFList rDFList = (RDFList)rDFObject;
            if (this.getValues().size() == rDFList.getValues().size()) {
                Iterator iterator = this.getValues().iterator();
                Iterator iterator2 = rDFList.getValues().iterator();
                while (iterator2.hasNext()) {
                    OWLModel oWLModel = this.getOWLModel();
                    RDFObject rDFObject2 = oWLModel.asRDFObject(iterator2.next());
                    RDFObject rDFObject3 = oWLModel.asRDFObject(iterator.next());
                    if (!(rDFObject2 != null && rDFObject3 != null ? !rDFObject2.equalsStructurally(rDFObject3) : rDFObject2 != rDFObject3)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String getBrowserText() {
        if (this.getDirectType() == null) {
            if (Log.getLogger().getLevel() == Level.WARNING) {
                Log.getLogger().log(Level.WARNING, "Called method on deleted frame " + this);
            }
            return "deleted frame id: " + this.getFrameID().toStringRepresentation();
        }
        String string = this.getDirectType().getBrowserText() + " (";
        Iterator iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            string = e instanceof Instance ? string + ((Instance)e).getBrowserText() : string + e;
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string + ")";
    }

    public Object getFirst() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFFirstProperty();
        return this.getPropertyValue(rDFProperty);
    }

    public RDFSLiteral getFirstLiteral() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFFirstProperty();
        return this.getPropertyValueLiteral(rDFProperty);
    }

    public List getValueLiterals() {
        List list = this.getValues();
        return ((AbstractOWLModel)this.getOWLModel()).getValueLiterals(list);
    }

    public RDFList getRest() {
        RDFProperty rDFProperty = this.getOWLModel().getRDFRestProperty();
        return (RDFList)this.getPropertyValue(rDFProperty);
    }

    public RDFList getStart() {
        Collection collection = this.getOWLModel().getReferences(this, 1000);
        for (Reference reference : collection) {
            if (!(reference.getFrame() instanceof RDFList) || !reference.getSlot().equals(this.getOWLModel().getRDFRestProperty())) continue;
            return ((RDFList)reference.getFrame()).getStart();
        }
        return this;
    }

    public List getValues() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (RDFList rDFList = this; rDFList != null && rDFList.getFirst() != null; rDFList = rDFList.getRest()) {
            arrayList.add(rDFList.getFirst());
        }
        return arrayList;
    }

    public boolean isClosed() {
        RDFList rDFList = this.getRest();
        if (rDFList == null) {
            return false;
        }
        if (rDFList.equals(this.getOWLModel().getRDFNil())) {
            return true;
        }
        return rDFList.isClosed();
    }

    public static void removeListValue(RDFResource rDFResource, RDFProperty rDFProperty, Object object) {
        RDFList rDFList = (RDFList)rDFResource.getPropertyValue(rDFProperty);
        List list = rDFList.getValues();
        int n = list.indexOf(object);
        DefaultRDFList.removeListValue(rDFResource, rDFProperty, rDFList, n);
    }

    public static void removeListValue(RDFResource rDFResource, RDFProperty rDFProperty, RDFList rDFList, int n) {
        if (n == 0) {
            RDFList rDFList2 = rDFList.getRest();
            if (rDFList.getOWLModel().getRDFNil().equals(rDFList2)) {
                rDFList2 = null;
            }
            rDFList.setRest(null);
            rDFResource.setPropertyValue(rDFProperty, rDFList2);
            rDFList.delete();
        } else {
            RDFList rDFList3 = null;
            while (n > 0) {
                --n;
                rDFList3 = rDFList;
                rDFList = rDFList.getRest();
            }
            RDFList rDFList4 = rDFList.getRest();
            rDFList.setRest(null);
            rDFList3.setRest(rDFList4);
            rDFList.delete();
        }
    }

    public void setFirst(Object object) {
        Slot slot = this.getKnowledgeBase().getSlot("rdf:first");
        this.setOwnSlotValue(slot, object);
    }

    public void setRest(RDFList rDFList) {
        Slot slot = this.getKnowledgeBase().getSlot("rdf:rest");
        this.setOwnSlotValue(slot, rDFList);
    }

    public int size() {
        return this.getValues().size();
    }
}

