/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ResourceCopier;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.util.OWLBrowserSlotPattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public abstract class AbstractRDFSClass
extends DefaultCls
implements RDFSClass {
    public AbstractRDFSClass(KnowledgeBase knowledgeBase, FrameID frameID) {
        super(knowledgeBase, frameID);
    }

    AbstractRDFSClass() {
    }

    protected void addAnonymousClses(Collection collection, Collection collection2) {
        for (Cls cls : collection2) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            collection.add(cls);
        }
    }

    public void addClassListener(ClassListener classListener) {
        if (!(classListener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.addClsListener(classListener);
    }

    public void addSuperclass(RDFSClass rDFSClass) {
        this.getKnowledgeBase().addDirectSuperclass((Cls)this, (Cls)rDFSClass);
    }

    public void addToUnionDomainOf(RDFProperty rDFProperty) {
        this.getKnowledgeBase().addDirectTemplateSlot((Cls)this, (Slot)rDFProperty);
    }

    public RDFSClass createClone() {
        RDFSClass rDFSClass = null;
        try {
            this.getOWLModel().beginTransaction("Created clone of " + this.getBrowserText());
            ResourceCopier resourceCopier = new ResourceCopier();
            this.accept(resourceCopier);
            rDFSClass = (RDFSClass)resourceCopier.getCopy();
            this.getOWLModel().commitTransaction();
        }
        catch (Exception exception) {
            this.getOWLModel().rollbackTransaction();
            Log.getLogger().log(Level.WARNING, "There were errors while creating clone of " + this, exception);
        }
        return rDFSClass;
    }

    public RDFResource createInstance(String string) {
        return (RDFResource)this.getKnowledgeBase().createInstance(string, (Cls)this);
    }

    protected AbstractOWLModel getAbstractOWLModel() {
        return (AbstractOWLModel)this.getKnowledgeBase();
    }

    public RDFSClass getDefinition() {
        for (Cls cls : this.getDirectSuperclasses()) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            return (RDFSClass)cls;
        }
        return null;
    }

    public Collection getUnionDomainProperties() {
        return this.getUnionDomainProperties(false);
    }

    public Collection getPureSuperclasses() {
        Collection collection = this.getDirectSuperclasses();
        ArrayList arrayList = new ArrayList(collection);
        for (Cls cls : collection) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            arrayList.remove(cls);
            if (!(cls instanceof OWLIntersectionClass)) continue;
            for (RDFSClass rDFSClass : ((OWLIntersectionClass)cls).getOperands()) {
                if (!(rDFSClass instanceof OWLNamedClass)) continue;
                arrayList.remove(rDFSClass);
            }
        }
        return arrayList;
    }

    public Object getDirectTemplateFacetValue(Slot slot, Facet facet) {
        List list = this.getDirectTemplateFacetValues(slot, facet);
        if (list.isEmpty()) {
            return null;
        }
        return list.iterator().next();
    }

    public Collection getUnionDomainProperties(boolean bl) {
        if (bl) {
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getTemplateSlots((Cls)this));
        }
        return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectTemplateSlots((Cls)this));
    }

    private Collection getVisibleFrames(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Frame frame : collection) {
            if (!frame.isVisible()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    public Collection getDisjointClasses() {
        RDFProperty rDFProperty = this.getOWLModel().getOWLDisjointWithProperty();
        return this.getOwnSlotValues(rDFProperty);
    }

    public Collection getEquivalentClasses() {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (Cls cls : this.getDirectSuperclasses()) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            arrayList.add(cls);
        }
        return arrayList;
    }

    public int getInferredInstanceCount() {
        return this.getInferredInstances(false).size();
    }

    public Collection getInferredInstances(boolean bl) {
        RDFProperty rDFProperty = this.getOWLModel().getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE);
        if (bl) {
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.getKnowledgeBase().getFramesWithValue((Slot)rDFProperty, null, false, (Object)this));
            for (RDFSClass rDFSClass : this.getSubclasses(true)) {
                hashSet.addAll(this.getKnowledgeBase().getFramesWithValue((Slot)rDFProperty, null, false, (Object)rDFSClass));
            }
            return hashSet;
        }
        return this.getKnowledgeBase().getFramesWithValue((Slot)rDFProperty, null, false, (Object)this);
    }

    public int getInstanceCount(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getInstanceCount((Cls)this);
        }
        return this.getKnowledgeBase().getDirectInstanceCount((Cls)this);
    }

    public Collection getInstances(boolean bl) {
        if (bl) {
            return this.getKnowledgeBase().getInstances((Cls)this);
        }
        return this.getKnowledgeBase().getDirectInstances((Cls)this);
    }

    public Collection getNamedSubclasses() {
        return this.getNamedSubclasses(false);
    }

    public Collection getNamedSuperclasses() {
        return this.getNamedSuperclasses(false);
    }

    public Collection getNamedSubclasses(boolean bl) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (Cls cls : this.getSubclasses(bl)) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            arrayList.add(cls);
        }
        return arrayList;
    }

    public Collection getNamedSuperclasses(boolean bl) {
        ArrayList<Cls> arrayList = new ArrayList<Cls>();
        for (Cls cls : this.getSuperclasses(bl)) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            arrayList.add(cls);
        }
        return arrayList;
    }

    public String getParsableExpression() {
        return this.getBrowserText();
    }

    public int getSubclassCount() {
        if (Model.ClsID.THING.equals((Object)this.getFrameID())) {
            return this.getSubclasses(false).size();
        }
        return this.getKnowledgeBase().getDirectSubclassCount((Cls)this);
    }

    public Collection getSubclasses(boolean bl) {
        if (Model.ClsID.THING.equals((Object)this.getFrameID())) {
            if (bl) {
                return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getSubclasses((Cls)this));
            }
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectSubclasses((Cls)this));
        }
        if (bl) {
            return this.getKnowledgeBase().getSubclasses((Cls)this);
        }
        return this.getKnowledgeBase().getDirectSubclasses((Cls)this);
    }

    public int getSuperclassCount() {
        return this.getSuperclasses(false).size();
    }

    public Collection getSuperclasses(boolean bl) {
        if (bl) {
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getSuperclasses((Cls)this));
        }
        return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectSuperclasses((Cls)this));
    }

    public boolean hasPropertyValueWithBrowserText(RDFProperty rDFProperty, String string) {
        return this.hasPropertyValueWithBrowserText((Slot)rDFProperty, string);
    }

    public boolean hasPropertyValueWithBrowserText(Slot slot, String string) {
        for (Frame frame : this.getDirectOwnSlotValues(slot)) {
            if (!string.equals(frame.getBrowserText())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEquivalentClass(RDFSClass rDFSClass) {
        return this.hasDirectSuperclass(rDFSClass) && rDFSClass.isSubclassOf(this);
    }

    public boolean isMetaclass() {
        return this.getKnowledgeBase().isMetaCls((Cls)this);
    }

    public boolean isSubclassOf(RDFSClass rDFSClass) {
        return this.getKnowledgeBase().hasDirectSuperclass((Cls)this, (Cls)rDFSClass);
    }

    public void removeClassListener(ClassListener classListener) {
        if (!(classListener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.removeClsListener(classListener);
    }

    public void removeSuperclass(RDFSClass rDFSClass) {
        this.getKnowledgeBase().removeDirectSuperclass((Cls)this, (Cls)rDFSClass);
    }

    public void addComment(String string) {
        OWLUtil.addComment(this, string);
    }

    public void addDifferentFrom(RDFResource rDFResource) {
        OWLUtil.addDifferentFrom(this, rDFResource);
    }

    public void addIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.addIsDefinedBy(this, rDFResource);
    }

    public void addLabel(String string, String string2) {
        OWLUtil.addLabel(this, string, string2);
    }

    public void addPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.addPropertyValue(this, rDFProperty, object);
    }

    public void addPropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.addPropertyValueListener(this, propertyValueListener);
    }

    public void addProtegeType(RDFSClass rDFSClass) {
        OWLUtil.addProtegeType(this, rDFSClass);
    }

    public void addRDFType(RDFSClass rDFSClass) {
        OWLUtil.addRDFType(this, rDFSClass);
    }

    public void addResourceListener(ResourceListener resourceListener) {
        OWLUtil.addResourceListener(this, resourceListener);
    }

    public void addSameAs(RDFResource rDFResource) {
        OWLUtil.addSameAs(this, rDFResource);
    }

    public void addVersionInfo(String string) {
        OWLUtil.addVersionInfo(this, string);
    }

    public RDFResource as(Class clazz) {
        return OWLUtil.as(this, clazz);
    }

    public boolean canAs(Class clazz) {
        return OWLUtil.canAs(this, clazz);
    }

    public RDFResource getAllValuesFromOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getAllValuesFromOnTypes(this, rDFProperty);
    }

    public Collection getComments() {
        return OWLUtil.getComments(this);
    }

    public Collection getDifferentFrom() {
        return OWLUtil.getDifferentFrom(this);
    }

    public Collection getHasValuesOnTypes(RDFProperty rDFProperty) {
        return OWLUtil.getHasValuesOnTypes(this, rDFProperty);
    }

    public Class getIconLocation() {
        return OWLIcons.class;
    }

    public RDFSClass getProtegeType() {
        return OWLUtil.getDirectRDFType(this);
    }

    public Collection getProtegeTypes() {
        return OWLUtil.getDirectRDFTypes(this);
    }

    public Collection getDocumentation() {
        return OWLUtil.getComments(this);
    }

    public Collection getInferredTypes() {
        return OWLUtil.getInferredDirectTypes(this);
    }

    public Collection getIsDefinedBy() {
        return OWLUtil.getIsDefinedBy(this);
    }

    public Collection getLabels() {
        return OWLUtil.getLabels(this);
    }

    public String getLocalName() {
        String string = this.getName();
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        return oWLModel.getLocalNameForResourceName(string);
    }

    public String getNamespace() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        String string = this.getName();
        return oWLModel.getNamespaceForResourceName(string);
    }

    public String getNamespacePrefix() {
        OWLModel oWLModel = (OWLModel)this.getKnowledgeBase();
        String string = this.getName();
        return oWLModel.getPrefixForResourceName(string);
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getKnowledgeBase();
    }

    public Collection getPossibleRDFProperties() {
        return OWLUtil.getPossibleRDFProperties(this);
    }

    public Object getPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValue(this, rDFProperty, false);
    }

    public RDFResource getPropertyValueAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValueAs(this, rDFProperty, clazz);
    }

    public Object getPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValue(this, rDFProperty, bl);
    }

    public int getPropertyValueCount(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueCount(this, rDFProperty);
    }

    public RDFSLiteral getPropertyValueLiteral(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiteral(this, rDFProperty);
    }

    public Collection getPropertyValueLiterals(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValueLiterals(this, rDFProperty);
    }

    public Collection getPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.getPropertyValues(this, rDFProperty, false);
    }

    public Collection getPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.getPropertyValuesAs(this, rDFProperty, clazz);
    }

    public Collection getPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.getPropertyValues(this, rDFProperty, bl);
    }

    public Set getReferringAnonymousClasses() {
        return OWLUtil.getReferringAnonymousClses(this);
    }

    public Collection getRDFProperties() {
        return OWLUtil.getRDFProperties(this);
    }

    public RDFSClass getRDFType() {
        return OWLUtil.getRDFType(this);
    }

    public Collection getRDFTypes() {
        return OWLUtil.getRDFTypes(this);
    }

    public Collection getSameAs() {
        return OWLUtil.getSameAs(this);
    }

    public String getURI() {
        return this.getOWLModel().getURIForResourceName(this.getName());
    }

    public Collection getVersionInfo() {
        return OWLUtil.getVersionInfo(this);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty) {
        return OWLUtil.hasPropertyValue(this, rDFProperty);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, bl);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object) {
        return this.hasPropertyValue(rDFProperty, object, false);
    }

    public boolean hasPropertyValue(RDFProperty rDFProperty, Object object, boolean bl) {
        return OWLUtil.hasPropertyValue(this, rDFProperty, object, bl);
    }

    public boolean hasProtegeType(RDFSClass rDFSClass) {
        return OWLUtil.hasProtegeType(this, rDFSClass);
    }

    public boolean hasProtegeType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasProtegeType(this, rDFSClass, bl);
    }

    public boolean hasRDFType(RDFSClass rDFSClass) {
        return OWLUtil.hasRDFType(this, rDFSClass);
    }

    public boolean hasRDFType(RDFSClass rDFSClass, boolean bl) {
        return OWLUtil.hasRDFType(this, rDFSClass, bl);
    }

    public boolean isValidPropertyValue(RDFProperty rDFProperty, Object object) {
        return OWLUtil.isValidPropertyValue(this, rDFProperty, object);
    }

    public Iterator listPropertyValues(RDFProperty rDFProperty) {
        return OWLUtil.listPropertyValues(this, rDFProperty, false);
    }

    public Iterator listPropertyValuesAs(RDFProperty rDFProperty, Class clazz) {
        return OWLUtil.listPropertyValuesAs(this, rDFProperty, clazz);
    }

    public Iterator listPropertyValues(RDFProperty rDFProperty, boolean bl) {
        return OWLUtil.listPropertyValues(this, rDFProperty, bl);
    }

    public Iterator listRDFTypes() {
        return this.getRDFTypes().iterator();
    }

    public void removeComment(String string) {
        OWLUtil.removeComment(this, string);
    }

    public void removeDifferentFrom(RDFResource rDFResource) {
        OWLUtil.removeDifferentFrom(this, rDFResource);
    }

    public void removeIsDefinedBy(RDFResource rDFResource) {
        OWLUtil.removeIsDefinedBy(this, rDFResource);
    }

    public void removeLabel(String string, String string2) {
        OWLUtil.removeLabel(this, string, string2);
    }

    public void removePropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.removePropertyValue(this, rDFProperty, object);
    }

    public void removePropertyValueListener(PropertyValueListener propertyValueListener) {
        OWLUtil.removePropertyValueListener(this, propertyValueListener);
    }

    public void removeProtegeType(RDFSClass rDFSClass) {
        OWLUtil.removeProtegeType(this, rDFSClass);
    }

    public void removeRDFType(RDFSClass rDFSClass) {
        OWLUtil.removeRDFType(this, rDFSClass);
    }

    public void removeResourceListener(ResourceListener resourceListener) {
        OWLUtil.removeResourceListener(this, resourceListener);
    }

    public void removeSameAs(RDFResource rDFResource) {
        OWLUtil.removeSameAs(this, rDFResource);
    }

    public void removeVersionInfo(String string) {
        OWLUtil.removeVersionInfo(this, string);
    }

    public void setComment(String string) {
        OWLUtil.setComment(this, string);
    }

    public void setComments(Collection collection) {
        OWLUtil.setComments(this, collection);
    }

    public void setDocumentation(String string) {
        OWLUtil.setComment(this, string);
    }

    public void setInferredTypes(Collection collection) {
        OWLUtil.setInferredTypes(this, collection);
    }

    public void setPropertyValue(RDFProperty rDFProperty, Object object) {
        OWLUtil.setPropertyValue(this, rDFProperty, object);
    }

    public void setPropertyValues(RDFProperty rDFProperty, Collection collection) {
        OWLUtil.setPropertyValues(this, rDFProperty, collection);
    }

    public void setProtegeType(RDFSClass rDFSClass) {
        OWLUtil.setProtegeType(this, rDFSClass);
    }

    public void setRDFType(RDFSClass rDFSClass) {
        OWLUtil.setRDFType(this, rDFSClass);
    }

    public void setRDFTypes(Collection collection) {
        OWLUtil.setRDFTypes(this, collection);
    }

    public void setProtegeTypes(Collection collection) {
        OWLUtil.setProtegeTypes(this, collection);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getSimpleName());
        stringBuffer.append("(");
        stringBuffer.append(this.getName());
        stringBuffer.append(", ");
        stringBuffer.append(this.getFrameID());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setDirectBrowserSlotPattern(BrowserSlotPattern browserSlotPattern) {
        if (browserSlotPattern != null && !(browserSlotPattern instanceof OWLBrowserSlotPattern)) {
            browserSlotPattern = new OWLBrowserSlotPattern(browserSlotPattern.getElements());
        }
        this.getDefaultKnowledgeBase().setDirectBrowserSlotPattern((Cls)this, browserSlotPattern);
    }

    public OWLBrowserSlotPattern getBrowserSlotPattern() {
        BrowserSlotPattern browserSlotPattern = super.getBrowserSlotPattern();
        if (browserSlotPattern instanceof OWLBrowserSlotPattern) {
            return (OWLBrowserSlotPattern)browserSlotPattern;
        }
        return new OWLBrowserSlotPattern(browserSlotPattern);
    }
}

