/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.EventDispatchFrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStoreAdapter;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocalClassificationFrameStore
extends FrameStoreAdapter {
    private OWLModel owlModel;
    private Map<Slot, Map<Frame, List>> slotsMap = new HashMap<Slot, Map<Frame, List>>();

    public LocalClassificationFrameStore(OWLModel oWLModel) {
        this.owlModel = oWLModel;
        this.slotsMap.put(oWLModel.getRDFProperty(ProtegeNames.Slot.CLASSIFICATION_STATUS), new HashMap());
        this.slotsMap.put(oWLModel.getRDFProperty(ProtegeNames.Slot.INFERRED_TYPE), new HashMap());
        this.slotsMap.put(oWLModel.getRDFProperty(ProtegeNames.Slot.INFERRED_SUBCLASSES), new HashMap());
        this.slotsMap.put(oWLModel.getRDFProperty(ProtegeNames.Slot.INFERRED_SUPERCLASSES), new HashMap());
    }

    public void deleteCls(Cls cls) {
        for (Slot slot : this.slotsMap.keySet()) {
            Map<Frame, List> map = this.slotsMap.get(slot);
            map.remove(cls);
            for (Frame frame : new ArrayList<Frame>(map.keySet())) {
                Collection collection = map.get(frame);
                if (!collection.contains(cls)) continue;
                ArrayList arrayList = new ArrayList(collection);
                arrayList.remove(cls);
                frame.setDirectOwnSlotValues(slot, arrayList);
            }
        }
        super.deleteCls(cls);
    }

    private void dispatchEvent(Frame frame, Slot slot) {
        EventDispatchFrameStore eventDispatchFrameStore = this.getEventDispatchFrameStore();
        ArrayList arrayList = new ArrayList(eventDispatchFrameStore.getListeners(FrameListener.class, (Object)frame));
        for (FrameListener frameListener : arrayList) {
            frameListener.ownSlotValueChanged(new FrameEvent(frame, 110, (Object)slot));
        }
    }

    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        Map<Frame, List> map = this.slotsMap.get(slot);
        if (map != null) {
            List list = map.get(frame);
            if (list == null) {
                return Collections.EMPTY_LIST;
            }
            return list;
        }
        return super.getDirectOwnSlotValues(frame, slot);
    }

    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        Map<Frame, List> map = this.slotsMap.get(slot);
        if (map != null) {
            return this.getDirectOwnSlotValues(frame, slot).size();
        }
        return super.getDirectOwnSlotValuesCount(frame, slot);
    }

    private EventDispatchFrameStore getEventDispatchFrameStore() {
        for (FrameStore frameStore : this.owlModel.getFrameStores()) {
            if (!(frameStore instanceof EventDispatchFrameStore)) continue;
            return (EventDispatchFrameStore)frameStore;
        }
        return null;
    }

    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        Map<Frame, List> map = this.slotsMap.get(slot);
        if (map != null) {
            HashSet<Frame> hashSet = new HashSet<Frame>();
            for (Frame frame : map.keySet()) {
                Collection collection = map.get(frame);
                if (collection == null || !collection.contains(object)) continue;
                hashSet.add(frame);
            }
            return hashSet;
        }
        return super.getFramesWithDirectOwnSlotValue(slot, object);
    }

    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        Map<Frame, List> map = this.slotsMap.get(slot);
        if (map != null) {
            if (collection.isEmpty()) {
                map.remove(frame);
            } else {
                map.put(frame, new ArrayList(collection));
            }
        } else {
            super.setDirectOwnSlotValues(frame, slot, collection);
        }
    }
}

