/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.framestore;

import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.framestore.AbstractRestrictionUpdater;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import java.util.Collection;
import java.util.Collections;

class HasValueRestrictionUpdater
extends AbstractRestrictionUpdater {
    private Facet valuesFacet;

    HasValueRestrictionUpdater(AbstractOWLModel abstractOWLModel) {
        super(abstractOWLModel);
        this.valuesFacet = abstractOWLModel.getFacet(":VALUES");
    }

    public void copyFacetValuesIntoNamedClass(RDFSNamedClass rDFSNamedClass, OWLRestriction oWLRestriction) {
        RDFProperty rDFProperty = oWLRestriction.getOnProperty();
        if (rDFProperty != null) {
            this.updateValuesFacet(rDFSNamedClass, rDFProperty);
        }
    }

    public void updateRestrictions(OWLNamedClass oWLNamedClass, RDFProperty rDFProperty, Facet facet) {
        this.removeRestrictions(oWLNamedClass, rDFProperty, this.owlModel.getCls("owl:HasValueRestriction"));
        if (oWLNamedClass.hasDirectlyOverriddenTemplateFacet(rDFProperty, this.valuesFacet)) {
            Collection collection = oWLNamedClass.getTemplateSlotValues(rDFProperty);
            for (Object e : collection) {
                OWLHasValue oWLHasValue = this.owlModel.createOWLHasValue(rDFProperty, e);
                oWLNamedClass.addSuperclass(oWLHasValue);
                this.log("+ OWLHasValue " + oWLHasValue.getBrowserText() + " to " + oWLNamedClass.getName() + "." + rDFProperty.getName());
            }
        }
    }

    void updateValuesFacet(RDFSNamedClass rDFSNamedClass, Slot slot) {
        rDFSNamedClass.setTemplateFacetValues(slot, this.valuesFacet, Collections.EMPTY_LIST);
        this.log("- :VALUES override from " + rDFSNamedClass.getName() + "." + slot.getName());
        for (OWLHasValue oWLHasValue : this.getDirectRestrictions(rDFSNamedClass, slot, OWLHasValue.class)) {
            Object object;
            if (oWLHasValue == null || (object = oWLHasValue.getHasValue()) == null) continue;
            if (object instanceof RDFSLiteral) {
                object = object.toString();
            }
            rDFSNamedClass.addTemplateFacetValue(slot, this.valuesFacet, object);
        }
    }
}

