/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class OWLJavaFactoryUpdater {
    private int count = 0;
    private Set metaclasses = new HashSet();
    private Set metaslots = new HashSet();
    private MergingNarrowFrameStore mnfs;

    public OWLJavaFactoryUpdater(KnowledgeBase knowledgeBase) {
        this(knowledgeBase, knowledgeBase.getFrames());
    }

    public OWLJavaFactoryUpdater(KnowledgeBase knowledgeBase, Collection collection) {
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)knowledgeBase);
        this.findMetaclasses(knowledgeBase);
        Instance instance = null;
        try {
            int n = 0;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ++n;
                instance = (Instance)iterator.next();
                Instance instance2 = this.createNewFrame(instance);
                if (instance.getClass() == instance2.getClass()) continue;
                this.mnfs.replaceFrame((Frame)instance2);
            }
        }
        catch (ClassCastException classCastException) {
            Collection collection2 = instance.getDirectTypes();
            for (Instance instance3 : collection2) {
                if (instance3 instanceof Cls) continue;
                throw new ProtegeOWLParserException("The resource " + instance.getName() + " has the rdf:type " + instance3.getName() + " which is not a class but a " + instance3.getClass().getName(), "In many cases the problem is a missing owl:imports statement to the classes file which defines the correct type of " + instance3.getName());
            }
            Log.getLogger().log(Level.SEVERE, "Exception caught", classCastException);
            throw new RuntimeException("Failed to convert type of " + instance);
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            throw new RuntimeException("Failed to convert type of " + instance);
        }
        knowledgeBase.flushCache();
    }

    public Instance createNewFrame(Instance instance) {
        if (this.isCls(instance)) {
            return instance.getKnowledgeBase().getFrameFactory().createCls(instance.getFrameID(), instance.getDirectTypes());
        }
        if (this.isSlot(instance)) {
            return instance.getKnowledgeBase().getFrameFactory().createSlot(instance.getFrameID(), instance.getDirectTypes());
        }
        if (!(instance instanceof Facet)) {
            return instance.getKnowledgeBase().getFrameFactory().createSimpleInstance(instance.getFrameID(), instance.getDirectTypes());
        }
        return instance;
    }

    private void findMetaclasses(KnowledgeBase knowledgeBase) {
        this.findSubclasses(this.metaclasses, (Frame)knowledgeBase.getCls(":CLASS"));
        this.findSubclasses(this.metaslots, (Frame)knowledgeBase.getCls(":SLOT"));
    }

    private void findSubclasses(Set set, Frame frame) {
        set.add(frame);
        Slot slot = frame.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        List list = this.mnfs.getValues(frame, slot, null, false);
        for (Frame frame2 : list) {
            if (set.contains(frame2)) continue;
            this.findSubclasses(set, frame2);
        }
    }

    private boolean isCls(Instance instance) {
        Collection collection = instance.getDirectTypes();
        for (Instance instance2 : collection) {
            if (instance2.equals(instance)) {
                if (this.metaclasses.contains(instance2)) {
                    return true;
                }
                this.metaclasses.add(instance2);
                this.updateFrame(instance2);
            }
            if (!(instance2 instanceof Cls)) {
                this.updateFrame(instance2);
            }
            if (!this.metaclasses.contains(instance2)) continue;
            return true;
        }
        return false;
    }

    private boolean isSlot(Instance instance) {
        Collection collection = instance.getDirectTypes();
        for (Instance instance2 : collection) {
            if (!this.metaslots.contains(instance2)) continue;
            return true;
        }
        return false;
    }

    private void log(String string) {
        System.out.println("[OWLJavaFactoryUpdater] " + string);
    }

    public void updateFrame(Instance instance) {
        Instance instance2 = this.createNewFrame(instance);
        if (instance.getClass() != instance2.getClass()) {
            this.mnfs.replaceFrame((Frame)instance2);
        }
    }

    public static void run(Instance instance) {
        OWLJavaFactoryUpdater.run(instance.getKnowledgeBase(), Collections.singleton(instance));
    }

    public static void run(KnowledgeBase knowledgeBase, Collection collection) {
        new OWLJavaFactoryUpdater(knowledgeBase, collection);
    }

    public static void run(JenaOWLModel jenaOWLModel) {
        new OWLJavaFactoryUpdater(jenaOWLModel);
    }

    public static void run(OWLDatabaseModel oWLDatabaseModel) {
        new OWLJavaFactoryUpdater(oWLDatabaseModel);
    }
}

