/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.ontology.OntModel;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.KnowledgeBaseSourcesEditor;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.ClientInitializerKnowledgeBaseFactory;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.URIUtilities;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseSourcesEditor;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.triplestore.JenaTripleStoreModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.repository.util.RepositoryFileManager;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.storage.ProtegeSaver;
import edu.stanford.smi.protegex.owl.ui.ProgressDisplayDialog;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.logging.Level;

public class JenaKnowledgeBaseFactory
implements OWLKnowledgeBaseFactory,
ClientInitializerKnowledgeBaseFactory {
    public static final String JENA_SYNCHRONIZED = JenaKnowledgeBaseFactory.class.getName() + ".synchronized";
    public static final String OWL_FILE_URI_PROPERTY = "owl_file_name";
    public static final String OWL_FILE_LANGUAGE_PROPERTY = "owl_file_language";
    public static final String OWL_BUILD_PROPERTY = "owl_build";
    public static final String[] fileLanguages = new String[]{"RDF/XML-ABBREV", "RDF/XML", "N-TRIPLE", "N3", "TURTLE"};
    static final String[] extensions = new String[]{"owl", "rdf-xml.owl", "ntriple.owl", "n3.owl", "turtle.owl"};
    public static boolean useStandalone = true;

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        boolean bl = ProjectManager.getProjectManager().getCurrentProjectView() != null;
        useStandalone = !bl;
        OWLNamespaceManager oWLNamespaceManager = new OWLNamespaceManager();
        ResourceSelectionAction.setActivated(true);
        JenaOWLModel jenaOWLModel = new JenaOWLModel(this, oWLNamespaceManager);
        jenaOWLModel.getRepositoryManager().addDefaultRepositories();
        if (bl) {
            jenaOWLModel.getTaskManager().setProgressDisplay(new ProgressDisplayDialog());
        }
        return jenaOWLModel;
    }

    public KnowledgeBaseSourcesEditor createKnowledgeBaseSourcesEditor(String string, PropertyList propertyList) {
        if (string != null && string.startsWith("http://")) {
            int n = string.lastIndexOf(47);
            string = new File(string.substring(n + 1)).toURI().toString();
        }
        return new JenaKnowledgeBaseSourcesEditor(string, propertyList);
    }

    protected URI getFileURI(PropertyList propertyList, Project project) {
        try {
            String string = JenaKnowledgeBaseFactory.getOWLFilePath(propertyList);
            if (string.startsWith("http://")) {
                return new URI(string);
            }
            URI uRI = project.getProjectURI();
            if (uRI == null) {
                return new URI(string);
            }
            URI uRI2 = project.getProjectDirectoryURI();
            URI uRI3 = URIUtilities.relativize((URI)uRI2, (URI)new URI(string));
            URI uRI4 = uRI.resolve(uRI3);
            return uRI4;
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
            return null;
        }
    }

    public static String getExtension(String string) {
        for (int i = 0; i < fileLanguages.length; ++i) {
            String string2 = fileLanguages[i];
            if (!string2.equals(string)) continue;
            return extensions[i];
        }
        return null;
    }

    protected static String getOWLFileLanguage(PropertyList propertyList) {
        String string = propertyList.getString(OWL_FILE_LANGUAGE_PROPERTY);
        return string == null ? fileLanguages[0] : string;
    }

    public static String getOWLFilePath(PropertyList propertyList) {
        return propertyList.getString(OWL_FILE_URI_PROPERTY);
    }

    public String getDescription() {
        return "OWL / RDF Files";
    }

    public String getProjectFilePath() {
        return useStandalone ? "OWL-min.pprj" : "OWL.pprj";
    }

    public void includeKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        this.loadKnowledgeBase(knowledgeBase, propertyList, collection);
    }

    public boolean isComplete(PropertyList propertyList) {
        return true;
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = JenaKnowledgeBaseFactory.getOWLFileLanguage(propertyList);
        if (knowledgeBase instanceof JenaOWLModel) {
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
            JenaKnowledgeBaseFactory.setOWLFileName(propertyList, uRI.toString());
            this.loadRepositories(jenaOWLModel, uRI);
            jenaOWLModel.load(uRI, string, collection);
        } else {
            String string2 = "This plugin can currently only load OWL files into OWL projects";
            collection.add(new MessageError(string2));
            Log.getLogger().severe(string2);
        }
    }

    private void loadRepositories(OWLModel oWLModel, URI uRI) {
        RepositoryFileManager repositoryFileManager = new RepositoryFileManager(oWLModel);
        repositoryFileManager.loadProjectRepositories();
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        String string = JenaKnowledgeBaseFactory.getOWLFileLanguage(propertyList);
        if (knowledgeBase instanceof JenaOWLModel) {
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            propertyList.setInteger(OWL_BUILD_PROPERTY, OWLText.getBuildNumber());
            URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
            jenaOWLModel.save(uRI, string, collection);
            this.makeOWLFileNameRelativeIfPossible(jenaOWLModel.getProject());
            ApplicationProperties.addProjectToMRUList((URI)jenaOWLModel.getProject().getProjectURI());
        } else {
            Project project = Project.createNewProject((KnowledgeBaseFactory)this, (Collection)collection);
            project.setProjectURI(knowledgeBase.getProject().getProjectURI());
            JenaOWLModel jenaOWLModel = (JenaOWLModel)project.getKnowledgeBase();
            if (knowledgeBase instanceof OWLDatabaseModel) {
                OntModel ontModel = ((OWLDatabaseModel)knowledgeBase).getOntModel();
                URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
                jenaOWLModel.save(uRI, string, collection, ontModel);
            } else {
                new ProtegeSaver(knowledgeBase, jenaOWLModel).run();
                URI uRI = this.getFileURI(propertyList, jenaOWLModel.getProject());
                jenaOWLModel.save(uRI, string, collection);
            }
        }
    }

    protected void makeOWLFileNameRelativeIfPossible(Project project) {
        String string = JenaKnowledgeBaseFactory.getOWLFilePath(project.getSources());
        URI uRI = project.getProjectDirectoryURI();
        if (uRI != null && uRI.toString().startsWith("file:")) {
            try {
                URI uRI2 = new URI(string);
                File file = new File(uRI2);
                if (file.isAbsolute()) {
                    File file2 = new File(uRI);
                    File file3 = file.getParentFile();
                    if (file3.toString().equals(file2.toString())) {
                        String string2 = file.getName();
                        JenaKnowledgeBaseFactory.setOWLFileName(project.getSources(), string2);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setOWLFileLanguage(PropertyList propertyList, String string) {
        propertyList.setString(OWL_FILE_LANGUAGE_PROPERTY, string);
    }

    public static void setOWLFileName(PropertyList propertyList, String string) {
        if (string.indexOf(".") < 0) {
            string = string + ".owl";
        }
        propertyList.setString(OWL_FILE_URI_PROPERTY, string);
    }

    public void initializeClientKnowledgeBase(FrameStore frameStore, NarrowFrameStore narrowFrameStore, NarrowFrameStore narrowFrameStore2, KnowledgeBase knowledgeBase) {
        if (knowledgeBase instanceof OWLModel) {
            JenaOWLModel jenaOWLModel = (JenaOWLModel)knowledgeBase;
            JenaTripleStoreModel jenaTripleStoreModel = new JenaTripleStoreModel(jenaOWLModel, narrowFrameStore2);
            jenaOWLModel.setTripleStoreModel(jenaTripleStoreModel);
        }
    }
}

