/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DataRange;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaNormalizer;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JenaDLConverter {
    private OntModel ontModel;

    public JenaDLConverter(OntModel ontModel, NamespaceManager namespaceManager) {
        this.ontModel = Jena.cloneOntModel(ontModel);
        new JenaNormalizer(this.ontModel, null, namespaceManager);
    }

    private void addSubClasses(Collection collection, OntClass ontClass) {
        if (!collection.contains(ontClass)) {
            collection.add(ontClass);
            ExtendedIterator extendedIterator = ontClass.listSubClasses();
            while (extendedIterator.hasNext()) {
                OntClass ontClass2 = (OntClass)extendedIterator.next();
                this.addSubClasses(collection, ontClass2);
            }
        }
    }

    private void convertAnnotationProperties() {
        for (AnnotationProperty annotationProperty : Jena.set((Iterator)this.ontModel.listAnnotationProperties())) {
            this.removeRDFTypesFromAnnotationProperty(annotationProperty);
            this.removeDomainFromAnnotationProperty(annotationProperty);
            this.removeRangeFromAnnotationProperty(annotationProperty);
        }
    }

    private void convertClassProperties() {
        this.convertClassProperties(OWL.Class);
        this.convertClassProperties(OWL.DatatypeProperty);
        this.convertClassProperties(OWL.ObjectProperty);
    }

    private void convertClassProperties(Resource resource) {
        ExtendedIterator extendedIterator = this.ontModel.listObjectProperties();
        while (extendedIterator.hasNext()) {
            ObjectProperty objectProperty = (ObjectProperty)extendedIterator.next();
            if (!Jena.set((Iterator)objectProperty.listRange()).contains(resource)) continue;
            objectProperty.removeRange(resource);
            this.log("- Removed " + resource + " from range of property " + objectProperty);
        }
    }

    public OntModel convertOntModel() {
        this.convertAnnotationProperties();
        this.convertMetaclasses();
        this.convertClassProperties();
        this.removeFullPropertyValues();
        this.removeAnnotationsFromAnonymousClasses();
        return this.ontModel;
    }

    private void convertMetaclasses() {
        this.convertMetaclasses(OWL.Class);
        this.convertMetaclasses(OWL.DatatypeProperty);
        this.convertMetaclasses(OWL.ObjectProperty);
    }

    private void convertMetaclasses(Resource resource) {
        HashSet hashSet = new HashSet();
        ExtendedIterator extendedIterator = this.ontModel.listNamedClasses();
        while (extendedIterator.hasNext()) {
            OntClass ontClass = (OntClass)extendedIterator.next();
            if (!ontClass.hasSuperClass(resource)) continue;
            this.addSubClasses(hashSet, ontClass);
        }
        for (OntClass ontClass : Jena.set((Iterator)this.ontModel.listIndividuals())) {
            if (!hashSet.contains(ontClass.getRDFType(true))) continue;
            ontClass.setRDFType(resource);
            this.log("* Set RDF type of class " + ontClass + " to " + resource);
            this.removeFullPropertyValues((Resource)ontClass);
        }
        for (OntClass ontClass : hashSet) {
            ontClass.remove();
            this.log("- Removed metaclass " + ontClass);
        }
    }

    private void log(String string) {
        System.out.println("[JenaDLConverter] " + string);
    }

    private void removeAnnotationsFromAnonymousClasses() {
        Set set = Jena.set((Iterator)this.ontModel.listAnnotationProperties());
        set.add(RDFS.seeAlso);
        set.add(RDFS.isDefinedBy);
        set.add(OWL.versionInfo);
        ExtendedIterator extendedIterator = this.ontModel.listClasses();
        while (extendedIterator.hasNext()) {
            OntClass ontClass = (OntClass)extendedIterator.next();
            if (!ontClass.isAnon()) continue;
            for (Property property : set) {
                ontClass.removeAll(property);
            }
        }
    }

    private void removeDomainFromAnnotationProperty(AnnotationProperty annotationProperty) {
        Property property = RDFS.domain;
        StmtIterator stmtIterator = annotationProperty.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            this.log("- Removing domain " + statement.getObject() + " from annotation property " + annotationProperty);
            stmtIterator.remove();
        }
    }

    private void removeFullPropertyValues() {
        this.removeFullPropertyValues((Iterator)this.ontModel.listNamedClasses());
        this.removeFullPropertyValues((Iterator)this.ontModel.listDatatypeProperties());
        this.removeFullPropertyValues((Iterator)this.ontModel.listObjectProperties());
        this.removeFullPropertyValues((Iterator)this.ontModel.listAnnotationProperties());
    }

    private void removeFullPropertyValues(Iterator iterator) {
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            this.removeFullPropertyValues(resource);
        }
    }

    private void removeFullPropertyValues(Resource resource) {
        for (Statement statement : Jena.set((Iterator)resource.listProperties())) {
            String string;
            Property property = statement.getPredicate();
            if (property.hasProperty(RDF.type, (RDFNode)OWL.AnnotationProperty) || (string = property.getNameSpace()).equals(OWL.getURI()) || string.equals(RDF.getURI()) || string.equals(RDFS.getURI())) continue;
            this.log("- Removed OWL Full property value " + statement);
            statement.remove();
        }
    }

    private void removeProtegeOntology() {
        boolean bl = false;
        ExtendedIterator extendedIterator = this.ontModel.listOntologies();
        while (extendedIterator.hasNext()) {
            Resource resource;
            Ontology ontology = (Ontology)extendedIterator.next();
            if (!ontology.hasProperty(OWL.imports, (RDFNode)(resource = this.ontModel.getResource(ProtegeNames.FILE)))) continue;
            ontology.removeImport(resource);
            this.log("- Removed import of " + resource + " from ontology " + ontology);
            bl = true;
        }
        if (bl) {
            this.ontModel = Jena.cloneOntModel(this.ontModel);
        }
    }

    private void removeRangeFromAnnotationProperty(AnnotationProperty annotationProperty) {
        Property property = RDFS.range;
        StmtIterator stmtIterator = annotationProperty.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            this.log("- Removing range " + statement.getObject() + " from annotation property " + annotationProperty);
            RDFNode rDFNode = statement.getObject();
            stmtIterator.remove();
            if (!rDFNode.canAs(DataRange.class)) continue;
            this.log("- Removing DataRange " + rDFNode);
            ((DataRange)rDFNode.as(DataRange.class)).remove();
        }
    }

    private void removeRDFTypesFromAnnotationProperty(AnnotationProperty annotationProperty) {
        Property property = RDF.type;
        StmtIterator stmtIterator = annotationProperty.listProperties(property);
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            Resource resource = (Resource)statement.getObject();
            if (resource.equals(OWL.AnnotationProperty)) continue;
            this.log("- Removing type " + resource + " from annotation property " + annotationProperty);
            stmtIterator.remove();
        }
    }
}

