/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protegex.owl.javacode.RDFSClassCode;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;

public class RDFPropertyAtClassCode
implements Comparable {
    private RDFSNamedClass cls;
    private RDFProperty property;
    private boolean usePrefix;

    public RDFPropertyAtClassCode(RDFSNamedClass rDFSNamedClass, RDFProperty rDFProperty, boolean bl) {
        this.cls = rDFSNamedClass;
        this.property = rDFProperty;
        this.usePrefix = bl;
    }

    public int compareTo(Object object) {
        if (object instanceof RDFPropertyAtClassCode) {
            RDFPropertyAtClassCode rDFPropertyAtClassCode = (RDFPropertyAtClassCode)object;
            return this.getJavaName().compareTo(rDFPropertyAtClassCode.getJavaName());
        }
        return 0;
    }

    public String getJavaName() {
        String string = this.property.getNamespacePrefix();
        if (this.usePrefix && string != null && !string.equals("")) {
            string = string.toUpperCase() + "_";
            return RDFSClassCode.getValidJavaName(string + this.property.getLocalName());
        }
        return RDFSClassCode.getValidJavaName(this.property.getLocalName());
    }

    public String getJavaType() {
        RDFResource rDFResource = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        if (rDFResource instanceof OWLDataRange) {
            rDFResource = ((OWLDataRange)rDFResource).getRDFDatatype();
        }
        if (rDFResource instanceof RDFSDatatype) {
            OWLModel oWLModel = this.cls.getOWLModel();
            if (oWLModel.getXSDboolean().equals(rDFResource)) {
                return "boolean";
            }
            if (oWLModel.getXSDfloat().equals(rDFResource)) {
                return "float";
            }
            if (oWLModel.getXSDint().equals(rDFResource)) {
                return "int";
            }
            if (oWLModel.getXSDstring().equals(rDFResource)) {
                return "String";
            }
            return "RDFSLiteral";
        }
        if (rDFResource instanceof RDFSNamedClass) {
            return new RDFSClassCode((RDFSNamedClass)rDFResource, this.usePrefix).getJavaName();
        }
        if (rDFResource instanceof OWLAnonymousClass) {
            RDFResource rDFResource2 = this.property.getRange();
            if (rDFResource2 != null && rDFResource2 instanceof RDFSNamedClass) {
                return new RDFSClassCode((RDFSNamedClass)rDFResource2, this.usePrefix).getJavaName();
            }
            return "Object";
        }
        return "Object";
    }

    public RDFProperty getRDFProperty() {
        return this.property;
    }

    public String getUpperCaseJavaName() {
        String string = this.getJavaName();
        if (string.length() > 1) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string.toUpperCase();
    }

    public boolean isCustomType() {
        RDFResource rDFResource = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        return rDFResource instanceof RDFSNamedClass;
    }

    public boolean isMultiple() {
        if (this.cls instanceof OWLNamedClass) {
            int n = ((OWLNamedClass)this.cls).getMaxCardinality(this.property);
            return n < 0 || n > 1;
        }
        return !this.property.isFunctional();
    }

    public boolean isPrimitive() {
        OWLModel oWLModel;
        RDFResource rDFResource = ((OWLNamedClass)this.cls).getAllValuesFrom(this.property);
        return rDFResource instanceof RDFSDatatype && ((oWLModel = this.cls.getOWLModel()).getXSDboolean().equals(rDFResource) || oWLModel.getXSDfloat().equals(rDFResource) || oWLModel.getXSDint().equals(rDFResource));
    }
}

