/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.util;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerManager;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.factory.SWRLJavaFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReasonerUtil
implements Disposable {
    private static ReasonerUtil instance;
    private Map<OWLModel, Collection<RDFSClass>> namedClsesMap;
    private Map<OWLModel, Collection<OWLDatatypeProperty>> datatypePropertiesMap;
    private Map<OWLModel, Collection<OWLObjectProperty>> objectPropertiesMap;
    private Map<OWLModel, Collection<RDFIndividual>> individualsMap;
    private Set<OWLModel> owlModelsWithListener;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            ReasonerUtil.this.dispose((OWLModel)project.getKnowledgeBase());
        }
    };
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass rDFSClass) {
            ReasonerUtil.this.invalidateNamedClsCache(rDFSClass.getOWLModel());
        }

        public void classDeleted(RDFSClass rDFSClass) {
            ReasonerUtil.this.invalidateNamedClsCache(rDFSClass.getOWLModel());
        }

        public void propertyCreated(RDFProperty rDFProperty) {
            ReasonerUtil.this.invalidatePropertiesCache(rDFProperty.getOWLModel());
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            ReasonerUtil.this.invalidatePropertiesCache(rDFProperty.getOWLModel());
        }

        public void individualCreated(RDFResource rDFResource) {
            ReasonerUtil.this.invalidateIndividualsCache(rDFResource.getOWLModel());
        }

        public void individualDeleted(RDFResource rDFResource) {
            ReasonerUtil.this.invalidateIndividualsCache(rDFResource.getOWLModel());
        }
    };
    private long lastClassificationTime;

    protected ReasonerUtil() {
        this.initHashMaps();
        this.lastClassificationTime = 0L;
    }

    public static synchronized ReasonerUtil getInstance() {
        if (instance == null) {
            instance = new ReasonerUtil();
        }
        return instance;
    }

    private void initHashMaps() {
        this.namedClsesMap = new HashMap<OWLModel, Collection<RDFSClass>>();
        this.datatypePropertiesMap = new HashMap<OWLModel, Collection<OWLDatatypeProperty>>();
        this.objectPropertiesMap = new HashMap<OWLModel, Collection<OWLObjectProperty>>();
        this.individualsMap = new HashMap<OWLModel, Collection<RDFIndividual>>();
        this.owlModelsWithListener = new HashSet<OWLModel>();
    }

    public Collection getNamedClses(OWLModel oWLModel) {
        Collection collection;
        if (!this.namedClsesMap.containsKey(oWLModel)) {
            this.namedClsesMap.put(oWLModel, this.getFilteredNamedClasses(oWLModel));
            this.addListeners(oWLModel);
        }
        if ((collection = this.namedClsesMap.get(oWLModel)) == null) {
            collection = this.getFilteredNamedClasses(oWLModel);
            this.namedClsesMap.put(oWLModel, collection);
        }
        return collection;
    }

    private Collection getFilteredNamedClasses(OWLModel oWLModel) {
        Collection collection = oWLModel.getUserDefinedOWLNamedClasses();
        try {
            if (oWLModel.getOWLJavaFactory() instanceof SWRLJavaFactory) {
                SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
                Collection<RDFSNamedClass> collection2 = sWRLFactory.getSWRLClasses();
                collection.removeAll(collection2);
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at filtering out the SWRL classes from the classes sent to the reasoner", exception);
        }
        return collection;
    }

    public Collection<RDFProperty> getProperties(OWLModel oWLModel) {
        ArrayList<RDFProperty> arrayList = new ArrayList<RDFProperty>();
        arrayList.addAll(this.getDataTypeProperties(oWLModel));
        arrayList.addAll(this.getObjectProperties(oWLModel));
        return arrayList;
    }

    public Collection<OWLDatatypeProperty> getDataTypeProperties(OWLModel oWLModel) {
        Collection<OWLDatatypeProperty> collection;
        if (!this.datatypePropertiesMap.containsKey(oWLModel)) {
            this.datatypePropertiesMap.put(oWLModel, this.getFilteredProperties(oWLModel, oWLModel.getUserDefinedOWLDatatypeProperties()));
            this.addListeners(oWLModel);
        }
        if ((collection = this.datatypePropertiesMap.get(oWLModel)) == null) {
            collection = this.getFilteredProperties(oWLModel, oWLModel.getUserDefinedOWLDatatypeProperties());
            this.datatypePropertiesMap.put(oWLModel, collection);
        }
        return collection;
    }

    public Collection<OWLObjectProperty> getObjectProperties(OWLModel oWLModel) {
        Collection<OWLObjectProperty> collection;
        if (!this.objectPropertiesMap.containsKey(oWLModel)) {
            this.objectPropertiesMap.put(oWLModel, this.getFilteredProperties(oWLModel, oWLModel.getUserDefinedOWLObjectProperties()));
            this.addListeners(oWLModel);
        }
        if ((collection = this.objectPropertiesMap.get(oWLModel)) == null) {
            collection = this.getFilteredProperties(oWLModel, oWLModel.getUserDefinedOWLObjectProperties());
            this.objectPropertiesMap.put(oWLModel, collection);
        }
        return collection;
    }

    private <T> Collection<T> getFilteredProperties(OWLModel oWLModel, Collection<T> collection) {
        ArrayList<T> arrayList = new ArrayList<T>(collection);
        try {
            if (oWLModel.getOWLJavaFactory() instanceof SWRLJavaFactory) {
                SWRLFactory sWRLFactory = new SWRLFactory(oWLModel);
                Collection<RDFProperty> collection2 = sWRLFactory.getSWRLProperties();
                Collection<RDFProperty> collection3 = sWRLFactory.getSWRLBProperties();
                arrayList.removeAll(collection2);
                arrayList.removeAll(collection3);
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at filtering out the SWRL properties from the properties sent to the reasoner", exception);
        }
        return arrayList;
    }

    public Collection getIndividuals(OWLModel oWLModel) {
        Collection collection;
        if (!this.individualsMap.containsKey(oWLModel)) {
            this.individualsMap.put(oWLModel, this.getOWLIndividuals(oWLModel));
            this.addListeners(oWLModel);
        }
        if ((collection = this.individualsMap.get(oWLModel)) == null) {
            collection = this.getOWLIndividuals(oWLModel);
            this.individualsMap.put(oWLModel, collection);
        }
        return collection;
    }

    private Collection getOWLIndividuals(OWLModel oWLModel) {
        IndividualsFilter individualsFilter = new IndividualsFilter(oWLModel);
        return individualsFilter.getOWLIndividuals();
    }

    public void invalidateNamedClsCache(OWLModel oWLModel) {
        this.namedClsesMap.put(oWLModel, null);
    }

    public void invalidatePropertiesCache(OWLModel oWLModel) {
        this.objectPropertiesMap.put(oWLModel, null);
        this.datatypePropertiesMap.put(oWLModel, null);
    }

    public void invalidateIndividualsCache(OWLModel oWLModel) {
        this.individualsMap.put(oWLModel, null);
    }

    public long getLastClassificationTime() {
        return this.lastClassificationTime;
    }

    public void setLastClassificationTime() {
        this.lastClassificationTime = System.currentTimeMillis();
    }

    public OWLNamedClass getNamedReferent(OWLAnonymousClass oWLAnonymousClass) {
        OWLAnonymousClass oWLAnonymousClass2;
        OWLAnonymousClass oWLAnonymousClass3 = oWLAnonymousClass.getExpressionRoot();
        while ((oWLAnonymousClass2 = oWLAnonymousClass3.getExpressionRoot()) != oWLAnonymousClass3) {
            oWLAnonymousClass3 = oWLAnonymousClass2;
        }
        OWLNamedClass oWLNamedClass = null;
        Iterator iterator = oWLAnonymousClass.getNamedSubclasses().iterator();
        if (iterator.hasNext()) {
            oWLNamedClass = (OWLNamedClass)iterator.next();
        }
        return oWLNamedClass;
    }

    private void addListeners(OWLModel oWLModel) {
        if (!this.owlModelsWithListener.contains(oWLModel)) {
            oWLModel.addModelListener(this.modelListener);
            oWLModel.getProject().addProjectListener(this.projectListener);
            this.owlModelsWithListener.add(oWLModel);
        }
    }

    private void removeListeners(OWLModel oWLModel) {
        if (this.owlModelsWithListener.contains(oWLModel)) {
            oWLModel.removeModelListener(this.modelListener);
            oWLModel.getProject().removeProjectListener(this.projectListener);
            this.owlModelsWithListener.remove(oWLModel);
        }
    }

    private void dispose(OWLModel oWLModel) {
        this.namedClsesMap.remove(oWLModel);
        this.datatypePropertiesMap.remove(oWLModel);
        this.objectPropertiesMap.remove(oWLModel);
        this.individualsMap.remove(oWLModel);
        this.removeListeners(oWLModel);
    }

    public void dispose() {
        for (OWLModel oWLModel : this.owlModelsWithListener) {
            this.dispose(oWLModel);
        }
        this.namedClsesMap.clear();
        this.datatypePropertiesMap.clear();
        this.objectPropertiesMap.clear();
        this.individualsMap.clear();
        this.owlModelsWithListener.clear();
    }

    public static void handleOutOfMemory() {
        ReasonerManager.getInstance().dispose();
        System.gc();
        System.runFinalization();
        System.gc();
    }

    private class IndividualsFilter
    extends OWLModelVisitorAdapter {
        private Collection individuals;
        private OWLModel model;

        public IndividualsFilter(OWLModel oWLModel) {
            this.model = oWLModel;
        }

        public Collection getOWLIndividuals() {
            this.individuals = new ArrayList();
            for (RDFResource rDFResource : this.model.getOWLIndividuals()) {
                rDFResource.accept(this);
            }
            return this.individuals;
        }

        public void visitOWLIndividual(OWLIndividual oWLIndividual) {
            this.individuals.add(oWLIndividual);
        }

        public void visitSWRLIndividual(SWRLIndividual sWRLIndividual) {
        }

        public void visitSWRLAtomListIndividual(SWRLAtomList sWRLAtomList) {
        }
    }
}

