/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.util;

import edu.stanford.smi.protege.util.ApplicationProperties;

public class ReasonerPreferences {
    public static final String DEFAULT_REASONER_URL = "http://localhost:8080";
    public static final String REASONER_URL_KEY = "edu.stanford.smi.protegex.owl.jena.reasoner.URL";
    private static ReasonerPreferences instance;
    private boolean warningsAsErrors = false;
    private boolean showWarningResultsPanel = true;
    private boolean showReasonerResultsPanel = true;
    private boolean automaticallyShowInferredHierarchy = true;

    protected ReasonerPreferences() {
    }

    public static synchronized ReasonerPreferences getInstance() {
        if (instance == null) {
            instance = new ReasonerPreferences();
        }
        return instance;
    }

    public String getReasonerURL() {
        String string = ApplicationProperties.getString((String)REASONER_URL_KEY, (String)this.getDefaultReasonerURL());
        if (string == null || string.equals("")) {
            string = DEFAULT_REASONER_URL;
            ApplicationProperties.setString((String)REASONER_URL_KEY, (String)DEFAULT_REASONER_URL);
        }
        return string;
    }

    public String getDefaultReasonerURL() {
        return DEFAULT_REASONER_URL;
    }

    public void setReasonerURL(String string) {
        ApplicationProperties.setString((String)REASONER_URL_KEY, (String)string);
    }

    public boolean isWarningAsErrors() {
        return this.warningsAsErrors;
    }

    public void setWarningsAsErrors(boolean bl) {
        this.warningsAsErrors = bl;
    }

    public boolean isShowWarningResultsPanel() {
        return this.showWarningResultsPanel;
    }

    public void setShowWarningResultsPanel(boolean bl) {
        this.showWarningResultsPanel = bl;
    }

    public boolean isShowReasonerResultsPanel() {
        return this.showReasonerResultsPanel;
    }

    public void setShowReasonerResultsPanel(boolean bl) {
        this.showReasonerResultsPanel = bl;
    }

    public boolean isAutomaticallyShowInferredHierarchy() {
        return this.automaticallyShowInferredHierarchy;
    }

    public void setAutomaticallyShowInferredHierarchy(boolean bl) {
        this.automaticallyShowInferredHierarchy = bl;
    }
}

