/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.CollectionResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class GetIndividualsBelongingToConceptTask
extends AbstractReasonerTask
implements CollectionResultReasonerTask {
    private OWLClass aClass;
    private ProtegeReasoner protegeReasoner;
    private HashSet individuals;

    public GetIndividualsBelongingToConceptTask(OWLClass oWLClass, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.aClass = oWLClass;
        this.protegeReasoner = protegeReasoner;
        this.individuals = new HashSet();
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Individuals belonging to: " + this.aClass.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        this.setDescription("Computing individuals belonging to class");
        this.setMessage("Querying reasoner...");
        this.individuals.addAll(this.protegeReasoner.getIndividualsBelongingToClass(this.aClass));
        this.setProgress(1);
        Iterator iterator = this.individuals.iterator();
        while (iterator.hasNext()) {
            this.postLogRecord(ReasonerLogRecordFactory.getInstance().createOWLInstanceLogRecord((RDFResource)iterator.next(), reasonerLogRecord));
        }
        this.setTaskCompleted();
    }

    public Collection getResult() {
        return this.individuals;
    }
}

