/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.protegereasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.reasoner.exception.ProtegeReasonerException;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import java.util.Collection;

public class GetIndividualPropertyValuesTask
extends AbstractReasonerTask {
    private OWLIndividual individual;
    private ProtegeReasoner protegeReasoner;

    public GetIndividualPropertyValuesTask(OWLIndividual oWLIndividual, ProtegeReasoner protegeReasoner) {
        super(protegeReasoner);
        this.individual = oWLIndividual;
        this.protegeReasoner = protegeReasoner;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws ProtegeReasonerException {
        ReasonerLogRecordFactory reasonerLogRecordFactory = ReasonerLogRecordFactory.getInstance();
        this.setDescription("Getting properties values for individual");
        this.setProgress(0);
        this.setMessage("Querying reasoner...");
        ReasonerLogRecord reasonerLogRecord = reasonerLogRecordFactory.createInformationMessageLogRecord("Inferred properties values for: " + this.individual.getBrowserText(), null);
        this.postLogRecord(reasonerLogRecord);
        Collection collection = this.individual.getOwnSlots();
        for (Slot slot : collection) {
            ReasonerLogRecord reasonerLogRecord2;
            Collection collection2;
            if (slot.isSystem() || !(slot instanceof RDFProperty)) continue;
            RDFProperty rDFProperty = (RDFProperty)slot;
            if (rDFProperty instanceof OWLObjectProperty) {
                collection2 = this.protegeReasoner.getRelatedIndividuals(this.individual, (OWLObjectProperty)rDFProperty);
                if (collection2 == null || collection2.size() <= 0) continue;
                reasonerLogRecord2 = reasonerLogRecordFactory.createOWLPropertyLogRecord(rDFProperty, reasonerLogRecord);
                this.postLogRecord(reasonerLogRecord2);
                for (OWLIndividual oWLIndividual : collection2) {
                    this.postLogRecord(reasonerLogRecordFactory.createOWLInstanceLogRecord(oWLIndividual, reasonerLogRecord2));
                }
                continue;
            }
            if (!(rDFProperty instanceof OWLDatatypeProperty) || (collection2 = this.protegeReasoner.getRelatedValues(this.individual, (OWLDatatypeProperty)rDFProperty)) == null || collection2.size() <= 0) continue;
            reasonerLogRecord2 = reasonerLogRecordFactory.createOWLPropertyLogRecord(rDFProperty, reasonerLogRecord);
            this.postLogRecord(reasonerLogRecord2);
            for (OWLIndividual oWLIndividual : collection2) {
                String string = oWLIndividual.toString();
                if (oWLIndividual instanceof RDFSLiteral) {
                    string = ((RDFSLiteral)((Object)oWLIndividual)).getBrowserText();
                }
                this.postLogRecord(reasonerLogRecordFactory.createInformationMessageLogRecord(string, reasonerLogRecord2));
            }
        }
        this.setMessage("Finished");
        this.setTaskCompleted();
    }
}

