/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.digreasoner.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import java.util.Iterator;
import org.w3c.dom.Document;

public class UpdateEquivalentClassesTask
extends AbstractReasonerTask {
    private ProtegeOWLReasoner protegeOWLReasoner;

    public UpdateEquivalentClassesTask(ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.protegeOWLReasoner = protegeOWLReasoner;
    }

    public int getTaskSize() {
        return ReasonerUtil.getInstance().getNamedClses(this.protegeOWLReasoner.getKnowledgeBase()).size();
    }

    public void run() throws DIGReasonerException {
        Object object2;
        OWLModel oWLModel = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecord reasonerLogRecord = ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Compute equivalent classes", null);
        this.doAbortCheck();
        this.postLogRecord(reasonerLogRecord);
        TimeDifference timeDifference = new TimeDifference();
        this.setProgress(0);
        this.setDescription("Computing equivalent classes");
        this.setMessage("Building equivalent classes reasoner query...");
        timeDifference.markStart();
        Document document = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        Collection collection = ReasonerUtil.getInstance().getNamedClses(oWLModel);
        for (Object object2 : collection) {
            this.getTranslator().createEquivalentConceptsQuery(document, object2.getName(), (RDFSClass)object2);
        }
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to build query = " + timeDifference, reasonerLogRecord));
        this.doAbortCheck();
        this.setMessage("Querying reasoner...");
        timeDifference.markStart();
        object2 = this.protegeOWLReasoner.getDIGReasoner().performRequest(document);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to query reasoner = " + timeDifference, reasonerLogRecord));
        this.doAbortCheck();
        this.setMessage("Updating Protege-OWL...");
        timeDifference.markStart();
        boolean bl = oWLModel.setGenerateEventsEnabled(false);
        try {
            oWLModel.beginTransaction("Compute and update equivalent classes");
            Iterator iterator = this.getTranslator().getDIGQueryResponseIterator(oWLModel, (Document)object2);
            while (iterator.hasNext()) {
                this.doAbortCheck();
                DIGQueryResponse dIGQueryResponse = (DIGQueryResponse)iterator.next();
                String string = dIGQueryResponse.getID();
                OWLNamedClass oWLNamedClass = oWLModel.getOWLNamedClass(string);
                if (oWLNamedClass != null && oWLNamedClass.isConsistent()) {
                    for (OWLNamedClass oWLNamedClass2 : dIGQueryResponse.getConcepts()) {
                        if (oWLNamedClass2.equals(oWLNamedClass)) continue;
                        if (!oWLNamedClass.getInferredSuperclasses().contains(oWLNamedClass2)) {
                            oWLNamedClass.addInferredSuperclass(oWLNamedClass2);
                        }
                        if (!oWLNamedClass2.getInferredSuperclasses().contains(oWLNamedClass)) {
                            oWLNamedClass2.addInferredSuperclass(oWLNamedClass);
                        }
                        oWLNamedClass.setClassificationStatus(3);
                    }
                }
                this.setProgress(this.getProgress() + 1);
            }
            oWLModel.commitTransaction();
        }
        catch (DIGReasonerException dIGReasonerException) {
            oWLModel.rollbackTransaction();
            throw dIGReasonerException;
        }
        catch (Exception exception) {
            oWLModel.rollbackTransaction();
            Log.getLogger().warning("Exception in transaction. Rollback. Exception: " + exception.getMessage());
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
        oWLModel.setGenerateEventsEnabled(bl);
        timeDifference.markEnd();
        this.postLogRecord(ReasonerLogRecordFactory.getInstance().createInformationMessageLogRecord("Time to update Protege-OWL = " + timeDifference, reasonerLogRecord));
        this.setTaskCompleted();
    }
}

