/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.DefaultProtegeDIGReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ReasonerPluginManager;
import edu.stanford.smi.protegex.owl.inference.reasoner.ProtegeReasoner;
import edu.stanford.smi.protegex.owl.inference.util.DefaultUncaughtExceptionHandler;
import edu.stanford.smi.protegex.owl.inference.util.ReasonerUtil;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ReasonerManager
implements Disposable {
    public static final String CURRENT_REASONER_PROPERTY = "current.reasoner.class.name";
    private Map<OWLModel, ProtegeReasoner> owlModel2reasonerMap;
    private static ReasonerManager instance;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent projectEvent) {
            Project project = (Project)projectEvent.getSource();
            ReasonerManager.this.disposeReasoner((OWLModel)project.getKnowledgeBase());
        }
    };

    private ReasonerManager() {
        this.owlModel2reasonerMap = new HashMap<OWLModel, ProtegeReasoner>();
    }

    private static void initializeUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
    }

    public static synchronized ReasonerManager getInstance() {
        if (instance == null) {
            instance = new ReasonerManager();
        }
        return instance;
    }

    public ProtegeOWLReasoner getReasoner(OWLModel oWLModel) {
        ProtegeReasoner protegeReasoner = this.owlModel2reasonerMap.get(oWLModel);
        if (protegeReasoner == null) {
            return (ProtegeOWLReasoner)((Object)this.getProtegeReasoner(oWLModel, this.getDefaultDIGReasonerClass(), false));
        }
        if (protegeReasoner instanceof ProtegeOWLReasoner) {
            return (ProtegeOWLReasoner)((Object)protegeReasoner);
        }
        return (ProtegeOWLReasoner)((Object)this.replaceReasoner(oWLModel, this.getDefaultDIGReasonerClass()));
    }

    public ProtegeReasoner getProtegeReasoner(OWLModel oWLModel) {
        return this.getProtegeReasoner(oWLModel, this.getDefaultReasonerClass(), false);
    }

    private ProtegeReasoner getProtegeReasoner(OWLModel oWLModel, Class clazz, boolean bl) {
        if (bl) {
            this.disposeReasoner(oWLModel);
        }
        if (clazz == null) {
            return null;
        }
        ProtegeReasoner protegeReasoner = this.owlModel2reasonerMap.get(oWLModel);
        if (protegeReasoner == null) {
            protegeReasoner = this.internalCreateReasoner(oWLModel, clazz);
            this.owlModel2reasonerMap.put(oWLModel, protegeReasoner);
            oWLModel.getProject().addProjectListener(this.projectListener);
        }
        return protegeReasoner;
    }

    private ProtegeReasoner internalCreateReasoner(OWLModel oWLModel, Class clazz) {
        if (clazz == null) {
            return null;
        }
        return ReasonerPluginManager.getReasonerPluginInstance(oWLModel, clazz);
    }

    public ProtegeOWLReasoner getReasoner(OWLModel oWLModel, boolean bl) {
        return this.createReasoner(oWLModel);
    }

    public ProtegeOWLReasoner createReasoner(OWLModel oWLModel) {
        return (ProtegeOWLReasoner)((Object)this.createProtegeReasoner(oWLModel, this.getDefaultDIGReasonerClass()));
    }

    public ProtegeReasoner createProtegeReasoner(OWLModel oWLModel) {
        return this.createProtegeReasoner(oWLModel, this.getDefaultReasonerClass());
    }

    public ProtegeReasoner createProtegeReasoner(OWLModel oWLModel, Class clazz) {
        return this.getProtegeReasoner(oWLModel, clazz, true);
    }

    public String getDefaultReasonerClassName() {
        String string = ApplicationProperties.getString((String)CURRENT_REASONER_PROPERTY, (String)this.getDefaultDIGReasonerClass().getName());
        if (string.equals("None")) {
            return "None";
        }
        Class<? extends ProtegeReasoner> clazz = ReasonerPluginManager.getReasonerJavaClass(string);
        if (clazz == null) {
            string = this.getDefaultDIGReasonerClass().getName();
        }
        return string;
    }

    public Class getDefaultReasonerClass() {
        return ReasonerPluginManager.getReasonerJavaClass(this.getDefaultReasonerClassName());
    }

    public void setDefaultReasonerClass(String string) {
        if (string == null) {
            string = "None";
        }
        ApplicationProperties.setString((String)CURRENT_REASONER_PROPERTY, (String)string);
    }

    private ProtegeReasoner replaceReasoner(OWLModel oWLModel, Class clazz) {
        this.disposeReasoner(oWLModel);
        return this.createProtegeReasoner(oWLModel, clazz);
    }

    public void disposeReasoner(OWLModel oWLModel) {
        ProtegeReasoner protegeReasoner = this.owlModel2reasonerMap.get(oWLModel);
        try {
            if (protegeReasoner != null) {
                protegeReasoner.dispose();
                oWLModel.getProject().removeProjectListener(this.projectListener);
                this.owlModel2reasonerMap.remove(oWLModel);
            }
        }
        catch (Exception exception) {
            Log.getLogger().log(Level.WARNING, "Error at disposing reasoner " + protegeReasoner, exception);
        }
    }

    public Class getDefaultDIGReasonerClass() {
        return DefaultProtegeDIGReasoner.class;
    }

    public ProtegeReasoner setProtegeReasonerClass(OWLModel oWLModel, Class clazz) {
        ProtegeReasoner protegeReasoner = this.replaceReasoner(oWLModel, clazz);
        return protegeReasoner;
    }

    public ProtegeReasoner setProtegeReasonerClass(OWLModel oWLModel, String string) {
        Class<? extends ProtegeReasoner> clazz = null;
        if (string != null && !string.equals("None")) {
            clazz = ReasonerPluginManager.getReasonerJavaClass(string);
        }
        return this.setProtegeReasonerClass(oWLModel, clazz);
    }

    public boolean hasAttachedReasoner(OWLModel oWLModel) {
        return this.owlModel2reasonerMap.get(oWLModel) != null;
    }

    public void dispose() {
        for (OWLModel oWLModel : this.owlModel2reasonerMap.keySet()) {
            this.disposeReasoner(oWLModel);
        }
        this.owlModel2reasonerMap.clear();
        ReasonerUtil.getInstance().dispose();
    }

    static {
        ReasonerManager.initializeUncaughtExceptionHandler();
    }
}

