/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.translator;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGRenderer;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGQueryResponseIterator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DefaultDIGRenderer;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Iterator;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DefaultDIGTranslator
implements DIGTranslator {
    private DIGRenderer renderer = new DefaultDIGRenderer();
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    public static final String DL_NAMESPACE = "http://dl.kr.org/dig/2003/02/lang";

    public DefaultDIGTranslator() {
        try {
            this.docBuilderFactory = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", parserConfigurationException);
        }
    }

    public void setReasonerIdentity(DIGReasonerIdentity dIGReasonerIdentity) {
        this.renderer.setReasonerIdentity(dIGReasonerIdentity);
    }

    public Document createTellsDocument(String string) {
        Document document = this.createDIGDocument("tells", string);
        return document;
    }

    public Document createAsksDocument(String string) {
        Document document = this.createDIGDocument("asks", string);
        return document;
    }

    public Document createDIGDocument(String string, String string2) {
        Document document = this.createDIGDocument(string);
        document.getDocumentElement().setAttribute("uri", string2);
        return document;
    }

    public Document createDIGDocument(String string) {
        Document document = this.docBuilder.newDocument();
        Element element = document.createElement(string);
        element.setAttribute("xmlns", DL_NAMESPACE);
        document.appendChild(element);
        return document;
    }

    public void translateToDIG(OWLModel oWLModel, Document document, Node node) throws DIGReasonerException {
        this.renderer.render(oWLModel, document, node);
    }

    public void translateToDIG(RDFResource rDFResource, Document document, Node node) throws DIGReasonerException {
        if (rDFResource instanceof OWLNamedClass) {
            this.renderer.render((OWLNamedClass)rDFResource, document, node);
        } else if (rDFResource instanceof OWLSomeValuesFrom) {
            this.renderer.render((OWLSomeValuesFrom)rDFResource, document, node);
        } else if (rDFResource instanceof OWLAllValuesFrom) {
            this.renderer.render((OWLAllValuesFrom)rDFResource, document, node);
        } else if (rDFResource instanceof OWLMinCardinality) {
            this.renderer.render((OWLMinCardinality)rDFResource, document, node);
        } else if (rDFResource instanceof OWLMaxCardinality) {
            this.renderer.render((OWLMaxCardinality)rDFResource, document, node);
        } else if (rDFResource instanceof OWLCardinality) {
            this.renderer.render((OWLCardinality)rDFResource, document, node);
        } else if (rDFResource instanceof OWLIntersectionClass) {
            this.renderer.render((OWLIntersectionClass)rDFResource, document, node);
        } else if (rDFResource instanceof OWLUnionClass) {
            this.renderer.render((OWLUnionClass)rDFResource, document, node);
        } else if (rDFResource instanceof OWLComplementClass) {
            this.renderer.render((OWLComplementClass)rDFResource, document, node);
        } else if (rDFResource instanceof OWLEnumeratedClass) {
            this.renderer.render((OWLEnumeratedClass)rDFResource, document, node);
        } else if (rDFResource instanceof OWLObjectProperty) {
            this.renderer.render((OWLObjectProperty)rDFResource, document, node);
        } else if (rDFResource instanceof OWLDatatypeProperty) {
            this.renderer.render((OWLDatatypeProperty)rDFResource, document, node);
        } else if (rDFResource instanceof RDFIndividual) {
            this.renderer.render((RDFIndividual)rDFResource, document, node);
        } else if (rDFResource instanceof OWLHasValue) {
            this.renderer.render((OWLHasValue)rDFResource, document, node);
        } else {
            throw new IllegalArgumentException("Don't know how to translate " + rDFResource.getClass().getName());
        }
    }

    public Iterator getDIGQueryResponseIterator(OWLModel oWLModel, Document document) throws DIGReasonerException {
        return new DefaultDIGQueryResponseIterator(document, oWLModel);
    }

    protected Element createQueryElement(Document document, String string, String string2) {
        Element element = document.createElement(string);
        element.setAttribute("id", string2);
        return element;
    }

    public void createAllConceptNamesQuery(Document document, String string) {
        Element element = this.createQueryElement(document, "allConceptNames", string);
        document.getDocumentElement().appendChild(element);
    }

    public void createAllPropertyNamesQuery(Document document, String string) {
        Element element = this.createQueryElement(document, "allRoleNames", string);
        document.getDocumentElement().appendChild(element);
    }

    public void createAllIndividualsQuery(Document document, String string) {
        Element element = this.createQueryElement(document, "allIndividuals", string);
        document.getDocumentElement().appendChild(element);
    }

    public void createSatisfiableQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "satisfiable", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createSatisfiableQuery(Document document, String string, RDFSClass[] rDFSClassArray) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "satisfiable", string);
        Element element2 = document.createElement("and");
        element.appendChild(element2);
        for (int i = 0; i < rDFSClassArray.length; ++i) {
            this.translateToDIG(rDFSClassArray[i], document, (Node)element2);
        }
        document.getDocumentElement().appendChild(element);
    }

    public void createSubsumesQuery(Document document, String string, RDFSClass rDFSClass, RDFSClass rDFSClass2) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "subsumes", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        this.translateToDIG(rDFSClass2, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDisjointQuery(Document document, String string, RDFSClass rDFSClass, RDFSClass rDFSClass2) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "disjoint", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        this.translateToDIG(rDFSClass2, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperConceptsQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "parents", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperConceptsQuery(Document document, String string, RDFSClass[] rDFSClassArray) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "parents", string);
        Element element2 = document.createElement("and");
        element.appendChild(element2);
        for (int i = 0; i < rDFSClassArray.length; ++i) {
            this.translateToDIG(rDFSClassArray[i], document, (Node)element2);
        }
        document.getDocumentElement().appendChild(element);
    }

    public void createDirectSubConceptsQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "children", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createAncestorConceptsQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "ancestors", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDescendantConceptsQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "descendants", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createEquivalentConceptsQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "equivalents", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDirectSuperPropertiesQuery(Document document, String string, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "rparents", string);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDirectSubPropertiesQuery(Document document, String string, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "rchildren", string);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createAncestorPropertiesQuery(Document document, String string, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "rancestors", string);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createDescendantPropertiesQuery(Document document, String string, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "rdescendants", string);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createInstancesOfConceptQuery(Document document, String string, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "instances", string);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createIndividualTypesQuery(Document document, String string, RDFIndividual rDFIndividual) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "types", string);
        this.translateToDIG(rDFIndividual, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createIndividualInstanceOfConceptQuery(Document document, String string, RDFIndividual rDFIndividual, RDFSClass rDFSClass) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "instance", string);
        this.translateToDIG(rDFIndividual, document, (Node)element);
        this.translateToDIG(rDFSClass, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createPropertyFillersQuery(Document document, String string, RDFIndividual rDFIndividual, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "rolefillers", string);
        this.translateToDIG(rDFIndividual, document, (Node)element);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }

    public void createRelatedIndividualsQuery(Document document, String string, OWLProperty oWLProperty) throws DIGReasonerException {
        Element element = this.createQueryElement(document, "relatedIndividuals", string);
        this.translateToDIG(oWLProperty, document, (Node)element);
        document.getDocumentElement().appendChild(element);
    }
}

