/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.reasoner;

import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGErrorException;
import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerIdentity;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasonerPreferences;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLogger;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslator;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGTranslatorFactory;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultDIGReasoner
implements DIGReasoner {
    public static final String DEFAULT_URL_PROPERTY = "edu.stanford.smi.protegex.owl.jena.reasoner.URL";
    private static final String defaultURL = ApplicationProperties.getString((String)"edu.stanford.smi.protegex.owl.jena.reasoner.URL", (String)"http://localhost:8080");
    private URL reasonerURL;
    private DocumentBuilderFactory docBuilderFactory;
    private DocumentBuilder docBuilder;
    private XMLSerializer serializer;
    private OutputFormat format;
    private DIGTranslator translator = DIGTranslatorFactory.getInstance().createTranslator();
    public static boolean log = true;

    public DefaultDIGReasoner() {
        try {
            this.reasonerURL = new URL(defaultURL);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
        this.format = new OutputFormat();
        this.format.setIndent(4);
        this.format.setIndenting(true);
        this.format.setPreserveSpace(false);
        this.serializer = new XMLSerializer(this.format);
        this.docBuilderFactory = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            this.docBuilder = this.docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", parserConfigurationException);
        }
    }

    public void setReasonerURL(String string) {
        try {
            this.reasonerURL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", malformedURLException);
        }
    }

    public String getReasonerURL() {
        return this.reasonerURL.toString();
    }

    public DIGReasonerIdentity getIdentity() throws DIGReasonerException {
        Document document = this.translator.createDIGDocument("getIdentifier");
        Document document2 = this.performRequest(document);
        DIGReasonerIdentity dIGReasonerIdentity = new DIGReasonerIdentity();
        dIGReasonerIdentity.parseIdentityDescrtiption(document2);
        return dIGReasonerIdentity;
    }

    public String createKnowledgeBase() throws DIGReasonerException {
        Document document = this.translator.createDIGDocument("newKB");
        Document document2 = this.performRequest(document);
        Element element = (Element)document2.getDocumentElement().getElementsByTagName("kb").item(0);
        return element.getAttribute("uri");
    }

    public void releaseKnowledgeBase(String string) throws DIGReasonerException {
        Document document = this.translator.createDIGDocument("releaseKB");
        document.getDocumentElement().setAttribute("uri", string);
        this.performRequest(document);
    }

    public void clearKnowledgeBase(String string) throws DIGReasonerException {
        Document document = this.translator.createDIGDocument("tells", string);
        Element element = document.createElement("clearKB");
        document.getDocumentElement().appendChild(element);
        this.performRequest(document);
    }

    public Document performRequest(Document document) throws DIGReasonerException {
        if (DIGReasonerPreferences.getInstance().isLogDIG()) {
            this.log(document);
        }
        try {
            StringWriter stringWriter = new StringWriter();
            this.serializer.setOutputCharStream((Writer)stringWriter);
            this.serializer.serialize(document);
            HttpURLConnection httpURLConnection = (HttpURLConnection)this.reasonerURL.openConnection();
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            StringBuffer stringBuffer = stringWriter.getBuffer();
            httpURLConnection.setRequestProperty("Content-Length", "" + stringBuffer.length());
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write(stringBuffer.toString());
            outputStreamWriter.flush();
            outputStreamWriter.close();
            InputStreamReader inputStreamReader = new InputStreamReader(httpURLConnection.getInputStream());
            Document document2 = this.docBuilder.parse(new InputSource(inputStreamReader));
            ((Reader)inputStreamReader).close();
            httpURLConnection.disconnect();
            if (DIGReasonerPreferences.getInstance().isLogDIG()) {
                this.log(document2);
            }
            this.performErrorCheck(document2);
            return document2;
        }
        catch (IOException iOException) {
            throw new DIGReasonerException(iOException.getMessage(), iOException);
        }
        catch (SAXException sAXException) {
            throw new DIGReasonerException(sAXException.getMessage(), sAXException);
        }
    }

    protected void performErrorCheck(Document document) throws DIGErrorException {
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("error");
        if (nodeList.getLength() > 0) {
            Object object;
            ArrayList<DIGError> arrayList = new ArrayList<DIGError>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                object = (Element)nodeList.item(i);
                String string = object.getAttribute("message") + " [ID: " + object.getAttribute("id") + "]";
                String string2 = ((Element)nodeList.item(i)).getAttribute("code");
                DIGError dIGError = new DIGError(object.getAttribute("id"), string, string2);
                arrayList.add(dIGError);
            }
            if (!DIGReasonerPreferences.getInstance().isTreatErrorsAsWarnings()) {
                throw new DIGErrorException(arrayList);
            }
            DIGLogger dIGLogger = DIGLogger.getInstance(this);
            object = arrayList.iterator();
            while (object.hasNext()) {
                dIGLogger.logError((DIGError)object.next());
            }
        }
    }

    protected void log(Document document) {
        StringWriter stringWriter = new StringWriter();
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setIndent(4);
        outputFormat.setIndenting(true);
        XMLSerializer xMLSerializer = new XMLSerializer(DIGReasonerPreferences.getInstance().getLogOutputStream(), outputFormat);
        try {
            xMLSerializer.serialize(document);
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
        Logger.getLogger("edu.stanford.smi.protegex.owl.inference.dig.reasoner").info(stringWriter.getBuffer().toString());
    }
}

