/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.server.ClientInitializerKnowledgeBaseFactory;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.MessageError;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseModel;
import edu.stanford.smi.protegex.owl.database.triplestore.DatabaseTripleStoreModel;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.factory.OWLJavaFactory;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.resource.OWLText;
import edu.stanford.smi.protegex.owl.storage.OWLKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OWLDatabaseKnowledgeBaseFactory
extends DatabaseKnowledgeBaseFactory
implements OWLKnowledgeBaseFactory,
ClientInitializerKnowledgeBaseFactory {
    private static Logger log = Log.getLogger(OWLDatabaseKnowledgeBaseFactory.class);

    public OWLDatabaseKnowledgeBaseFactory() {
        this.setOwlMode(true);
    }

    public KnowledgeBase createKnowledgeBase(Collection collection) {
        ResourceSelectionAction.setActivated(false);
        OWLDatabaseModel oWLDatabaseModel = new OWLDatabaseModel(this);
        return oWLDatabaseModel;
    }

    private void dump(Cls cls, String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(string + cls);
            for (Cls cls2 : cls.getDirectSubclasses()) {
                if (cls2.isEditable()) continue;
                try {
                    this.dump(cls2, string + "  ");
                }
                catch (Exception exception) {
                    log.fine("ERROR at " + cls + " / " + cls2);
                    for (Object e : cls2.getDirectSubclasses()) {
                        log.fine("- " + e + " = " + (e instanceof Slot) + " " + ((Instance)e).getDirectType());
                    }
                    Log.getLogger().log(Level.SEVERE, "Exception caught", exception);
                }
            }
        }
    }

    public String getProjectFilePath() {
        return "OWL.pprj";
    }

    public String getDescription() {
        return "OWL / RDF Database";
    }

    public void loadKnowledgeBase(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, Collection collection) {
        OWLDatabaseModel oWLDatabaseModel = (OWLDatabaseModel)knowledgeBase;
        super.loadKnowledgeBase(knowledgeBase, string, string2, string3, string4, string5, collection);
        oWLDatabaseModel.initialize();
    }

    protected void initializeKB(KnowledgeBase knowledgeBase, String string, String string2, String string3, String string4, String string5, boolean bl) {
        AbstractOWLModel abstractOWLModel = (AbstractOWLModel)knowledgeBase;
        Object object = abstractOWLModel.getFrameFactory();
        if (!(object instanceof OWLJavaFactory)) {
            Log.getLogger().warning("Adapting the java factory to OWLJavaFactory");
            object = new OWLJavaFactory(abstractOWLModel);
        }
        DatabaseFrameDb databaseFrameDb = OWLDatabaseKnowledgeBaseFactory.getDatabaseFrameDb((KnowledgeBase)abstractOWLModel);
        databaseFrameDb.initialize(object, string, string2, string3, string4, string5, bl);
        knowledgeBase.flushCache();
    }

    public void saveKnowledgeBase(KnowledgeBase knowledgeBase, PropertyList propertyList, Collection collection) {
        if (knowledgeBase instanceof OWLModel) {
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            propertyList.setInteger("owl_build", OWLText.getBuildNumber());
            if (oWLModel instanceof JenaOWLModel) {
                knowledgeBase.removeFrameStore((FrameStore)oWLModel.getOWLFrameStore());
            }
            super.saveKnowledgeBase(knowledgeBase, propertyList, collection);
            if (oWLModel instanceof JenaOWLModel) {
                knowledgeBase.insertFrameStore((FrameStore)oWLModel.getOWLFrameStore(), 0);
            }
        } else {
            String string = "You can only save OWL projects to OWL Database format.";
            collection.add(new MessageError(string));
            Log.getLogger().severe(string);
        }
    }

    protected void updateKnowledgeBase(DefaultKnowledgeBase defaultKnowledgeBase) {
    }

    public void initializeClientKnowledgeBase(FrameStore frameStore, NarrowFrameStore narrowFrameStore, NarrowFrameStore narrowFrameStore2, KnowledgeBase knowledgeBase) {
        if (knowledgeBase instanceof OWLDatabaseModel) {
            OWLDatabaseModel oWLDatabaseModel = (OWLDatabaseModel)knowledgeBase;
            DatabaseTripleStoreModel databaseTripleStoreModel = new DatabaseTripleStoreModel(oWLDatabaseModel, narrowFrameStore, narrowFrameStore2);
            oWLDatabaseModel.setTripleStoreModel(databaseTripleStoreModel);
            oWLDatabaseModel.initializeClient();
            oWLDatabaseModel.adjustClientFrameStores();
        }
    }
}

