/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.database;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.database.DatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.Wizard;
import edu.stanford.smi.protege.util.WizardPage;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.database.OWLDatabasePlugin;
import edu.stanford.smi.protegex.owl.database.OWLDatabaseWizardPage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;

public class CreateOWLDatabaseProjectPlugin
extends AbstractCreateProjectPlugin
implements OWLDatabasePlugin {
    private String driver;
    private String table;
    private String username;
    private String password;
    protected URI ontologyFileURI;
    private String url;

    public CreateOWLDatabaseProjectPlugin() {
        this("OWL Database");
    }

    public CreateOWLDatabaseProjectPlugin(String string) {
        super(string);
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory.getClass() == OWLDatabaseKnowledgeBaseFactory.class;
    }

    public Project createNewProject(KnowledgeBaseFactory knowledgeBaseFactory) {
        ArrayList arrayList = new ArrayList();
        Project project = super.createNewProject(knowledgeBaseFactory);
        this.initializeSources(project.getSources());
        try {
            File file = File.createTempFile("protege", "temp");
            project.setProjectFilePath(file.getPath());
            project.save(arrayList);
            if (arrayList.isEmpty()) {
                project = Project.loadProjectFromFile((String)file.getPath(), arrayList);
            }
            this.handleErrors(arrayList);
            project.setProjectFilePath(null);
            file.delete();
        }
        catch (IOException iOException) {
            Log.getLogger().severe(Log.toString((Throwable)iOException));
        }
        return project;
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        return new OWLDatabaseWizardPage((Wizard)createProjectWizard, this, bl);
    }

    protected void initializeSources(PropertyList propertyList) {
        DatabaseKnowledgeBaseFactory.setSources((PropertyList)propertyList, (String)this.driver, (String)this.url, (String)this.table, (String)this.username, (String)this.password);
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setOntologyFileURI(URI uRI) {
        this.ontologyFileURI = uRI;
    }

    public void setTable(String string) {
        this.table = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }
}

